const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
class TradeMarkService extends ServiceBase {
  constructor() {
    super("dbtrademark", ServiceBase.getDaoName(TradeMarkService));
    this.ordertmproductSve = system.getObject("service.dborder.ordertmproductSve");
    this.tmofficialDao = system.getObject("db.dbtrademark.tmofficialDao");
    this.orderflowDao = system.getObject("db.dborder.orderflowDao");
    this.statusConvertJSON = {
      "WAITARTIFICIALEXAMINE": "dsh",
      "1": "1",
      "2": "2",
      "3": "3",
      "4": "4",
      "5": "5",
      "6": "6",
      "7": "7",
      "8": "8",
      "9": "9",
      "10": "10",
      "11": "11",
      "12": "12",
      "13": "13",
      "READY": "dsccl",
      "DOCFINISH": "dsh",
      "AWAITCHECK": "dsh",
      "WAITCOMMIT": "ddj",
      "COMMITED": "ydj",
      "ROBOT": "ydj",
      "ROBOTPAY": "ydj",
      "RECVCOMMIT": "ydj",
      "FILLEXCEPTION": "shbtg",
      //1688
      "WAITCONFIRM": "dqrfa",
      "CONFIRMFAIL": "dqrfa"
    }
  }

  /**
   * 修改商标信息 （订单详情页面使用）
   * @param {*} obj 
   * obj.deliveryOrderNo 交付订单号，
   * obj.tmName  商标名称，
   * obj.tmFormType 商标类型，
   * obj.notes 商标说明，
   * obj.picUrl 商标图样,
   * obj.colorizedPicUrl 商标彩色图样,
   * obj.user 用户数据
   */
  async updateTmInfo(obj) {
    var user = obj.user;
    var app = obj.app;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!app || !app.id) {
      return system.getResultFail(-100, "未知渠道");
    }
    var deliveryOrderNo = obj.deliveryOrderNo;
    if (!deliveryOrderNo) {
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where: { deliveryOrderNo: deliveryOrderNo,app_id:app.id },
      raw: true
    });
    if (!ordertmproduct || !ordertmproduct.id) {
      return system.getResultFail(-102, "商标交付单不存在");
    }
    // 2.获取交付单状态，判断是否可修改
    if (ordertmproduct.deliveryStatus == 'ddj' || ordertmproduct.deliveryStatus == 'ywc') {
      var deliveryStatusName = "待递交";
      if (ordertmproduct.deliveryStatus == 'ywc') {
        deliveryStatusName = "已完成";
      }
      return system.getResultFail(-103, "该商标交付单状态为" + deliveryStatusName + ",不能进行修改");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      var otpObj = {
        id: ordertmproduct.id,
        deliveryOrderNo: deliveryOrderNo,
        updateuser_id: user.id,
        updateuser: user.nickname
      };
      if (obj.picUrl) {//商标图样 黑白
        otpObj["picUrl"] = obj.picUrl;
      }
      if (obj.colorizedPicUrl) {//彩色商标图样
        otpObj["colorizedPicUrl"] = obj.colorizedPicUrl;
      }
      if (obj.tmName) {//商标名称
        otpObj["tmName"] = obj.tmName;
      }
      if (obj.tmFormType) {//商标类型
        otpObj["tmFormType"] = obj.tmFormType;
      }
      if (obj.notes) {//商标说明
        otpObj["notes"] = obj.notes;
      }
      await self.ordertmproductSve.dao.update(otpObj, t);//商标交付单 修改商标图样
      var logMsg = { sourceOrderNo: deliveryOrderNo, opContent: "修改订单信息", app_id: app.id, isShow: 1 };
      await self.orderflowDao.create(logMsg, t);
      return system.getResultSuccess();
    })
  }

  /**
   * 修改商标尼斯信息 （订单详情页面使用）
   * @param {*} obj 
   * obj.tbCode 商标提报号，
   * obj.deliveryOrderNo 交付订单号，
   * obj.nclOneCodes 商标尼斯大类，
   * obj.nclSmallCodes 商标尼斯小类数组
   * obj.user 用户数据
   */
  async updateNclInfo(obj) {
    var user = obj.user;
    var app = obj.app;
    var self = this;
    if (!user || !user.id) {
      return system.getResultFail(-100, "未知用户");
    }
    if (!app || !app.id) {
      return system.getResultFail(-100, "未知渠道");
    }
    var deliveryOrderNo = obj.deliveryOrderNo;
    if (!deliveryOrderNo) {
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where: { deliveryOrderNo: deliveryOrderNo,app_id:app.id },
      raw: true
    });
    if (!ordertmproduct || !ordertmproduct.id) {
      return system.getResultFail(-102, "商标交付单不存在");
    }
    // 2.获取交付单状态，判断是否可修改
    if (ordertmproduct.deliveryStatus == 'ddj' || ordertmproduct.deliveryStatus == 'ywc') {
      var deliveryStatusName = "待递交";
      if (ordertmproduct.deliveryStatus == 'ywc') {
        deliveryStatusName = "已完成";
      }
      return system.getResultFail(-103, "该商标交付单状态为" + deliveryStatusName + ",不能进行修改");
    }
    var tbCode = obj.tbCode;
    if (!tbCode) {
      return system.getResultFail(-104, "tbCode参数错误");
    }
    //获取商标尼斯信息
    var tm = await this.dao.model.findOne({
      where: { tbCode: tbCode },
      raw: true
    });

    if (!tm || !tm.id) {
      return system.getResultFail(-105, "尼斯信息不存在");
    }
    //获取交付单下其它商标尼斯信息
    var othertm = await this.dao.model.findAll({
      where: {
        deliveryOrderNo: deliveryOrderNo,
        tbCode: { [self.db.Op.ne]: tbCode }
      },
      raw: true
    });
    if (!obj.nclOneCodes) {
      return system.getResultFail(-106, "nclOneCodes参数错误");
    }
    if (!obj.nclSmallCodes || obj.nclSmallCodes.length < 1) {
      return system.getResultFail(-107, "nclSmallCodes参数错误");
    }
    if (obj.nclSmallCodes.length > 10) {
      return system.getResultFail(-108, "尼斯小类不能超过10项");
    }
    var nclOneCodes2 = obj.nclOneCodes;
    for (var i = 0; i < othertm.length; i++) {//判断重复大类
      var other = othertm[i];
      if (other.nclOneCodes == obj.nclOneCodes) {
        return system.getResultFail(-109, "该商标存在重复的尼斯大类");
      } else {
        nclOneCodes2 = nclOneCodes2 + "," + other.nclOneCodes;
      }
    }
    return await self.db.transaction(async function (t) {
      var tmObj = {
        id: tm.id,
        nclOneCodes: obj.nclOneCodes,
        nclSmallCodes: JSON.stringify(obj.nclSmallCodes),
        updateuser_id: user.id,
        updateuser: user.nickname
      };
      await self.dao.update(tmObj, t);//修改商标尼斯信息
      var otpObj = {
        id: ordertmproduct.id,
        nclOneCodes: nclOneCodes2,
        updateuser_id: user.id,
        updateuser: user.nickname
      };
      await self.ordertmproductSve.dao.update(otpObj, t);//商标交付单 修改大类列表
      var logMsg = { sourceOrderNo: deliveryOrderNo, opContent: "修改订单信息", app_id: app.id, isShow: 1 };
      await self.orderflowDao.create(logMsg, t);
      return system.getResultSuccess();
    })
  }
  /**
   * 接收商标回执数据
   * @param {*} obj 
   * obj.tbCode 商标提报号，
   * obj.deliveryOrderNo 交付订单号，
   * obj.officialType 商标状态类型officialType,
   * 1: 商标注册申请书, 2: 商标注册申请补正通知书, 3: 商标注册申请受理通知书, 4: 商标注册申请不予受理通知书, 
     5: 商标注册同日申请补送使用证据通知书,6: 商标注册同日申请协商通知书商标注册同日申请抽签通知书, 
     7: 商标驳回通知书, 8: 商标部分驳回通知书, 9: 商标注册申请初步审定公告通知书,                                                                                                                                                                                                                                                                                                                                 
     10: 商标异议答辩通知书, 11: 异议裁定书, 12: 纸质版商标注册证, 13: 电子版商标注册证  
     "dsccl": "待上传材料", "dsh": "待审核", "shbtg": "审核不通过", "ddj": "待递交",
     "ydj": "已递交", "djyc": "递交异常"   ,  
   * obj.tmRegistNum 商标注册号,
   * obj.officialFileName 官文文件名称   ,
   * obj.officialFileUrl 官文文件地址  ,
   */
  async receiveTmOfficialData(obj) {
    // return system.getResultFail(-100, "接口开发中");
    // var user = obj.user;
    // var app = obj.app;
    var self = this;
    // if(!user || !user.id){
    //   return system.getResultFail(-100, "未知用户");
    // }
    var deliveryOrderNo = obj.deliveryOrderNo;
    if (!deliveryOrderNo) {
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where: { deliveryOrderNo: deliveryOrderNo },
      raw: true
    });
    if (!ordertmproduct || !ordertmproduct.id) {
      return system.getResultFail(-102, "商标交付单不存在");
    }
    // if(!app){
    //   return system.getResultFail(-103, "未知应用");
    // }
    var tbCode = obj.tbCode;
    if (!tbCode) {
      return system.getResultFail(-104, "tbCode参数错误");
    }
    //获取商标尼斯信息
    var tm = await this.dao.model.findOne({
      where: { tbCode: tbCode, deliveryOrderNo: deliveryOrderNo },
      raw: true
    });
    if (!tm || !tm.id) {
      return system.getResultFail(-105, "尼斯信息不存在");
    }
    return await self.db.transaction(async function (t) {
      var tmObj = {
        id: tm.id
      };
      var officialObj = {
        app_id: ordertmproduct.app_id
      };
      if (obj.officialType) {
        if (self.statusConvertJSON[obj.officialType]) {
          tmObj["officialType"] = self.statusConvertJSON[obj.officialType];
          officialObj["officialType"] = self.statusConvertJSON[obj.officialType];
        }
      }
      if (obj.tmRegistNum) {
        officialObj["tmRegistNum"] = obj.tmRegistNum;
        tmObj["tmRegistNum"] = obj.tmRegistNum;
      }
      await self.dao.update(tmObj, t);//修改商标状态信息
      if (officialObj["tmRegistNum"] && officialObj["officialType"]) {
        if (obj.officialFileName) {
          officialObj["officialFileName"] = obj.officialFileName;
        }
        if (obj.officialFileUrl) {
          officialObj["officialFileUrl"] = obj.officialFileUrl;
        }
        var code = await self.getBusUid("tmoff");
        officialObj["code"] = code;
        await self.tmofficialDao.create(officialObj, t);
      }
      return system.getResultSuccess();
    })
  }
  /**
   * 辅助商标状态修改
   * @param {*} obj 
   */
  async updateAssistTmStatus(obj) {
    var self = this;
    var deliveryOrderNo = obj.channelOrderNum;
    if (!deliveryOrderNo) {
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where: { deliveryOrderNo: deliveryOrderNo },
      raw: true
    });
    if (!ordertmproduct || !ordertmproduct.id) {
      return system.getResultFail(-102, "商标交付单不存在");
    }
    var tbCode = obj.proxyCode;
    if (!tbCode) {
      return system.getResultFail(-104, "tbCode参数错误");
    }
    //获取商标尼斯信息
    var tm = await this.dao.model.findOne({
      where: { tbCode: tbCode, deliveryOrderNo: deliveryOrderNo },
      raw: true
    });
    if (!tm || !tm.id) {
      return system.getResultFail(-105, "商标信息不存在");
    }
    return await self.db.transaction(async function (t) {
      var tmObj = { id: tm.id };
      var otp = { id: ordertmproduct.id };
      if (obj.tmStatus) {
        if (self.statusConvertJSON[obj.tmStatus]) {
          tmObj["officialType"] = self.statusConvertJSON[obj.tmStatus];
        }
        if (tmObj.officialType && ",dqrfa,dsccl,dsh,ddj,ydj,ywc,".indexOf(tmObj.officialType) >= 0) {
          otp["deliveryStatus"] = tmObj.officialType;
          await self.ordertmproductSve.update(otp, t);
        }
        // {"dqrfa":"待确认方案", "dsccl": "待上传材料", "dsh": "待审核", "ddj": "待递交", "ydj": "已递交", "ywc": "已完成" },
      }
      if (obj.opNotes) {
        tmObj["opNotes"] = obj.opNotes;
      }
      if (obj.submitTime) {
        tmObj["submitTime"] = obj.submitTime;
      }
      if(obj.tmRegistNum){
        tmObj["tmRegistNum"]=obj.tmRegistNum;
      }
      await self.dao.update(tmObj,t);//修改商标状态信息
      var deliveryStatusName = uiconfig.config.pdict.official_type[tmObj.officialType];
      var flowObj = {
        isShow: 1,
        app_id: ordertmproduct.app_id,
        createuser_id: ordertmproduct.createuser_id,
        sourceOrderNo: deliveryOrderNo,
        opContent: "第" + tm.nclOneCodes + "类商标状态更新为【" + deliveryStatusName + "】" + obj.opNotes
      };
      await self.orderflowDao.create(flowObj, t);//创建交付流程
      await self.dao.update(tmObj, t);//修改商标状态信息
      return system.getResultSuccess();
    })
  }
}
module.exports = TradeMarkService;
