const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class OrderService extends ServiceBase {
  constructor() {
    super("dborder", ServiceBase.getDaoName(OrderService));
    this.logCtl = system.getObject("service.common.oplogSve");
    this.orderflowDao = system.getObject("db.dborder.orderflowDao");
    this.appproductDao = system.getObject("db.dbapp.appproductDao");
    this.ordertmproductDao = system.getObject("db.dborder.ordertmproductDao");
    this.receiptvoucherDao = system.getObject("db.dborder.receiptvoucherDao");
    this.customercontactsDao = system.getObject("db.dborder.customercontactsDao");
    this.execClient = system.getObject("util.execClient");
    this.fqReqUrl = "https://yunfuapi.gongsibao.com";//线上域名
    // this.fqReqUrl = "https://yunfuapi-dev.gongsibao.com";//dev域名
    this.restClient = system.getObject("util.restClient");
    this.appDao = system.getObject("db.dbapp.appDao");
  }

  async addOrderAndDelivery(action_body, pobj, req) {
    if (!action_body.needNo) {
      return system.getResult(null, "needNo is empty");
    }
    if (!action_body.channelItemCode) {
      return system.getResult(null, "channelItemCode is empty");
    }
    var productItem = await this.appproductDao.findOneByChannelItemCode(action_body.channelItemCode, req.app.id);//获取产品
    if (!productItem) {
      return system.getResult(null, action_body.channelItemCode + " productItem is empty");;
    }
    var orderCount = await this.dao.findCount({ where: { needNo: action_body.needNo } });
    if (orderCount > 0) {
      return system.getResultFail(system.existData, "order is exist");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      //创建订单
      var ordercode = await self.getBusUid("tm");
      var orderParams = {
        app_id: req.app.id,//                                                                                                                                                                                                
        orderNo: ordercode,// 订单号        
        payTime: new Date(),//
        itemCode: productItem.itemCode,//                                                                                                                                                                                                 
        itemName: productItem.itemName,//                                                                                                                                                                                                 
        channelItemCode: productItem.channelItemCode,// 渠道产品编码                                                                                                                                                                               
        channelItemName: productItem.channelItemName,// 渠道产品名称                                                                                                                                                                               
        salesNum: 1,//项目订单数量（即服务项目的倍数，默认值为1）          
        salesDiliverNum: 0,//项目订单交付数量（即与项目订单数量相对应）                                                                                                                             
        minitermNum: 10,//订单小项数量                                                                                                                                
        minitermDiliverNum: 0,//订单小项交付数量                                                                                                                                
        orderType: "dkxd",// 订单类型，zzdd: 自主订单,dkxd: 代客下单                                                                                                                                             
        orderPayStatus: "yfk",// 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过  
        totalServiceCharge: productItem.totalServiceCharge || 0,// 服务费总额（产品配置的服务费*订单件数）                                                                                                                                       
        totalPublicExpense: productItem.totalPublicExpense || 0,// 官费总额（产品配置的官费*订单件数）                                                                                                                                             
        totalSum: productItem.proPrice || 0,// 订单总额(产品价格×优惠费率×订单件数)                                                                                                                                           
        refundSum: 0,// 退款金额    
        buyerMoblie: action_body.buyerMoblie || "",
        // notes: apply.notes, //备注                                                                                                                                                                                          
        appPayType: "00",// 支付类型：00第三方支付，10平台代收款                                                                                                                                             
        payAccountType: "other",// 帐户类型（ 支付类型）:cash: 现金, bank: 银行,wx:微信,alipay:支付,other:其它                                                                                                                                                                                    
        createuser_id: req.user.id,
        owner_id: req.user.id,//                                                                                                                                                                                                 
        creator: req.user.nickname || "",
        owner: req.user.nickname || "",//                                                                                                                                                                                                  
        ownerMoblie: req.user.userMoblie || "",//                                                                                                                                                                     
        invoiceApplyStatus: "00",// 发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                                                               
        channelUserId: req.user.channelUserId || "",// 渠道用户id  
        needNo: action_body.needNo || null,//需求单号
        needNoOrderNo: action_body.needNoOrderNo || null,//需求单号
        picUrl: productItem.picUrl,//                                                                                                                             
        productType_id: productItem.productType_id,//产品类型Id                                                                                                               
        productOneType_id: productItem.productOneType_id,//产品大类Id                                                                                                               
        serviceItemSnapshot: JSON.stringify(productItem),//产品快照        
      };
      var orderItem = await self.dao.create(orderParams, t);//创建订单
      var receiptvoucherItem = await self.receiptvoucherDao.addReceiptvoucher(orderParams, req, t);//创建订单支付信息
      var pushType = "ic_";
      var orderProductObj = {};
      if (["fzsbzc", "dbsbzc"].indexOf(productItem.itemCode) >= 0) {
        var tmDeliveryOrderNo = await self.getBusUid("jf")
        orderProductObj = {
          app_id: req.app.id,//   
          productType_id: productItem.productType_id,//产品类型Id                                                                                                               
          productOneType_id: productItem.productOneType_id,//产品大类Id      
          itemCode: productItem.itemCode,//                                                                                                                                                                                                 
          itemName: productItem.itemName,//                                                                                                                                       
          orderServicePayStatus: "yfk",//支付状态:dfk: 待付款, yfk: 已支付 
          deliveryStatus: "dfwsfw",
          deliveryStatusName: "待服务",
          appDataOpType: req.app.appDataOpType,// 应用数据操作类型：00独立，10全委托，20部分委托     
          sourceOrderNo: ordercode,//来源单号   
          deliveryOrderNo: tmDeliveryOrderNo,
          needNo: action_body.needNo || null,//需求单号
          needNoOrderNo: action_body.needNoOrderNo || null,//需求单号
          sourceType: "00",
          channelUserId: req.user.channelUserId || "",// 渠道用户id  
          createuser_id: req.user.id,//                                                                                                                           
          createuser: req.user.nickname,//             
        };
        var orderTm = await self.ordertmproductDao.create(orderProductObj, t);//创建订单交付流程
        pushType = "tm_";
      }//创建服务单
      //推送商机到峰擎
      if (productItem.pushServiceItemCode && orderParams.buyerMoblie) {
        self.pushFqBusiness(pushType, orderParams, productItem.pushServiceItemCode, pobj, req);
      } else {
        self.logCtl.info({
          appid: req.app.id,
          appkey: req.app.uappKey,
          requestId: req.requestId || "",
          op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/addOrderAndDelivery",
          content: "pushServiceItemCode=" + productItem.pushServiceItemCode + "，buyerMoblie=" + action_body.buyerMoblie,
          clientIp: pobj.clientIp,
          optitle: "未能推送订单商机到FQ信息，pushServiceItemCode 或 buyerMoblie 为空",
        });
      }
      return system.getResultSuccess({
        orderNo: ordercode,
        deliveryOrderNo: orderProductObj.deliveryOrderNo || ordercode,
        needNo: action_body.needNo
      });
    });
  }
  //关联订单对应的需求ID和需求订单号--渠道web用
  async updateOrderStatus(action_body, pobj, req) {
    // var setObj = { channelServiceNo: action_body.channelServiceNo, needNo: action_body.needNo, needNoOrderNo: action_body.needNoOrderNo };
    var setObj = { needNo: action_body.needNo, needNoOrderNo: action_body.needNoOrderNo };
    var self = this;
    return await this.db.transaction(async function (t) {
      await self.dao.updateByWhere(setObj, { where: { orderNo: action_body.orderNo } }, t);
      await self.ordertmproductDao.updateByWhere(setObj, { where: { sourceOrderNo: action_body.orderNo } }, t);
      return system.getResultSuccess();
    });
  }
  //更新付款状态--渠道web用
  async updateOrderPayStatus(action_body, pobj, req) {
    var payStatus = action_body.payStatus || "dfk";
    var self = this;
    var result = await self.ordertmproductDao.getItemByNeedNoOrderNo(action_body.needNoOrderNo, req.app.id);
    if (!result) {
      return system.getResult(null, "data is empty");
    }
    return await this.db.transaction(async function (t) {
      await self.dao.updateByWhere({ orderPayStatus: payStatus, buyerMoblie: action_body.buyerMoblie || "" }, { where: { needNoOrderNo: action_body.needNoOrderNo, app_id: req.app.id } }, t);
      await self.ordertmproductDao.updateByWhere({ payStatus: payStatus }, { where: { needNoOrderNo: action_body.needNoOrderNo, app_id: req.app.id } }, t);
      var logMsg = { sourceOrderNo: result.deliveryOrderNo, opContent: "订单已成功支付", app_id: req.app.id, isShow: 1 };
      await self.orderflowDao.create(logMsg, t);
      return system.getResultSuccess({ deliveryOrderNo: result.deliveryOrderNo });
    });
  }
  async op1688ChannelPushOrder(action_body, pobj, req) {
    try {
      //var reqUrl = "https://inte-mcp.chanjet.com/gsb/getOrder?token=" + action_body.token; //测试环境
      var reqUrl = "https://mcp.chanjet.com/gsb/getOrder?token=" + action_body.token; //线上环境
      var rtn = await this.execClient.execGet("", reqUrl);
      var logParam = {
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/opChannelCallbackData",
        content: "请求地址：" + reqUrl,
        clientIp: pobj.clientIp,
        optitle: "渠道回调信息返回结果：" + rtn.stdout,
      };

      this.logCtl.info(logParam);
      var result = JSON.parse(rtn.stdout);
      // var result = { "returnValue": [{ "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119162048000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938409910_1", "gmtServiceBegin": null, "gmtConfirm": "20191119162051000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119161008000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938409527_1", "gmtServiceBegin": null, "gmtConfirm": "20191119161011000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119130813000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938403044_1", "gmtServiceBegin": null, "gmtConfirm": "20191119130816000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119125011000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938402638_1", "gmtServiceBegin": null, "gmtConfirm": "20191119125017000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119110329000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938399256_1", "gmtServiceBegin": null, "gmtConfirm": "20191119110332000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191119104737000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111938398567_1", "gmtServiceBegin": null, "gmtConfirm": "20191119104740000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }, { "bizStatusExt": "audit_pass", "memberId": "b2b-1624961198", "productName": "【商标注册】自助注册申请", "gmtCreate": "20191118191753000+0800", "gmtServiceEnd": null, "bizStatus": "B", "paymentAmount": 0.0, "executePrice": 0, "orderItemNum": "W19111838384729_1", "gmtServiceBegin": null, "gmtConfirm": "20191118191755000+0800", "settleItemDtos": [], "payCustomerUid": "1875826463", "signCustomerUid": "1875826463" }], "successed": true, "errorMsg": null };
      if (result && result.successed && result.successed == true && result.returnValue && result.returnValue.length) {
        await this.addOrderNeed(action_body, req, result.returnValue);
      }//操作需求
      return system.getResultSuccess();
    } catch (e) {
      console.log(e.stack, "渠道回调信息返回结果：error......1.....");
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/opChannelCallbackData",
        content: "error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "渠道回调信息返回结果：" + rtn.stdout,
      });
    }
  }
  async op1688ChannelPushOrderTest(action_body, pobj, req) {
    try {

      var returnValue = [
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_01",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_02",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_03",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_04",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_05",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_06",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_07",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_08",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_09",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_10",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_11",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_12",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_13",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_14",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_15",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_16",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_17",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_18",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_19",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        },
        {
          "bizStatusExt": "service",
          "memberId": "b2b-****02",
          "productName": "商机**",
          "gmtCreate": "20171231200252000+0800",
          "gmtServiceEnd": "20190101000000000+0800",
          "bizStatus": "S",
          "paymentAmount": 420,
          "executePrice": 420,
          "orderItemNum": "eeeee3120025200_20",
          "gmtServiceBegin": "20171231000000000+0800",
          "gmtConfirm": "20171231200329000+0800",
          "settleItemDtos": [],
          "payCustomerUid": "12345678990000",
          "signCustomerUid": "12345678990000"
        }
      ];
      await this.addOrderNeed(action_body, req, returnValue);
      return system.getResultSuccess();
    } catch (e) {
      console.log(e.stack, "渠道回调信息返回结果：error...........");
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "/igirl-channel/zhichan/igirl-channel/app/base/service/impl/dborder/orderSve/opChannelCallbackData",
        content: "请求地址：" + reqUrl + "，error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "渠道回调信息返回结果：" + rtn.stdout,
      });
    }
  }
  async addOrderNeed(action_body, req, returnValue) {
    var productItem = await this.appproductDao.findOneByChannelItemCode(action_body.channelItemCode, req.app.id);//获取产品
    if (!productItem) {
      return;
    }
    var self = this;
    //创建订单
    var ordercode = await this.getBusUid("ts");
    for (let index = 0; index < returnValue.length; index++) {
      const element = returnValue[index];
      if (element) {
        if (element.bizStatusExt == "service" || element.bizStatusExt == "audit_pass") {
          var orderCount = await self.findCount({ where: { needNo: element.orderItemNum } });
          if (orderCount > 0) {
            continue;
          }
          var payTime = null;
          if (element.gmtCreate && element.gmtCreate.length > 14) {
            payTime = element.gmtCreate.substr(0, 4) + "-" + element.gmtCreate.substr(4, 2) +
              "-" + element.gmtCreate.substr(6, 2) + " " + element.gmtCreate.substr(8, 2) + ":" +
              element.gmtCreate.substr(10, 2) + ":" + element.gmtCreate.substr(12, 2);
          }
          await self.db.transaction(async function (t) {
            //创建订单
            var ordercode = await self.getBusUid("tm");
            var orderParams = {
              app_id: req.app.id,//                                                                                                                                                                                                
              orderNo: ordercode,// 订单号                                                                                                                                                                                        
              channelServiceNo: element.orderItemNum,// 渠道服务单号 
              payTime: payTime,//
              itemCode: productItem.itemCode,//                                                                                                                                                                                                 
              itemName: productItem.itemName,//                                                                                                                                                                                                 
              channelItemCode: productItem.channelItemCode,// 渠道产品编码                                                                                                                                                                               
              channelItemName: productItem.channelItemName,// 渠道产品名称                                                                                                                                                                               
              salesNum: 1,//项目订单数量（即服务项目的倍数，默认值为1）          
              salesDiliverNum: 0,//项目订单交付数量（即与项目订单数量相对应）                                                                                                                             
              minitermNum: 10,//订单小项数量                                                                                                                                
              minitermDiliverNum: 0,//订单小项交付数量                                                                                                                                
              orderType: "dkxd",// 订单类型，zzdd: 自主订单,dkxd: 代客下单                                                                                                                                             
              orderPayStatus: "yfk",// 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过  
              totalServiceCharge: productItem.totalServiceCharge || 0,// 服务费总额（产品配置的服务费*订单件数）                                                                                                                                       
              totalPublicExpense: productItem.totalPublicExpense || 0,// 官费总额（产品配置的官费*订单件数）                                                                                                                                             
              totalSum: element.executePrice || 0,// 订单总额(产品价格×优惠费率×订单件数)                                                                                                                                           
              refundSum: 0,// 退款金额                                                                                                                                                                                     
              // notes: apply.notes, //备注                                                                                                                                                                                          
              appPayType: "00",// 支付类型：00第三方支付，10平台代收款                                                                                                                                             
              payAccountType: "other",// 帐户类型（ 支付类型）:cash: 现金, bank: 银行,wx:微信,alipay:支付,other:其它                                                                                                                                                                                    
              createuser_id: req.user.id,
              owner_id: req.user.id,//                                                                                                                                                                                                 
              creator: req.user.nickname || "",
              owner: req.user.nickname || "",//                                                                                                                                                                                                  
              ownerMoblie: req.user.userMoblie || "",//                                                                                                                                                                                                 
              invoiceApplyStatus: "00",// 发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                                                               
              channelUserId: req.user.channelUserId || "",// 渠道用户id  
              needNo: element.orderItemNum || null,//需求单号
              picUrl: productItem.picUrl,//                                                                                                                             
              productType_id: productItem.productType_id,//产品类型Id                                                                                                               
              productOneType_id: productItem.productOneType_id,//产品大类Id                                                                                                               
              serviceItemSnapshot: JSON.stringify(productItem),//产品快照        
            };
            var orderItem = await self.dao.create(orderParams, t);//创建订单
            var receiptvoucherItem = await self.receiptvoucherDao.addReceiptvoucher(orderParams, req, t);//创建订单支付信息
            var orderProductObj = {
              app_id: req.app.id,//   
              productType_id: productItem.productType_id,//产品类型Id                                                                                                               
              productOneType_id: productItem.productOneType_id,//产品大类Id      
              itemCode: productItem.itemCode,//                                                                                                                                                                                                 
              itemName: productItem.itemName,//                                                                                                                                       
              payStatus: "yfk",//支付状态:dfk: 待付款, yfk: 已支付                                                                                  
              appDataOpType: req.app.appDataOpType,// 应用数据操作类型：00独立，10全委托，20部分委托     
              sourceOrderNo: ordercode,//来源单号   
              deliveryOrderNo: await self.getBusUid("jf"),
              channelServiceNo: element.orderItemNum || null,// 渠道服务单号                                                                                                                                                                               
              needNo: element.orderItemNum || null,//需求单号
              sourceType: "00",
              channelUserId: req.user.channelUserId || "",// 渠道用户id  
              createuser_id: req.user.id,//                                                                                                                           
              createuser: req.user.nickname,//             
            };
            //创建服务单
            var orderTm = await self.ordertmproductDao.create(orderProductObj, t);//创建订单交付流程

          });
        }
      }
    }
  }
  async push1688FqBusiness(action_body, pobj, req) {
    var item = await this.dao.getItemByChannelServiceNo(action_body.channelServiceNo, req.app.id);
    if (!item) {
      return system.getResult(null, "没有找到相关订单信息");
    }
    if (item.itemCode != "fzsbzc") {
      return system.getResult(null, "订单类型有误，请推送商标注册-专家辅助申请的订单");
    }
    if (item.buyerMoblie) {
      return system.getResult(null, "订单已经推送过，请勿重覆推送");
    }
    item.buyerMoblie = action_body.buyerMoblie;
    var result = await this.pushFqBusiness("tm_", item, "5dd513db4f3b08000a6fc082", pobj, req);
    if (result.status != 0) {
      return result;
    }
    await this.updateByWhere({ buyerMoblie: action_body.buyerMoblie }, { where: { channelServiceNo: action_body.channelServiceNo } });
    return result;
  }
  /**
   * 
   * @param {*} pushType 推送的类型 tm_  ic_ icp_
   * @param {*} item 订单信息  包含buyerMoblie
   * @param {*} pushServiceItemCode 推送的产品id
   * @param {*} pobj 
   * @param {*} req 
   */
  async pushFqBusiness(pushType, item, pushServiceItemCode, pobj, req) {//推送商机
    var rc = system.getObject("util.aliyunClient");
    var rtn = null;
    var reqUrl = this.fqReqUrl + "/crm/order/submit";

    try {
      var body = {
        idempotentId: item.needNo,// 是 业务 ID
        idempotentSource: req.app.appSourceCode ? pushType + req.app.appSourceCode : "tm_1688",// 是 业务来源（ali、jd）
        idempotentSourceName: req.app.name || "1688应用",// 是 阿里，京东
        city: "",// 否 所属城市
        phone: item.buyerMoblie,// 是 手机号
        userId: item.channelUserId,// 否 用户 ID
        companyName: "",// 否 公司名称
        orderPrice: item.totalSum,// 是 订单金额
        productId: pushServiceItemCode,// 是 产品 ID
        productQuantity: item.salesNum,// 是 产品数量
      };
      rtn = await rc.post(reqUrl, body);
      this.logCtl.info({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/pushFqBusiness",
        content: "请求地址：" + reqUrl + "，参数：" + JSON.stringify(body) + "，返回结果：" + JSON.stringify(rtn),
        clientIp: pobj.clientIp,
        optitle: "推送订单商机到FQ信息",
      });
      if (rtn.code != 200 && rtn.success != true) {
        return system.getResult(null, "推送失败，失败原因：" + rtn.errorMsg + "，selfrequestId=" + req.requestId + "，requestId=" + rtn.requestId);
      }
      return system.getResultSuccess(null, "推送成功");
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/pushFqBusiness",
        content: "error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "推送订单商机到FQ出错",
      });
    }
  }
  async againPushFqBusiness(pobj, req) {//再次推送商机
    var rc = system.getObject("util.aliyunClient");
    var rtn = null;
    var reqUrl = this.fqReqUrl + "/crm/order/submit";
    var body = pobj.actionBody;
    try {

      rtn = await rc.post(reqUrl, body);
      this.logCtl.info({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/againPushFqBusiness",
        content: "请求地址：" + reqUrl + "，参数：" + JSON.stringify(body) + "，返回结果：" + JSON.stringify(rtn),
        clientIp: pobj.clientIp,
        optitle: "推送订单商机到FQ信息--again",
      });
      if (rtn.code != 200 && rtn.success != true) {
        return system.getResult(null, "推送失败，失败原因：" + rtn.errorMsg + "，selfrequestId=" + req.requestId + "，requestId=" + rtn.requestId);
      }
      return system.getResultSuccess(null, "推送成功");
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/againPushFqBusiness",
        content: "error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "推送订单商机到FQ出错--again",
      });
    }
  }

  async gsbOrderInfo(pobj, req) {//公司宝官网订单
    var rc = system.getObject("util.aliyunClient");
    var rtn = null;
    var reqUrl = this.fqReqUrl + "/dsc/order/add";
    var body = pobj.actionBody.order_param || "";
    if (!body) {
      return system.getResult(null, "order_param is empty");
    }
    try {
      rtn = await rc.post(reqUrl, body);
      this.logCtl.info({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/gsbOrderInfo",
        content: "请求地址：" + reqUrl + "，参数：" + JSON.stringify(body) + "，返回结果：" + JSON.stringify(rtn),
        clientIp: pobj.clientIp,
        optitle: "公司宝官网订单--gsbOrderInfo",
      });
      if (rtn.code != 200 && rtn.success != true) {
        return system.getResult(null, "公司宝官网订单失败，失败原因：" + rtn.errorMsg + "，selfrequestId=" + req.requestId + "，requestId=" + rtn.requestId);
      }
      return system.getResultSuccess(rtn.data, "订单下单成功");
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: req.app.id,
        appkey: req.app.uappKey,
        requestId: req.requestId || "",
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/againPushFqBusiness",
        content: "error：" + e.stack,
        clientIp: pobj.clientIp,
        optitle: "公司宝官网订单出错--gsbOrderInfo",
      });
    }
  }

  //-------------------------通联支付------start---------------------------------------------------------
  //获取center-channel token
  async getCenterChannelToken(app){
    var pobj={
      "actionType":"getAppTokenByAppKey",
      "actionBody":{
          "appkey": app.uappKey,
          "secret": app.appSecret
      }
    };
    var url = settings.centerChannelUrl() + "web/auth/accessAuth/getAppTokenByAppKey";
    var rtn = await this.restClient.execPost(pobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "execPost is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  //获取通联支付二维码
  async getTlPayQrCode(obj){
    if(!obj.app || !obj.app.uAppId || !obj.app.id){
      return system.getResultFail(-100, "渠道信息有误");
    }
    if(!obj.orderNo){
      return system.getResultFail(-101, "orderNo参数有误");
    }
    var order = await this.dao.model.findOne({
      where:{orderNo:obj.orderNo,app_id:obj.app.id},raw:true
    });
    if(!order || !order.totalSum){
      return system.getResultFail(-102, "订单数据有误");
    }
    if(!obj.opType){
      return system.getResultFail(-103, "opType参数有误");
    }
    var token="";
    var tokenRes = await this.getCenterChannelToken(obj.app);
    if(tokenRes && tokenRes.status==0 && tokenRes.data){
      token=tokenRes.data.token;
    }
    if(!token){
      return system.getResultFail(-99, "获取token失败");
    }
    var url = settings.centerChannelUrl() + "web/payment/paymentApi/springBoard";
    var pobj= {
          "actionType": "getQrCode",
          "actionBody": {
            "uapp_id": obj.app.uAppId,
            "order_num": order.orderNo,
            "total_fee": Number(order.totalSum)*100,
            "body_desc": "1",
            "opType": obj.opType
          }
    };
    var rtn = await this.execClient.execPushDataPost(pobj, url, token);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "execPost is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  async resultSign(resultData, pay_key) {//返回值进行验签
    var rtnResult = { status: 0, msg: "SUCCESS" };
    if (!resultData || !resultData.appid) {
      rtnResult.status = -310;
      rtnResult.msg = "返回值信息data为空";
      return rtnResult;
    }
    resultData.key = pay_key;
    var resultSignArr = [];
    var keys = Object.keys(resultData).sort();
    if (keys.length == 0) {
      rtnResult.status = -330;
      rtnResult.msg = "返回值参数信息为空";
      return rtnResult;
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && resultData[tKey]) {
        resultSignArr.push(tKey + "=" + resultData[tKey]);
      }
    }
    if (resultSignArr.length == 0) {
      rtnResult.status = -350;
      rtnResult.msg = "返回值组装签名参数信息为空";
      return rtnResult;
    }
    var resultSignStr = resultSignArr.join("&");
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    delete resultData["key"];
    if (resultData.sign != resultTmpSign) {
      rtnResult.status = -380;
      rtnResult.msg = "返回值签名验证失败";
      return rtnResult;
    }
    return rtnResult;
  }
  async receiveTlCallBackNotify(obj) {//接收通联支付回调通知
      if (obj  && obj.trxstatus == "0000") {
        obj.client_ip = "";
        let attachList = [];
        if (obj.cusorderid.indexOf("_") >= 0) {
          attachList = obj.cusorderid.split("_");
        }
        else {
          attachList.push(obj.cusorderid);
        }
        if (attachList.length != 2) {
          return system.getResultFail(-103, "cusorderid参数错误，没有_标识");
        }
        obj.out_trade_no = attachList[0];
        obj.company_id = attachList[1];
        var app = await this.appDao.findOne({
          where:{uAppId:obj.company_id},raw:true
        });
        if(!app){
          return system.getResultFail(-100, "渠道参数错误");
        }
        var orderInfo = await this.dao.model.findOne({
          where:{orderNo:obj.out_trade_no,app_id:app.id},
          raw:true
        });
        if (!orderInfo) {
          return system.getResultFail(-102, "订单数据不存在");
        }
        if (orderInfo.orderPayStatus == "yfk") {
          return system.getResultSuccess({ orderPayStatus: "yfk" });
        }
        //修改并返回订单支付状态，创建收款单 
        return await this.opBackNotify(obj, "接收通联支付通知回调",app);
      }
      else if (obj.trxstatus == "3045") {
        return system.getResultFail(-104, "超时未支付，queryTlPayOrder新页面");
      }
      return system.getResultFail(-105, "请及时支付");
  }
  async checkPayStatusTl(obj) {//通联支付状态验证
      var wxPayOrderCode = obj.wxPayOrderCode || "";
      var aliPayOrderCode = obj.aliPayOrderCode || "";
      var comanyId = obj.company_id;
      var app = await this.appDao.findOne({
        where:{uAppId:comanyId},raw:true
      });
      if(!app){
        return system.getResultFail(-100, "渠道参数错误");
      }
      var opType = obj.op_type;
      var orderCode = obj.orderCode;
      if (!wxPayOrderCode || !aliPayOrderCode || !comanyId || !opType || !orderCode) {
        return system.getResultFail(-101, "参数错误");
      }
      var orderInfo = await this.dao.model.findOne({
        where:{orderNo:orderCode,app_id:app.id},
        raw:true
      });
      if (!orderInfo) {
        return system.getResultFail(-102, "订单数据不存在");
      }
      if (orderInfo.orderPayStatus == "yfk") {
        return system.getResultSuccess({ orderPayStatus: "yfk" });
      }
      var payTrxid = opType == "wx" ? wxPayOrderCode : aliPayOrderCode;
      var opComanyId = comanyId;
      var payStatus = await this.queryTlPayOrder(app, payTrxid);//查询通联支付状态 
      if (payStatus && payStatus.status == 0 && payStatus.data && payStatus.data.trxstatus == "0000") {
        payStatus.data.client_ip = obj.client_ip || "";
        let attachList = [];
        if (payStatus.data.reqsn.indexOf("_") >= 0) {
          attachList = payStatus.data.reqsn.split("_");
        }
        else {
          attachList.push(payStatus.data.reqsn);
        }
        if (attachList.length != 2) {
          return system.getResultFail(-103, "reqsn参数错误，没有_标识");
        }
        payStatus.data.out_trade_no = attachList[0];
        payStatus.data.company_id = attachList[1];
        //修改并返回订单支付状态，创建收款单 
        return await this.opBackNotify(payStatus.data, "queryTlPayOrder面回调",app);
      }
      else if (payStatus && payStatus.code == 1 && payStqueryTlPayOrders.data.trxstatus == "3045") {
        return system.getResultFail(-104, "超时未支付，queryTlPayOrder新页面");
      }
      return system.getResultFail(-104, "请及时支付");
  }
  //查询通联支付订单
  async queryTlPayOrder(app, payTrxid){
    var token="";
    var tokenRes = await this.getCenterChannelToken(app);
    if(tokenRes && tokenRes.status==0 && tokenRes.data){
      token=tokenRes.data.token;
    }
    if(!token){
      return system.getResultFail(-99, "获取token失败");
    }
    var url = settings.centerChannelUrl() + "web/payment/paymentApi/springBoard";
    var pobj= {
          "actionType": "queryOrder",
          "actionBody": {
              "uapp_id": app.uAppId,
              "trxid":payTrxid
          }
    };
    var rtn = await this.execClient.execPushDataPost(pobj, url, token);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "execPost is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  //操作回调业务逻辑
  async opBackNotify(getParams, opDesc,app) {
    try {
      //日志记录
      this.logCtl.info({
        op: "igirl-channel/app/base/service/impl/dborder/orderSve/opBackNotify",
        content: JSON.stringify(getParams),
        clientIp: getParams.client_ip || "",
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：支付回调信息=====" + opDesc + "，method=" + getParams.trxcode
      });
      //获取充值业务锁
      var locker = await this.cacheManager["ZxPayLocker"].enter(getParams.trxid);
      if (locker && locker == "1") {
        if (getParams.trxcode == "VSP501") {
          getParams.req_accountType = "wx";
        } else {
          getParams.req_accountType = "alipay";
        }
        return await this.notifyOpDb(getParams,app);
      }
      else {
        // await this.cacheManager["ZxPayLocker"].release(getParams.trxid);//---测试时放开
        this.logCtl.info({
          appid: app.id,
          appkey: app.uappKey,
          op: "igirl-channel/app/base/service/impl/dborder/orderSve/opBackNotify",
          content: "参数=" + JSON.stringify(getParams),
          clientIp: getParams.client_ip || "",
          optitle: "通联回调操作频繁---太频繁了，太频繁了"
        });
        return system.getResultFail(-200, "中信回调操作频繁---太频繁了，太频繁了");
      }
    } catch (e) {
      await this.cacheManager["ZxPayLocker"].release(getParams.trxid);
      throw new Error(e.stack);
    }
  }
/*
  返回值：
  -430：对应的业务支付订单号暂无
  -450：对应的订单支付金额不符
  -480：订单状态有误
  其余为事务处理会抛出异常
  */
  async notifyOpDb(obj,app) {
    var accountType="other";
    if (obj.req_accountType == "wx") {
      accountType = "wx";
    }
    if(obj.req_accountType == "alipay") {
      accountType = "alipay";
    }
    var account_type_list = uiconfig.config.pdict.accountType;
    var account_type_name = account_type_list[obj.req_accountType];
    obj.account_type_name = account_type_name;
    var sqlWheres = { orderNo: obj.out_trade_no,app_id:app.id };
    var orderItem = await this.dao.model.findOne({
      where: sqlWheres,
      raw:true
    });
    if (!orderItem) {
      return system.getResultFail(-430, "对应的业务支付订单号暂无");
    }
    if (Number(orderItem.totalSum * 100) != Number(obj.trxamt)) {
      return system.getResultFail(-450, "对应的订单支付金额不符");
    }
    if (orderItem.orderPayStatus != "dfk") {
      return system.getResultFail(-480, "订单状态有误");
    }
    var self = this;
    await this.db.transaction(async function (t) {
      // 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过
      var putParams = { orderPayStatus: "yfk",payDate:obj.fintime};
      await self.orderDao.updateByWhere(putParams, { where: sqlWheres }, t);
      //订单流程log
      self.orderflowDao.create({
        app_id: app.id,isShow: 1,
        createuser_id: orderItem.createuser_id,
        sourceOrderNo: orderItem.orderNo,
        opContent: "订单已成功支付，方式为" + account_type_name,
      }, t);
      //帐户类型（ 支付类型）:cash: 现金, bank: 银行 ,wx:微信,alipay:支付宝,other:其它
      var orderReceiptVoucherObj={
        uapp_id:app.uAppId,
        sourceOrderNo:orderItem.orderNo,   // 来源单号
        accountType: accountType,
        payDate: obj.fintime,//支付时间
        totalSum: orderItem.totalSum,//订单总额
        wxPayOrderCode:obj.trxid,//业务微信支付订单号
        aliPayOrderCode:obj.trxid,//业务支付宝支付订单号
        busPayOrderCode:obj.trxid,//业务支付订单号
        auditStatus:"tg"
      };
      var orderReceiptVoucher = await self.orderReceiptVoucherDao.create(orderReceiptVoucherObj,t);
      var resdata = {
        "busPayOrderCode": obj.trxid,
        "code": orderItem.orderNo,
        "app_id": app.id,
        "sveItemCode": orderItem.itemCode,
        "sveItemName": orderItem.itemName,
        "totalSum": orderItem.totalSum,
        "orderPayStatus": "yfk",
      }
      return system.getResultSuccess(resdata);
    });
  }

  //-------------------------通联支付------end---------------------------------------------------------
  
}
module.exports = OrderService;
// var task = new OrderService();
// var app={
//   id:2,uappKey:"201911131657",uAppId:9,appSecret:"eeb18393aade40149287b024d8ba0850"
// };
// task.queryTlPayOrder(app,"112094120001042656").then(d=>{
//   console.log(d,"result----------------------------------");
// })