const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class CustomerContactsService extends ServiceBase {
  constructor() {
    super("dborder", ServiceBase.getDaoName(CustomerContactsService));
    this.ordertmproductSve = system.getObject("service.dborder.ordertmproductSve");
    this.orderflowDao = system.getObject("db.dborder.orderflowDao");
  }
  /**
   * 修改商标交付单联系人(订单详情页面)
   * @param {*} obj 
   * obj.deliveryOrderNo 交付订单号，
   * obj.name 联系人，obj.mobile 联系电话，obj.email 电子邮箱，obj.tel 座机电话
   * obj.user  用户数据
   */
  async updateContacts(obj){
    var user = obj.user;
    var app = obj.app;
    if(!user || !user.id){
      return system.getResultFail(-100, "未知用户");
    }
    if (!app || !app.id) {
      return system.getResultFail(-100, "未知渠道");
    }
    var deliveryOrderNo = obj.deliveryOrderNo;
    if(!deliveryOrderNo){
      return system.getResultFail(-101, "deliveryOrderNo参数错误");
    }
    // 1.获取交付单信息
    var ordertmproduct = await this.ordertmproductSve.dao.model.findOne({
      where:{deliveryOrderNo:deliveryOrderNo,app_id:app.id},
      raw:true
    });
    if(!ordertmproduct || !ordertmproduct.id){
      return system.getResultFail(-102, "商标交付单不存在");
    }
    // 2.获取交付单状态，判断是否可修改
    if(ordertmproduct.deliveryStatus=='ddj' || ordertmproduct.deliveryStatus=='ywc'){
      var deliveryStatusName = "待递交";
      if(ordertmproduct.deliveryStatus=='ywc'){
        deliveryStatusName="已完成";
      }
      return system.getResultFail(-103, "该商标交付单状态为"+deliveryStatusName+",不能进行修改");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      var contactsObj={deliveryOrderNo:deliveryOrderNo};
      if(obj.name){
        contactsObj["name"]=obj.name;
      }
      if(obj.mobile){
        contactsObj["mobile"]=obj.mobile;
      }
      if(obj.email){
        contactsObj["email"]=obj.email;
      }
      if(obj.tel){
        contactsObj["tel"]=obj.tel;
      }
      //修改联系人信息
      await self.dao.model.update(contactsObj, { where: { deliveryOrderNo:deliveryOrderNo,app_id: app.id }, transaction: t });
      var logMsg = { sourceOrderNo: deliveryOrderNo, opContent: "修改订单信息", app_id: app.id, isShow: 1 };
      await self.orderflowDao.create(logMsg, t);
      return system.getResultSuccess();
    })
  }
}
module.exports=CustomerContactsService;
