const system = require("../../../system");
// const Dao = require("../../dao.base");
const ServiceBase = require("../../sve.base");
const uuidv4 = require('uuid/v4');
class OrderInfoService extends ServiceBase {
  constructor() {
    super("dbcorder", ServiceBase.getDaoName(OrderInfoService));
    this.appproductDao = system.getObject("db.dbapp.appproductDao");
    this.orderProductDao = system.getObject("db.dbcorder.orderproductDao");
    this.orderReceiptVoucherDao = system.getObject("db.dbcpay.orderreceiptvoucherDao");
    this.orderRefundVoucherDao = system.getObject("db.dbcpay.orderrefundvoucherDao");
    this.moneyJourneyDao = system.getObject("db.dbcpay.moneyjourneyDao");
    this.pushlogSve = system.getObject("service.common.pushlogSve");
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  /*
   * 订单验证
  */
  async isOrderVerify(serviceitem,buyProductCount,buyPrice) {
    var sveItemRateConfig = serviceitem.rateConfig ? Number(serviceitem.rateConfig) : 0;//产品费率
    var fwf = serviceitem.serviceCharge ? Number(serviceitem.serviceCharge) : 0;//服务费
    var yhfl = serviceitem.discountsRateConfig ? Number(serviceitem.discountsRateConfig) : 0;//最大优惠费率
    var gf = serviceitem.publicExpense ? Number(serviceitem.publicExpense) : 0;//产品官费
    var productCount = 1;//产品数量
    var gfze = 0;//官费总额
    var qdfcbl = serviceitem.channelProfitRate?Number(serviceitem.channelProfitRate) : 0;//渠道利润分成比率
    productCount = Number(buyProductCount);//购买产品数量
    buyPrice = Number(buyPrice);//购买价格
    gfze = gf * Number(productCount);
    var fwfze = Number(fwf) * Number(productCount);//服务费总额
    var sfze = Number(buyPrice) / (sveItemRateConfig + 100) * sveItemRateConfig; //totalTaxes 税费总额
    sfze = sfze.toFixed(2);
    sfze = Number(sfze);
    var zdyhe = (gfze + fwfze) * yhfl / 100;//最大优惠额
    zdyhe = zdyhe.toFixed(2);
    zdyhe = Number(zdyhe);
    //毛利总额=应付总额-官费总额
    var mlze = Number(buyPrice) - gfze;//totalProfitSum 毛利总额
    mlze = mlze.toFixed(2);
    mlze = Number(mlze);
    //优惠金额=服务费+官费总额-应付总额(服务费、官费之和小于等于应付总额时，优惠金额为零)
    var yhje = fwfze + gfze - Number(buyPrice);
    if (yhje < 0) {
      yhje = 0;
    }
    yhje = yhje.toFixed(2);
    yhje = Number(yhje);
    if (yhje > zdyhe) {
      return { code: -205, msg: "优惠总额有误" };
    }
    var fcmlze_channel = mlze*qdfcbl ;//订单渠道分成毛利润总额
    var fcmlze_platform = mlze-fcmlze_channel ;//订单平台毛利润总额
    return {code:1,data:{
      totalServiceCharge  :fwfze,//  服务费总额（产品配置的服务费*订单件数）                                                                                                                                
      totalPublicExpense  :gfze,//  官费总额（产品配置的官费*订单件数）                                                                                                                                      
      totalTaxes          :sfze,//  税费总额（订单总额-(订单总额/（1+产品费率）)）                                                                                                                        
      totalSum            :buyPrice,//  订单总额(产品价格×优惠费率×订单件数)                                                                                                                                       
      totalProfitSum      :mlze,//  订单毛利润总额（订单总额-官费总额）  
      totalDiscounts      :yhje,//  优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）                                                                                                                                                                                               
      pfProfitSum         :fcmlze_platform,//  订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）                                                                                                  
      channelProfitSum    :fcmlze_channel,//  订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率) 
    }};
  }
  /**
   * 创建订单
   */
  async createOrder(obj,req){
    var self = this;
    var app = req.app;
    var user = req.user;
    if(!app || !app.uAppId){
      return system.getResult(null, "渠道信息有误");
    }
    if(!user){
      return system.getResult(null, "用户信息有误");
    }
    var channelItemCode = obj.itemCode;
    if(!channelItemCode){
      return system.getResult(null, "未知的产品码");
    }
    var productItem = await this.appproductDao.findOneByChannelItemCode(channelItemCode, app.id);//通过ChannelItemCode获取产品
    // if (!productItem) {
    //   return system.getResult(null, "未知的产品");
    // }
    var verifyResult=null;
    if (productItem) {
      if(productItem.status != 1){
        return system.getResult(null, "产品已禁用");
      }
    }
    var channelUser = obj.channelUser;
    if(!channelUser || !channelUser.channelUserId){
      return system.getResult(null, "渠道用户信息有误");
    }
    var channelOrder = obj.channelOrder;
    if(!channelOrder || !channelOrder.channelServiceNo){
      return system.getResult(null, "渠道订单信息有误");
    }
    if(!channelOrder.quantity){
      return system.getResult(null, "渠道订单产品数量不能为空");
    }
    if(!channelOrder.totalSum){
      return system.getResult(null, "渠道订单支付金额不能为空");
    }
    if (productItem) {
      verifyResult = await self.isOrderVerify(productItem,channelOrder.quantity,channelOrder.totalSum);
      if (verifyResult && verifyResult.code!=1) {
        return system.getResult(null, verifyResult.msg);
      }
    }
    var beforeOrder = await this.dao.model.findOne({
      where:{channelServiceNo:channelOrder.channelServiceNo,uapp_id:app.uAppId},
      raw:true
    });
    if(beforeOrder){//订单已存在
      return system.getResultFail(2, "订单已存在",beforeOrder.orderNo);
    }
    return await self.db.transaction(async function (t) {
      var orderNo = await self.getBusUid("o");
      //创建订单
      var orderObj={
        uapp_id:app.uAppId,orderNo:orderNo,channelServiceNo:channelOrder.channelServiceNo,
        channelUserId:channelUser.channelUserId,channelOrderNo:channelOrder.channelOrderNo,
        ownerUserId:channelUser.channelUserId,
        quantity:channelOrder.quantity,
        needNo:channelOrder.needNo,payTime:channelOrder.payTime,orderPayStatus:channelOrder.payStatus,
        totalSum:channelOrder.totalSum,
        payTotalSum:channelOrder.payTotalSum,
        totalServiceCharge  :0,//  服务费总额（产品配置的服务费*订单件数）                                                                                                                                
        totalPublicExpense  :0,//  官费总额（产品配置的官费*订单件数）                                                                                                                                      
        totalTaxes          :0,//  税费总额（订单总额-(订单总额/（1+产品费率）)）                                                  
        totalProfitSum      :0,//  订单毛利润总额（订单总额-官费总额）  
        totalDiscounts      :0,//  优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）                                                                                                                                                                                               
        pfProfitSum         :0,//  订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）                                                                                                  
        channelProfitSum    :0,//  订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率)                                                                                               
        // pfSettleProfit      :DataTypes.INTEGER,//  平台结算渠道利润,0否，1是                                                                                                                                                                                                 
        invoiceApplyStatus  :"00",//  发票状态:00: 未申请, 10: 已申请,20:已开票
      };
      if(verifyResult && verifyResult.code==1 && verifyResult.data){
        var orderCostObj=verifyResult.data;
        orderObj.totalServiceCharge=orderCostObj.totalServiceCharge || 0;
        orderObj.totalPublicExpense=orderCostObj.totalPublicExpense || 0;
        orderObj.totalTaxes=orderCostObj.totalTaxes || 0;
        orderObj.totalProfitSum=orderCostObj.totalProfitSum || 0;
        orderObj.totalDiscounts=orderCostObj.totalDiscounts || 0;
        orderObj.pfProfitSum=orderCostObj.pfProfitSum || 0;
        orderObj.channelProfitSum=orderCostObj.channelProfitSum || 0;
      }
      var order = await self.dao.create(orderObj,t);//创建订单
      //var orderProductNo = await self.getBusUid("op");
      if(productItem){
        var orderProductObj = {
          uapp_id:app.uAppId,  
          sourceOrderNo:order.orderNo,   // 来源单号
          productType_id        :productItem.productType_id,//产品类型Id
          productOneType_id     :productItem.productOneType_id,//产品大类Id
          itemCode              :productItem.itemCode,//产品编码
          itemName              :productItem.itemName,//产品名称                                               
          channelItemCode       :productItem.channelItemCode,//  渠道产品编码                                                 
          channelItemName       :productItem.channelItemName,//  渠道产品名称 
          serviceItemCode       :productItem.serviceItemCode,//  服务商产品编码
          picUrl                :productItem.picUrl,//  产品图片地址      
          proPrice              :productItem.proPrice,    //  产品价格    
          quantity              :channelOrder.quantity,//  订单数量（即产品的倍数，默认值为1）   
          opPayType             :"00",//  操作付款类型:00: 创建订单, 10: 补单
          serviceItemSnapshot   :JSON.stringify(productItem),      //产品快照  
        };
        var orderProduct = await self.orderProductDao.create(orderProductObj,t);//订单产品  
      }
      if(order.totalSum>0){//支付成功
        var moneyObj={
          uapp_id:app.uAppId,
          sourceOrderNo:order.orderNo,   // 来源单号
          channelUserId:channelUser.channelUserId,
          ownerUserId:channelUser.channelUserId,
          accountType: "other",//帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
          directionType: "sr",//凭单类型,"sr": "收","zc": "支"
          voucherDate: channelOrder.payTime,//凭单时间
          recvAmount: channelOrder.totalSum,//收总额
          sourceType: "orderinfo",//来源类型 "orderinfo": "订单","expensevoucher": "费用单"
          auditStatus: "dsh",//审核状态"dsh": "待审核", "btg": "不通过", "tg": "通过"
        };
        if(channelOrder.payStatus=='yfk' || channelOrder.payStatus=='bfyfk'){
          moneyObj.auditStatus="tg";
        }
        var moneyJourney = await self.moneyJourneyDao.create(moneyObj,t);
        var orderReceiptVoucherObj={
          uapp_id:app.uAppId,
          sourceOrderNo:order.orderNo,   // 来源单号
          accountType: "other",
          payDate: channelOrder.payTime,//支付时间
          totalSum: channelOrder.totalSum,//订单总额
          // payOrderNo: DataTypes.STRING, //支付凭证流水单号，如：微信支付凭证单号
          // buyerOpenId: DataTypes.STRING,//用户在支付商户appid下的唯一标识或买家在支付宝的用户id
          // passTradeNo: DataTypes.STRING,//通道的统一订单号
          // buyerAliLogonId: DataTypes.STRING,//买家支付宝账号
      
          // certifyFileUrl: order.orderNo, //支付证明文件Url
          wxPayOrderCode: order.orderNo,//业务微信支付订单号
          aliPayOrderCode:order.orderNo,//业务支付宝支付订单号
          busPayOrderCode: order.orderNo,//业务支付订单号
          auditStatus:"dsh"
        };
        if(channelOrder.payStatus=='yfk' || channelOrder.payStatus=='bfyfk'){
          orderReceiptVoucherObj.auditStatus="tg";
        }
        var orderReceiptVoucher = await self.orderReceiptVoucherDao.create(orderReceiptVoucherObj,t);
      }
      var requestid=self.getUUID();
      if(productItem && productItem.deliveryUrl){
        obj["orderNo"]=order.orderNo;
        self.pushData(requestid,obj,productItem.deliveryUrl,req);
      }
      return system.getResultSuccess({
        orderNo:order.orderNo,
        channelServiceNo:order.channelServiceNo,
        channelParams:obj.channelParams,
        requestid:requestid
      });
    });
    
  }
  /**
   * 数据推送
   */
  async pushData(requestid,params,url,req){
    var rc = system.getObject("util.execClient");
    var obj = params;
    var rtn = null;
    try {
        rtn = await rc.execPushDataPost(obj, url, req.headers["token"], req.headers["request-id"]);
        var returnType = "0";
        if (rtn.stdout) {
            var j = JSON.parse(rtn.stdout);
            if (j && j.status == 0) {
                returnType = "1";
            }
        }
        this.pushlogSve.createDb({
            appid: req.app.id,
            requestId: requestid,
            op: url,
            content: JSON.stringify(obj),
            resultInfo: JSON.stringify(rtn),
            clientIp: req.clientIp,
            returnType: returnType,
            agent: req.uagent,
            opTitle: "数据推送-创建订单",
        });
    } catch (e) {
        this.pushlogSve.createDb({
            appid: req.app.id,
            requestId: requestid,
            op: url,
            content: JSON.stringify(obj),
            resultInfo: JSON.stringify(e.stack),
            clientIp: req.clientIp,
            returnType: '0',
            agent: req.uagent,
            opTitle: "数据推送-创建订单",
        });
    }
  }
  async findAndCountAll(obj,req) {
    var app = req.app;
    if(!app || !app.uAppId){
      return system.getResult(null, "渠道信息有误");
    }
    obj["search"]["uapp_id"]=app.uAppId;
    const result = await this.dao.findAndCountAll(obj);
    return system.getResultSuccess(result);
  }

  async getOrderDetailByOrderNo(obj,req){
    var orderNo = obj.orderNo;
    if(!orderNo){
      return system.getResult(null, "订单编号不能为空");
    }
    var app = req.app;
    if(!app || !app.uAppId){
      return system.getResult(null, "渠道信息有误");
    }
    var order = await this.dao.model.findOne({
      where:{orderNo:orderNo,uapp_id:app.uAppId},
      attributes:["orderNo","channelServiceNo","channelOrderNo","channelUserId","ownerUserId","needNo",
        "payTime","quantity","serviceQuantity","orderPayStatus","orderPayStatusName","totalSum","payTotalSum",
        "refundSum","created_at","opNotes","notes"
      ],
      raw:true
    });
    if(order && order.orderNo){
      var orderproducts = await this.orderProductDao.model.findAll({
        where:{sourceOrderNo:order.orderNo},
        attributes:["sourceOrderNo","itemCode","itemName","channelItemCode","channelItemName",
          "serviceItemCode","picUrl","proPrice","quantity","opPayType","serviceItemSnapshot",
          "created_at"
        ],
        raw:true
      });
      order["orderproducts"]=orderproducts;
      var receptvouchers = await this.orderReceiptVoucherDao.model.findAll({
        where:{sourceOrderNo:order.orderNo},
        attributes:[
          "sourceOrderNo","accountType","accountTypeName","payDate","totalSum","payOrderNo","buyerOpenId",
          "passTradeNo","buyerAliLogonId","certifyFileUrl","wxPayOrderCode","aliPayOrderCode","busPayOrderCode",
          "auditStatusName","auditStatus"
        ],
        raw:true
      });
      order["receptvouchers"]=receptvouchers;
      var refundvouchers = await this.orderRefundVoucherDao.model.findAll({
        where:{sourceOrderNo:order.orderNo},
        attributes:[
          "busPayOrderCode",
          "sourceOrderNo","accountType","accountTypeName","payDate","totalSum","payOrderNo","buyerOpenId",
          "passTradeNo","certifyFileUrl","auditStatusName","auditStatus"
        ],
        raw:true
      });
      order["refundvouchers"]=refundvouchers;
    }
    return system.getResultSuccess(order);
  }
}
module.exports = OrderInfoService;
// var task = new OrderInfoService();
// var obj={
//     "itemCode": "1406046",
//     "channelParams": {},
//     "channelUser": {
//         "channelUserId": "z120315554031547444",
//         "channelUserName": "testUser",
//         "channelUserMoblie": "15010929368",
//         "nickname": "",
//         "orgName": "",
//         "orgPath": ""
//     },
//     "channelOrder": {
//         "channelServiceNo": "z1203155540315474427",
//         "channelOrderNo": "z12031,z1203d12",
//         "needNo": "z1203155540315474427",
//         "quantity": 1,
//         "totalSum":699,
//         "payTotalSum":699,
//         "payStatus": "yfk",
//         "payTime": "2019-09-11 10:23:21"
//     }
// };
// var req={
//   app:{ id: 2,uAppId:123},
//   user:{ id: 6, app_id: 2, nickname: "测试用户",channelUserId:"testUserId01" }
// };
// task.createOrder(obj,req).then(d=>{
//   console.log("d");
//   console.log(d);
// })

