const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class AppProductService extends ServiceBase {
  constructor() {
    super("dbapp", ServiceBase.getDaoName(AppProductService));
  }
  //根据渠道产品码获取产品详情
  async findByChannelItemCode(obj){
    // var user = obj.user;
    var app = obj.app;
    // if(!user){
    //   return system.getResultFail(-101, "未知用户");
    // }
    if(!app){
      return system.getResultFail(-102, "未知渠道");
    }
    var channelItemCode = obj.channelItemCode;
    if(!channelItemCode){
      return system.getResultFail(-103, "渠道产品编码不能为空");
    } 
    var product = await this.dao.model.findOne({
      where:{channelItemCode:channelItemCode,app_id:app.id,status:1},
      attributes:["id","app_id","itemCode","itemName","picUrl","channelItemCode","channelItemName",
      "serviceItemCode","proPrice","serviceCharge","publicExpense","rateConfig","discountsRateConfig"],
      raw:true
    });
    if(!product){
      return system.getResultFail(-104, "未知产品");
    }
    return system.getResultSuccess(product);
  }
  //获取产品列表(根据父类产品编码获取)
  async findByProductTypeCode(obj){
    // var user = obj.user;
    var app = obj.app;
    // if(!user){
    //   return system.getResultFail(-101, "未知用户");
    // }
    if(!app){
      return system.getResultFail(-102, "未知渠道");
    }
    var itemCode = obj.itemCode;
    if(!itemCode){
      return system.getResultFail(-103, "渠道产品编码不能为空");
    } 
    var pProduct = await this.dao.model.findOne({
      where:{itemCode:itemCode,app_id:app.id,status:1},
      attributes:["id","app_id","itemCode","itemName"],
      raw:true
    });
    if(!pProduct || !pProduct.id){
      return system.getResultFail(-104, "未知产品");
    }
    var pList = await this.dao.model.findAll({
      where:{productType_id:pProduct.id,app_id:app.id,status:1},
      attributes:["id","app_id","itemCode","itemName","picUrl","channelItemCode","channelItemName",
      "serviceItemCode","proPrice","serviceCharge","publicExpense","rateConfig","discountsRateConfig",
      "productLogo","productDesc"
      ],
      raw:true
    });
    return system.getResultSuccess(pList);
  }
  //获取产品列表(根据产品一类编码获取)
  async findByProductOneTypeCode(obj){
    // var user = obj.user;
    var app = obj.app;
    // if(!user){
    //   return system.getResultFail(-101, "未知用户");
    // }
    if(!app){
      return system.getResultFail(-102, "未知渠道");
    }
    var itemCode = obj.itemCode;
    if(!itemCode){
      return system.getResultFail(-103, "渠道产品编码不能为空");
    } 
    var pProduct = await this.dao.model.findOne({
      where:{itemCode:itemCode,app_id:app.id,status:1},
      attributes:["id","app_id","itemCode","itemName"],
      raw:true
    });
    if(!pProduct || !pProduct.id){
      return system.getResultFail(-104, "未知产品");
    }
    var pList = await this.dao.model.findAll({
      where:{productOneType_id:pProduct.id,productType_id:{ [this.db.Op.ne]: 0 },app_id:app.id,status:1},
      attributes:["id","app_id","itemCode","itemName","picUrl","channelItemCode","channelItemName",
      "serviceItemCode","proPrice","serviceCharge","publicExpense","rateConfig","discountsRateConfig",
      "productLogo","productDesc"
      ],
      raw:true
    });
    return system.getResultSuccess(pList);
  }

  //--------------------------------应用中心获取产品信息-start-----------------------------------------------------
  /**
   * 根据产品类型码获取产品列表
   * @param {*} obj 
   */
  async findByTypeCode(obj){
    var app = obj.app;
    if(!app || !app.uapp_id){
      return system.getResultFail(-100, "渠道信息有误");
    }
    obj["uapp_id"]=app.uapp_id;
    obj["actionType"]="findByTypeCode";
    // var typeCode = obj.typeCode;
    // if(!typeCode){
    //   return system.getResultFail(-101, "产品类型编码有误");
    // }
    var rc = system.getObject("util.restClient");
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn= await rc.execPost(obj, url);
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  /**
   * 根据产品类型码获取产品列表
   * @param {*} obj 
   */
  async findByTypeOneCode(obj){
    var app = obj.app;
    if(!app || !app.uapp_id){
      return system.getResultFail(-100, "渠道信息有误");
    }
    obj["uapp_id"]=app.uapp_id;
    obj["actionType"]="findByTypeOneCode";
    // var typeCode = obj.typeCode;
    // if(!typeCode){
    //   return system.getResultFail(-101, "产品类型编码有误");
    // }
    var rc = system.getObject("util.restClient");
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn= await rc.execPost(obj, url);
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  /**
   * 获取产品详情
   * @param {*} obj 
   */
  async getProductDetailByCode(obj){
    var app = obj.app;
    if(!app || !app.uapp_id){
      return system.getResultFail(-100, "渠道信息有误");
    }
    obj["uapp_id"]=app.uapp_id;
    obj["actionType"]="getProductDetailByCode";
    var rc = system.getObject("util.restClient");
    var url = settings.centerAppUrl() + "action/opProduct/springBoard";
    var rtn= await rc.execPost(obj, url);
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  //--------------------------------应用中心获取产品信息--end----------------------------------------------------
}
module.exports = AppProductService;
