const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("orderproduct", {
    uapp_id: DataTypes.INTEGER,//
    sourceOrderNo         :DataTypes.STRING(64),//来源单号 
    productType_id        :DataTypes.INTEGER,//产品类型Id
    productOneType_id     :DataTypes.INTEGER,//产品大类Id
    itemCode              :DataTypes.STRING(64),//产品编码
    itemName              :DataTypes.STRING(100),//产品名称                                               
    channelItemCode       :DataTypes.STRING(100),//  渠道产品编码                                                 
    channelItemName       :DataTypes.STRING(100),//  渠道产品名称 
    serviceItemCode       :DataTypes.STRING(100),//  服务商产品编码
    picUrl                :DataTypes.STRING(500),//  产品图片地址      
    proPrice              :DataTypes.DOUBLE,    //  产品价格    
    quantity              :DataTypes.INTEGER,//  订单数量（即产品的倍数，默认值为1）   
    opPayType             :DataTypes.STRING(10),//  操作付款类型:00: 创建订单, 10: 补单
    serviceItemSnapshot   :DataTypes.TEXT('long'),      //产品快照  
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_order_product',
      validate: {

      },
      indexes: [
      ]
    });
}
