const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("orderinfo", {                                                                                                                                                                      
    uapp_id             :DataTypes.INTEGER,//     
    orderNo             :DataTypes.STRING(64),//  订单号         
    channelServiceNo    :DataTypes.STRING(64),//  渠道服务单号                                                                                                                                                                                 
    channelOrderNo      :DataTypes.STRING(1024),//  渠道订单号列表，多个以,隔开    
    channelUserId       :DataTypes.STRING(64),         //  渠道用户ID   
    ownerUserId         :DataTypes.STRING(20),//   拥有渠道用户ID   
    needNo              :DataTypes.STRING(64),         //  需求单号 
    needNoOrderNo       :DataTypes.STRING(64),         //  需求订单号 
    payTime             :DataTypes.DATE,//  渠道有支付时间则用渠道的支付时间
    quantity            :DataTypes.INTEGER,//  订单数量（即产品的倍数，默认值为1）                                                                                                                          
    serviceQuantity     :DataTypes.INTEGER,//  订单服务数量（即与订单数量相对应）         
    orderPayStatusName  :DataTypes.STRING(50),//                                                                                                                                
    orderPayStatus      :{
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_pay_status),
      set: function (val) {
        this.setDataValue("orderPayStatus", val);
        this.setDataValue("orderPayStatusName", uiconfig.config.pdict.order_pay_status[val]);
      }
    },// 订单付款状态dfk: 待付款, zfpz: 已上传支付凭证, yfk: 已付款, bfyfk: 部分已付款, ddqx: 订单取消, tkclz: 退款处理中, bfytk: 部分已退款, ytk: 已退款,zfshbtg:支付审核不通过
    totalSum            :DataTypes.DECIMAL(12, 2),//  订单总额(产品价格×优惠费率×订单件数)                                                                                                                                    
    payTotalSum         :DataTypes.DECIMAL(12, 2),//  订单付款总额
    refundSum           :DataTypes.DECIMAL(12, 2),//  退款金额     
    totalServiceCharge  :DataTypes.DECIMAL(12, 2),//  服务费总额（产品配置的服务费*订单件数）                                                                                                                                
    totalPublicExpense  :DataTypes.DECIMAL(12, 2),//  官费总额（产品配置的官费*订单件数）   
    totalProfitSum      :DataTypes.DECIMAL(12, 2),//  订单毛利润总额（订单总额-官费总额）  
    totalDiscounts      :DataTypes.DECIMAL(12, 2),//  优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）                                                                                                                                                                                               
    pfProfitSum         :DataTypes.DECIMAL(12, 2),//  订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）                                                                                                  
    channelProfitSum    :DataTypes.DECIMAL(12, 2),//  订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率)                                                                                               
    pfSettleProfit      :DataTypes.INTEGER,//  平台结算渠道利润,0否，1是  
    invoiceApplyStatus  :DataTypes.STRING(10),//  发票状态:00: 未申请, 10: 已申请,20:已开票                                                                                                                                                                          
    opNotes             :DataTypes.STRING,//  备注                                                                                                                                                                                    
    notes               :DataTypes.STRING,//  备注     
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_order_info',
      validate: {

      },
      indexes: [      
      ]
    });
}
