const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("appproduct", {
    app_id                :DataTypes.STRING(50),//  应用id                                                           
    itemCode              :DataTypes.STRING(100),//  产品编码                                                       
    itemName              :DataTypes.STRING(100),//  产品名称                                                       
    picUrl                :DataTypes.STRING(500),//  产品图片地址                                                 
    channelItemCode       :DataTypes.STRING(100),//  渠道产品编码                                                 
    channelItemName       :DataTypes.STRING(100),//  渠道产品名称 
    serviceItemCode       :DataTypes.STRING(100),//  服务商产品编码
    pushServiceItemCode   :DataTypes.STRING(100),//  推送到服务商的产品编码
    status               :DataTypes.BOOLEAN,//  状态 0禁用 1启用                                             
    verifyPrice          :DataTypes.BOOLEAN,//  是否验证价格 0不验证 1验证                              
    proPrice             :DataTypes.DOUBLE,//  产品价格                                                       
    serviceCharge        :DataTypes.DOUBLE,//  服务费                                                          
    publicExpense        :DataTypes.DOUBLE,//  官费                                                             
    rateConfig           :DataTypes.DECIMAL(12, 2),//  税率                                                             
    discountsRateConfig  :DataTypes.DECIMAL(12, 2),//  优惠税率                                                       
    channelProfitRate    :DataTypes.DECIMAL(12, 2),//  渠道利润分成比率(只分订单中毛利润总额的分成)  
    sort                 :DataTypes.INTEGER,//  排序      
    productType_id          :DataTypes.INTEGER,//  产品类型Id
    productOneType_id          :DataTypes.INTEGER,//  产品大类Id   
    deliveryUrl:DataTypes.STRING(500),//  交付地址      
    productLogo:DataTypes.STRING(500),//  产品logo      
    productDesc:DataTypes.STRING(1024),//  产品描述     
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_app_product',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
