const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("app", {
    name: DataTypes.STRING(100),  //  应用名称                                                        
    appDataOpType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.app_data_op_type),
    },  //  应用数据操作类型：00独立，10全委托，20部分委托  
    appPayType: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.app_pay_type),
    },  //  支付类型：00第三方支付，10平台代收款    
    contactName  : DataTypes.STRING(30),  //  联系人姓名                                                     
    contactMobile: DataTypes.STRING(30),  //  联系人手机                                                     
    contactEmail : DataTypes.STRING(30),  //  联系人邮箱                                                     
    uappKey      : DataTypes.STRING(64),  //  平台应用key    
    uAppId       : DataTypes.INTEGER,        //                                                  
    appSecret    : DataTypes.STRING(64),  //  密钥信息，用于进行签名请求接口                       
    status       : DataTypes.INTEGER,  //  状态 0禁用 1启用                                              
    channelAppId : DataTypes.STRING(64),  //  渠道appID                                                         
    channelAppKey: DataTypes.STRING(64),  //  渠道appKey    
    pushOrderUrl : DataTypes.STRING(500), //  获取渠道推送订单的url                                                 
    appSourceCode : DataTypes.STRING(50), //  app来源code
    notes        : DataTypes.STRING,  //  备注
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_app',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
