const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderTmProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderTmProductDao));
  }
  async getTmListByChannelServiceNo(channelServiceNo, appId) {
    return this.model.findAll({
      where: {
        channelServiceNo: channelServiceNo,
        app_id: appId
      },
      raw: true
    });
  }
  async getTmItemByDeliveryOrderNo(deliveryOrderNo) {
    return this.model.findOne({
      where: {
        deliveryOrderNo: deliveryOrderNo
      },
      raw: true
    });
  }
  async getItemByNeedNoOrderNo(needNoOrderNo, appId, t) {
    var sqlWhere = {
      where: {
        needNoOrderNo: needNoOrderNo,
        app_id: appId
      },
      raw: true
    };
    if (t) {
      sqlWhere.transaction = t;
    }
    sqlWhere.attributes = ["id",
      "deliveryOrderNo",
      "payStatus",
      "needNo",
      "sourceOrderNo",
      "tmName",
      "tmType",
      "tmFormType",
      "nclOneCodes",
      "deliveryStatus",
      "picUrl",
      "colorizedPicUrl",
      "sywjUrl",
      "gzwtsUrl",
      "nclCount",
      "smwjUrl",
      "updateuser_id",
      "updateuser",
      "notes",
      "nclOneCount"
    ];

    return this.model.findOne(sqlWhere);
  }
  async getItemByChannelServiceNo(channelServiceNo, appId, t) {
    var sqlWhere = {
      where: {
        channelServiceNo: channelServiceNo,
        app_id: appId
      },
      raw: true
    };
    if (t) {
      sqlWhere.transaction = t;
    }
    sqlWhere.attributes = ["id",
      "deliveryOrderNo",
      "needNo",
      "sourceOrderNo",
      "tmName",
      "tmType",
      "tmFormType",
      "nclOneCodes",
      "deliveryStatus",
      "picUrl",
      "colorizedPicUrl",
      "sywjUrl",
      "gzwtsUrl",
      "nclCount",
      "smwjUrl",
      "updateuser_id",
      "updateuser",
      "notes",
      "nclOneCount"
    ];

    return this.model.findOne(sqlWhere);
  }
}
module.exports = OrderTmProductDao;
