const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderFlowDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderFlowDao));
  }
  async getListBySourceOrderNo(sourceOrderNo) {
    return this.model.findAll({
      where: {
        sourceOrderNo: sourceOrderNo,
        isShow: 1
      },
      order:[["created_at", 'desc']],
      raw: true
    });
  }
}
module.exports = OrderFlowDao;
