const system = require("../../../system");
const Dao = require("../../dao.base");
class AppDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppDao));
  }
  async getItemByAppKey(appKey) {
    return this.model.findOne({
      where: {
        uappKey: appKey
      },
      attributes: ["id",
        "name",           //  应用名称                                                        
        "appDataOpType",  //  应用数据操作类型：00独立，10全委托，20部分委托  
        "appPayType",     //  支付类型：00第三方应用自己支付，10平台代收款    
        "contactName",    //  联系人姓名                                                     
        "contactMobile",  //  联系人手机                                                     
        "contactEmail",   //  联系人邮箱                                                     
        "uappKey",        //  平台应用key                                                     
        "appSecret",      //  密钥信息，用于进行签名请求接口                       
        "status",         //  状态 0禁用 1启用  
        "uAppId",
        "channelAppId",   //  渠道appID                                                         
        "channelAppKey",  //  渠道appKey     
        "pushOrderUrl",   //获取渠道推送订单的url
        "appSourceCode",  //app来源code
        "notes"],
      raw: true
    });
  }
}
module.exports = AppDao;
