const Sequelize = require('sequelize');
const settings = require("../../../../config/settings")
const fs = require("fs")
const path = require("path");
var glob = require("glob");
class DbFactory {
  constructor() {
    const dbConfig = settings.database();
    this.db = new Sequelize(dbConfig.dbname,
      dbConfig.user,
      dbConfig.password,
      dbConfig.config);
    this.db.Sequelize = Sequelize;
    this.db.Op = Sequelize.Op;
    this.dbigirl = new Sequelize("zc",
      dbConfig.user,
      dbConfig.password,
      dbConfig.config);
    this.dbigirl.Sequelize = Sequelize;
    this.dbigirl.Op = Sequelize.Op;
    this.initModels();
    this.initRelations();
  }
  async initModels() {
    var self = this;
    var modelpath = path.normalize(path.join(__dirname, '../..')) + "/models/";
    console.log("modelpath=====================================================");
    console.log(modelpath);
    var models = glob.sync(modelpath + "/**/*.js");
    console.log(models.length);
    models.forEach(function (m) {
      console.log(m);
      self.db.import(m);
    });
    console.log("init models....");
  }
  async initRelations() {
    /**
      一个账户对应多个登陆用户
      一个账户对应一个commany
      一个APP对应多个登陆用户
      一个APP有多个角色
      登陆用户和角色多对多
    **/
    /*建立账户和用户之间的关系*/
    //account--不属于任何一个app,是统一用户
    //用户登录时首先按照用户名和密码检查account是否存在，如果不存在则提示账号或密码不对，如果
    //存在则按照按照accountid和应用key,查看user，后台实现对应user登录

  }
  //async getCon(){,用于使用替换table模型内字段数据使用
  getCon() {
    //同步模型
    if (settings.env == "dev") {

    }
    return this.db;
  }
  getConigirl() {
    var that = this;
    if (settings.env == "dev") {
    }
    return this.dbigirl;
  }
}
module.exports = DbFactory;
