const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByLoginVcodeCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
    this.restClient = system.getObject("util.restClient");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val;
    var uUserInfo = await this.opPlatformUtils.loginByVCode(actionBody.mobile, actionBody.vcode, actionBody.password,
      actionBody.appInfo.uappKey, actionBody.appInfo.appSecret);
    if (uUserInfo.status != 0) {
      return uUserInfo;
    }//2030验证码校验不成功 或 注册失败

    var userInfo = await this.appuserDao.getItemByUUserId(actionBody.userName, actionBody.appInfo.id);
    if (userInfo) {
      if (userInfo.is_enabled != 1) {
        return system.getResult(null, "user to item is Disable ！");
      }
      return system.getResultSuccess(userInfo);
    }
    var params = {
      app_id: actionBody.appInfo.id,
      channelUserId: actionBody.mobile || "",
      channelUserName: actionBody.mobile || "",
      userMoblie: actionBody.mobile || "",
      nickname: actionBody.nickName || "",
      orgName: actionBody.orgName || "",
      orgPath: actionBody.orgPath || "",

      uUserName: actionBody.mobile || "",
      uAppId: actionBody.appInfo.uAppId,
      isEnabled: 1,
      lastLoginTime: new Date()
    };
    userInfo = await this.appuserDao.create(params);
    return system.getResultSuccess(userInfo);
  }
}
module.exports = AppUserPinByLoginVcodeCache;
