const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByLoginPwdCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
    this.restClient = system.getObject("util.restClient");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val;
    var uUserName = actionBody.userName;//uUserName
    var uPassword = actionBody.password;//uPassword    
    var uUserInfo = await this.opPlatformUtils.login(uUserName, uPassword,
      actionBody.appInfo.uappKey, actionBody.appInfo.appSecret);
    if (uUserInfo.status != 0) {
      return uUserInfo;
    }//值为2010为用户名或密码错误
    var userInfo = await this.appuserDao.getItemByUUserId(actionBody.userName, actionBody.appInfo.id);
    if (!userInfo) {
      return system.getResultFail(system.noUserFail, "user to item is empty ！");
    }
    if (userInfo.isEnabled != 1) {
      return system.getResultFail(system.userDisable, "user to item is Disable ！");
    }
    return system.getResultSuccess(userInfo);
  }
}
module.exports = AppUserPinByLoginPwdCache;
