const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByChannelUserId extends CacheBase {
  constructor() {
    super();
    this.restClient = system.getObject("util.restClient");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var acckapp = await this.restClient.execPost(val, settings.centerAppUrl() + "auth/accessAuth/loginUserByChannelUserId");
    var result = acckapp.stdout;
    if (result) {
      var tmp = JSON.parse(result);
      return tmp;
    }
    return system.getResult(null, "data is empty");
  }
}
module.exports = AppUserPinByChannelUserId;
