const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppTokenByHostsCache extends CacheBase {
  constructor() {
    super();
    this.restClient = system.getObject("util.restClient");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_accesskey:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var app_hosts = val;
    if (!app_hosts) {
      return system.getResult(null, "app_hosts can not be empty");
    }
    var acckapp = await this.restClient.execPost({ app_hosts: app_hosts }, settings.centerAppUrl() + "auth/accessAuth/getTokenByHosts");
    var result = acckapp.stdout;
    console.log(acckapp.stdout, "AppTokenByHostsCache............. acckapp.stdout..........")
    if (result) {
      var tmp = JSON.parse(result);
      return tmp;
    }
    return system.getResult(null, "data is empty");
  }
}
module.exports = AppTokenByHostsCache;
