const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
//缓存首次登录的赠送的宝币数量
class ApiUserCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");

    this.appDao = system.getObject("db.dbapp.appDao");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
    this.restClient = system.getObject("util.restClient");
  }
  desc() {
    return "应用中来访访问token缓存";
  }
  prefix() {
    return settings.cacheprefix + "_userdata:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = items[0];
    var selfAppInfo = items[1];
    var uAppId = items[2];

    var channelUserId = val || "";
    var uUserName = channelUserId + "$" + selfAppInfo.data.uappKey;//uUserName
    var createUserPwd = inputkey;//(格式：selfAppInfo.data.uappKey+”_“+channelUserId)

    var userInfo = await this.appuserDao.getItemByUUserId(uUserName, selfAppInfo.data.id);
    if (userInfo) {
      var loginNum = Number(userInfo.loginNum || 0) + 1;
      this.appuserDao.updateByWhere({ lastLoginTime: new Date(), loginNum: loginNum }, { where: { id: userInfo.id } });
      return system.getResultSuccess(userInfo);
    }
    var uUserInfo = await this.opPlatformUtils.createUserInfo(uUserName, actionBody.channelUserMoblie || "15010888888",
      createUserPwd, selfAppInfo.data.uappKey, selfAppInfo.data.appSecret);
    if (uUserInfo.status != 2000 && uUserInfo.status != 0) {
      return uUserInfo;
    }//已经存在此用户 或 注册失败
    if (uUserInfo.status == 0) {
      var params = {
        app_id: selfAppInfo.data.id,
        channelUserId: channelUserId,
        channelUserName: actionBody.channelUserName || channelUserId,
        userMoblie: actionBody.channelUserMoblie || "88888888888",
        nickname: actionBody.nickname || "",
        orgName: actionBody.orgName || "",
        orgPath: actionBody.orgPath || "",

        uUserName: uUserName,
        uAppId: uAppId,
        isEnabled: 1,
        lastLoginTime: new Date()
      };
      userInfo = await this.appuserDao.create(params);
    }
    else {
      return uUserInfo;
    }
    return system.getResultSuccess(userInfo);
  }
}
module.exports = ApiUserCache;
