const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class ZxPayLocker extends CacheBase {
    constructor() {
        super();
        this.prefix = "zxPayLocker:";
    }
    desc() {
        return "应用中缓存访问token";
    }
    prefix() {
        return "zxPayLocker:";
    }
    async init(tradekey) {
        const key = this.prefix + tradekey;
        return this.redisClient.rpushWithEx(key, "1", 1800);
    }
    async enter(tradekey) {
        const key = this.prefix + tradekey;
        return this.redisClient.rpop(key);
    }
    async release(tradekey) {
        const key = this.prefix + tradekey;
        return this.redisClient.rpushWithEx(key, "1", 1800);
    }
}
module.exports = ZxPayLocker;
