var APIBase = require("../../api.base");
var system = require("../../../system");
class BusinessChanceAPI extends APIBase {
    constructor() {
        super();
        this.businesschanceSve = system.getObject("service.dbneed.businesschanceSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = null;
        pobj.actionBody["user"] = req.user;
        pobj.actionBody["app"] = req.app;
        switch (pobj.actionProcess) {
            case "jd"://京东
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody);
                break;
            case "1688"://京东
                result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody);
                break;
            default:
                result = system.getResult(null, "actionProcess参数错误");
                break;
        }
        return result;
    }
    async opActionProcess(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "subNeed"://提交需求
                opResult = await this.needinfoSve.subNeed(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    async zc2channel() {
        var rtn=await this.businesschanceSve.zc2channel();
        return rtn;
    }

}
module.exports = BusinessChanceAPI;