var APIBase = require("../../api.base");
var system = require("../../../system");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
        this.toolSve = system.getObject("service.trademark.toolSve");
    }
    /**
          * 接口跳转-POST请求
          * action_process  执行的流程
          * action_type     执行的类型
          * action_body     执行的参数
          */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        // var result = null;
        // switch (pobj.actionProcess) {
        //     case "jd"://京东
        //         result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        //         break;
        //     case "1688"://1688
        //         result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        //         break;
        //     case "gsbhome"://gsb_homepage
        //         result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        //         break;
        //     default:
        //         result = system.getResult(null, "actionProcess参数错误");
        //         break;
        // }
        return result;
    }
    async opActionProcess(action_process, action_type, action_body, req) {
        var opResult = system.getResult(null, "req Failure");
        var userpin = this.getUUID();
        action_body.appInfo = req.app;
        var opStr = action_body.userName || action_body.mobile;
        var encryptStrResult = await this.toolSve.encryptStr(req.app, opStr);
        if (encryptStrResult.status == 0) {
            encryptStrResult.data = encodeURIComponent(encryptStrResult.data);
        }
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getVerifyCode":
                opResult = await this.opPlatformUtils.getVerifyCodeByMoblie(action_body);
                if (opResult.status == 0) {
                    return system.getResultSuccess()
                }
                break;
            case "loginUserByChannelUserId"://????
                opResult = await this.opPlatformUtils.getReqUserPinByChannelUserId(action_body, userpin);
                if (opResult.status == 0) {
                    return system.getResultSuccess({ userpin: userpin, channelUserId: encryptStrResult.data, userName: actionBody.channelUserId })
                }
                break;
            case "userPinByLgoin":
                opResult = await this.opPlatformUtils.getReqUserPinByLgoin(action_body, userpin);
                if (opResult.status == 0) {
                    return system.getResultSuccess({ userpin: userpin, channelUserId: encryptStrResult.data, userName: opStr })
                }
                break;
            case "userPinByLgoinVcode":
                opResult = await this.opPlatformUtils.getReqUserPinByLgoinVcode(action_body, userpin, "login");
                if (opResult.status == 0) {
                    return system.getResultSuccess({ userpin: userpin, channelUserId: encryptStrResult.data, userName: opStr })
                }
                break;
            case "userPinByRegister":
                opResult = await this.opPlatformUtils.getReqUserPinByLgoinVcode(action_body, userpin, "reg");
                if (opResult.status == 0) {
                    return system.getResultSuccess({ userpin: userpin, channelUserId: encryptStrResult.data, userName: opStr })
                }
                break;
            case "logout":
                opResult = await this.opPlatformUtils.userLogout(action_body);
                break;
            case "putUserPwdByMobile":
                opResult = await this.opPlatformUtils.putUserPwdByMobile(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }


    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      */
    async getAppTokenByHosts(pobj, qobj, req) {
        var token = this.getUUID();
        var opResult = await this.opPlatformUtils.getReqTokenByHosts(pobj.actionBody.app_hosts, token);
        if (opResult.status != 0) {
            return opResult;
        }
        return system.getResultSuccess({ token: token })
    }

    async getToken(pobj, qobj, req) {
        var appkey = pobj.appkey;
        var secret = pobj.secret;
        if (!appkey) {
            return system.getResult(null, "appkey参数不能为空");
        }
        if (!secret) {
            return system.getResult(null, "secret参数不能为空");
        }
        var result = await this.opPlatformUtils.getReqApiAccessKey(appkey, secret);
        if (result && result.status && result.status != 0) {
            return result;
        }
        var resultData = {
            token: result && result.data ? result.data.accessKey : ""
        };
        return system.getResultSuccess(resultData);
    }
    /**
  * 开放平台回调处理
  * @param {*} req 
  */
    async authByCode(pobj, qobj, req) {
        return await this.opPlatformUtils.authByCode(qobj.code);
    }

}
module.exports = AccessAuthAPI;