const system = require("../../../system");
var APIBase = require("../../api.base");
var settings = require("../../../../config/settings");
var moment = require('moment')
class TradetransferAPI extends APIBase {
  constructor() {
    super();
    this.aliclient = system.getObject("util.aliyunClient");
    this.execlient = system.getObject("util.execClient");
    this.transferurl = settings.reqTransferurl();
    this.corderSve = system.getObject("service.dbcorder.orderinfoSve");
  }

  //订单创建
  async createtransfer(p, obj, req) {

    console.log(p.actionBody, "actionBody...............................");
    var orderinfo = await this.corderSve.createOrder(p.actionBody, req);
    console.log(orderinfo, "orderinfo............................");
    if (orderinfo) {
      if (orderinfo.status == "0") {
        var result = {
          "errorCode": "OK",
          "errorMsg": "成功",
          "module": { "orderId": orderinfo.data.orderNo },
          "requestId": req.requestId,
          "success": true
        }
        return result;
      } else if (orderinfo.status == "2") {
        var result = {
          "errorCode": "OK",
          "errorMsg": "订单已存在",
          "module": { "orderId": orderinfo.data },
          "requestId": req.requestId,
          "success": true
        }
        return result;
      } else {
        var result = {
          "errorCode": "error",
          "errorMsg": orderinfo.msg,
          "module": { "orderId": "" },
          "requestId": req.requestId,
          "success": false
        }
        return result;
      }

    } else {
      var result = {
        "errorCode": "error",
        "errorMsg": "",
        "module": { "orderId": "" },
        "requestId": req.requestId,
        "success": false
      }
      return result;
    }
  }

  //订单查询
  async ordersel(p, obj) {
    var url = this.transferurl + "api/transfer/tradeApi/queryOrderState";
    var transferinfo = await this.execlient.execPost(p.actionBody, url);
    var a = JSON.parse(transferinfo.stdout)
    return a;
  }

  //订单关闭
  async orderclose(p,obj) {
    var url = this.transferurl + "api/transfer/tradeApi/closeOrder";
    var transferinfo = await this.execlient.execPost(p.actionBody, url);
    var a = JSON.parse(transferinfo.stdout)
    return a;

  }

  //业务员分配
  async fenpeiowner(obj) {
    if (!obj.BizId) {
      return {
        "errorCode": "error",
        "errorMsg": "订单号不能为空",
        "requestId": obj.requestId,
        "success": false
      }
    }
    var transferinfo = await this.findOne({ ali_bizid: obj.BizId });
  }


  //阿里网关
  async aliclienttransfer(p, obj) {
    console.log("----------------sssssssssssssssssss-------------------------------------------")
    console.log(p.actionBody)
    if (p.actionBody) {
      console.log(p.actionBody)
      var rtn = await this.aliclient.reqbyget(p.actionBody)
      return rtn;
    }
  }
}
module.exports = TradetransferAPI;
