var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class TmOrderAPI extends APIBase {
    constructor() {
        super();
        this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
        this.orderSve = system.getObject("service.dborder.orderSve");
        this.ordertmproductSve = system.getObject("service.dborder.ordertmproductSve");
        this.customerinfoSve = system.getObject("service.dborder.customerinfoSve");
        this.customercontactsSve = system.getObject("service.dborder.customercontactsSve");
        this.trademarkSve = system.getObject("service.dbtrademark.trademarkSve");
        this.zcApiUrl = settings.reqZcApi();
        this.pushFqbossDataUrl = settings.pushFqbossDataUrl();
        this.pushlogSve = system.getObject("service.common.pushlogSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
        this.appProductSve = system.getObject("service.dbapp.appproductSve");
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        // var result = null;
        // switch (pobj.actionProcess) {
        //     case "jd"://京东
        //         result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        //         break;
        //     case "1688"://1688
        //         result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        //         break;
        //     case "gsbhome"://gsb_homepage
        //         result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, pobj, req);
        //         break;
        //     default:
        //         result = system.getResult(null, "actionProcess参数错误");
        //         break;
        // }
        return result;
    }
    async opActionProcess(action_process, action_type, action_body, pobj, req) {
        action_body.app = req.app;
        action_body.user = req.user;
        // action_body.app = { id:2,uappKey:"201911131657",uAppId:9,appSecret:"eeb18393aade40149287b024d8ba0850"};
        // action_body.user = { id: 6, app_id: 2, nickname: "测试用户",channelUserId:"testUserId01" };
        var opResult = null;
        if (["subTmOrder", "getTmOrderList", "getTmOrderInfo", "getTmApplyInfo", "getTmNclList", "getNeedInfo",
            "tmConfirm", "updateTmInfo", "updateNclInfo", "updateContacts",
            "updateCustomerInfo", "addOrderAndDelivery", "updateOrderPayStatus"].indexOf(action_type) >= 0) {
            if (!action_body.channelUserId) {
                return system.getResult(null, "verify channelUserId is empty");
            }
        }
        switch (action_type) {
            // sy
            case "againPushFqBusiness"://再次推送商机
                opResult = await this.orderSve.againPushFqBusiness(pobj, req);
                break;
            case "updateOrderStatus"://更新订单状态
                opResult = await this.orderSve.updateOrderStatus(action_body, pobj, req);
                break;
            case "updateOrderPayStatus"://更新订单付款状态
                opResult = await this.orderSve.updateOrderPayStatus(action_body, pobj, req);
                if (opResult.status == 0) {
                    pobj.actionBody["deliveryOrderNo"] = opResult.data.deliveryOrderNo;
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelPayStatus";
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "addOrderAndDelivery"://创建订单和交付单
                opResult = await this.orderSve.addOrderAndDelivery(action_body, pobj, req);
                break;
            case "clearAllCache":
                await this.cacheManager["MagCache"].clearAll();
                opResult = system.getResultSuccess(null, "清理缓存成功");
                break;
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "getOrderList"://获取订单列表(分页)
                opResult = await this.orderinfoSve.findAndCountAll(action_body, req);
                break;
            case "getOrderDetailByOrderNo"://获取订单详情
                opResult = await this.orderinfoSve.getOrderDetailByOrderNo(action_body, req);
                break;
            case "decryptStr"://
                opResult = await this.toolSve.decryptStr(req.app, action_body.opStr);
                break;
            case "op1688ChannelPushOrder"://处理渠道订单信息
                opResult = await this.orderSve.op1688ChannelPushOrder(action_body, pobj, req);
                if (opResult.status == 0) {
                    opResult.data = null;
                    var encryptResult = await this.toolSve.encryptStr(req.app, action_body.channelUserId);
                    if (encryptResult.status == 0 && encryptResult.data && encryptResult.data != "undefined") {
                        opResult.data = encryptResult.data;
                    }
                }
                break;
            case "get1688ChannelOrderInfo"://获取渠道订单信息
                opResult = await this.ordertmproductSve.get1688ChannelOrder(action_body);
                break;
            case "subTmOrder"://商标提报               
                opResult = await this.ordertmproductSve.addTmOrder(action_body, pobj, req);
                if (opResult && opResult.status == 0 && opResult.data) {
                    var returnTms = opResult.data.tm;
                    for (var i = 0; i < pobj.actionBody.nclones.length; i++) {
                        var nclone = pobj.actionBody.nclones[i];
                        for (var j = 0; j < returnTms.length; j++) {
                            var returnTm = returnTms[j];
                            if (returnTm.nclOne && nclone.code && returnTm.nclOne == nclone.code) {
                                pobj.actionBody.nclones[i]["tbCode"] = returnTm.tbCode;
                            }
                        }
                    }
                    pobj.actionBody["deliveryOrderNo"] = opResult.data.deliveryOrderNo;
                    pobj.actionBody["itemCode"] = opResult.data.channelItemCode;
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/createChannelOrder"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "subExistTmOrder"://提交存在商标提报               
                opResult = await this.ordertmproductSve.addExistTmOrder(action_body);
                if (opResult && opResult.status == 0 && opResult.data) {
                    var returnTms = opResult.data.tm;
                    for (var i = 0; i < pobj.actionBody.nclones.length; i++) {
                        var nclone = pobj.actionBody.nclones[i];
                        for (var j = 0; j < returnTms.length; j++) {
                            var returnTm = returnTms[j];
                            if (returnTm.nclOne && nclone.code && returnTm.nclOne == nclone.code) {
                                pobj.actionBody.nclones[i]["tbCode"] = returnTm.tbCode;
                            }
                        }
                    }
                    pobj.actionBody["deliveryOrderNo"] = opResult.data.deliveryOrderNo;
                    pobj.actionBody["itemCode"] = opResult.data.channelItemCode;
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/createChannelOrder"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "getTmOrderList"://商标交付列表            
                opResult = await this.ordertmproductSve.getTmOrderList(action_body, pobj, req);
                break;
            case "getOrderDetails"://            
                opResult = await this.ordertmproductSve.getOrderDetails(action_body, pobj, req);
                break;
            case "getTmOrderListAdmin"://商标交付列表  
                action_body.getListType = "getTmOrderListAdmin";
                opResult = await this.ordertmproductSve.getTmOrderList(action_body, pobj, req);
                break;
            case "getTmOrderInfo"://商标交付信息
                opResult = await this.ordertmproductSve.getTmOrder(action_body);
                break;
            case "getTmApplyInfo"://商标订单-申请信息
                opResult = await this.ordertmproductSve.getTmApply(action_body);
                break;
            case "getTmNclList"://商标订单-商标尼斯信息
                opResult = await this.ordertmproductSve.getTmNclList(action_body);
                break;
            case "updateTmInfo"://修改商标订单-商标信息修改
                opResult = await this.trademarkSve.updateTmInfo(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelTmInfo"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateNclInfo"://修改商标订单-商标尼斯信息修改
                opResult = await this.trademarkSve.updateNclInfo(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelNclInfo"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateContacts"://修改商标订单-修改商标交付单联系人
                opResult = await this.customercontactsSve.updateContacts(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelContacts"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateCustomerInfo"://修改商标订单-修改申请人信息
                opResult = await this.customerinfoSve.updateCustomerInfo(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelCustomerInfo"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "updateOfficial"://修改商标订单-修改交官文件
                opResult = await this.customerinfoSve.updateOfficial(action_body);
                if (opResult && opResult.status == 0) {
                    // await this.pushData(opResult, req, pobj);
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/updateChannelOfficial"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "tmConfirm"://商标方案确认
                opResult = await this.ordertmproductSve.tmConfirm(action_body);
                if (opResult && opResult.status == 0) {
                    var url = this.pushFqbossDataUrl + "api/channelaccessApi/channelTmConfirm"
                    this.pushData2(opResult, req, pobj, url);
                }
                break;
            case "pushFqBusiness"://推送商机到峰擎
                opResult = await this.orderSve.push1688FqBusiness(action_body, pobj, req);
                break;
            case "getProductDetail"://根据渠道产品码获取产品详情
                opResult = await this.appProductSve.findByChannelItemCode(action_body);
                break;
            case "getProductListByTypeOneCode"://获取产品列表(根据产品一类编码获取)
                opResult = await this.appProductSve.findByProductOneTypeCode(action_body);
                break;
            case "getProductListByTypeCode"://获取产品列表(根据父类产品编码获取)
                opResult = await this.appProductSve.findByProductTypeCode(action_body);
                break;
            case "getCAProductDetail"://根据渠道产品码获取产品详情 ---应用中心
                // opResult = await this.appProductSve.findByChannelItemCode(action_body);
                pobj["app"] = req.appInfo;
                pobj["appInfo"] = req.appInfo;
                opResult = await this.appProductSve.getProductDetailByCode(pobj);
                break;
            case "getCAProductListByTypeOneCode"://获取产品列表(根据产品一类编码获取) ---应用中心
                // opResult = await this.appProductSve.findByProductOneTypeCode(action_body);
                pobj["app"] = req.appInfo;
                pobj["appInfo"] = req.appInfo;
                opResult = await this.appProductSve.findByTypeOneCode(pobj);
                break;
            case "getCAProductListByTypeCode"://获取产品列表(根据父类产品编码获取) ---应用中心
                // opResult = await this.appProductSve.findByProductTypeCode(action_body);
                pobj["app"] = req.appInfo;
                pobj["appInfo"] = req.appInfo;
                opResult = await this.appProductSve.findByTypeCode(pobj);
                break;
            case "subGsbOrderInfo"://提交公司宝订单信息
                opResult = await this.orderSve.gsbOrderInfo(pobj, req);
                break;
            case "checkPayStatusTl"://检查通联支付状态(未测试)
                opResult = await this.orderSve.checkPayStatusTl(action_body);
                break;
            case "getTlPayQrCode"://获取通联支付二维码(未测试)
                opResult = await this.orderSve.getTlPayQrCode(action_body);
                break;
            case "receiveTlCallBackNotify"://接收通联支付回调通知(未测试)
                opResult = await this.orderSve.receiveTlCallBackNotify(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    //数据推送
    async pushData(opResult, req, pobj) {
        var url = this.zcApiUrl + "action/tmOrder/springBoard";
        var rc = system.getObject("util.execClient");
        var rtn = null;
        var requestId = opResult.requestId || req.requestId;
        if (requestId) {
            rtn = await rc.execPushDataPost(pobj, url, req.headers["token"], req.headers["request-id"]);
        } else {
            rtn = await rc.execPost(pobj, url);
        }
        var returnType = "0";
        if (rtn && rtn.code == 1) {
            returnType = "1";
        }
        this.pushlogSve.createDb({
            appid: req.app.id,
            appkey: req.app.uappKey,
            requestId: opResult.requestId || req.requestId,
            op: url,
            content: JSON.stringify(pobj),
            resultInfo: JSON.stringify(rtn),
            clientIp: req.clientIp,
            returnType: returnType,
            agent: req.uagent,
            opTitle: "数据推送",
        });
    }

    //数据推送fqboss
    async pushData2(opResult, req, pobj, url) {
        var rc = system.getObject("util.execClient");
        var obj = pobj.actionBody;
        var user = obj.user;
        if (obj.app) {
            obj.app = null;
        }
        obj["channelUserId"] = obj.channelUserId;
        obj["channelCode"] = pobj.actionProcess;
        obj["appid"] = "2e787bbaacda4c6488b9fae58fff30ba";
        var rtn = null;
        try {
            var requestId = opResult.requestId || req.requestId;
            if (requestId) {
                rtn = await rc.execPushDataPost(obj, url, req.headers["token"], req.headers["request-id"]);
            } else {
                rtn = await rc.execPost(obj, url);
            }
            var returnType = "0";
            if (rtn.stdout) {
                var j = JSON.parse(rtn.stdout);
                if (j && j.code == 1) {
                    returnType = "1";
                }
            }
            this.pushlogSve.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: opResult.requestId || req.requestId,
                op: url,
                content: JSON.stringify(obj),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                returnType: returnType,
                agent: req.uagent,
                opTitle: "数据推送",
            });
        } catch (e) {
            this.pushlogSve.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: opResult.requestId || req.requestId,
                op: url,
                content: JSON.stringify(obj),
                resultInfo: JSON.stringify(e.stack),
                clientIp: req.clientIp,
                returnType: '0',
                agent: req.uagent,
                opTitle: "数据推送",
            });
        }
    }

}
module.exports = TmOrderAPI;