const system = require("../system");
const settings = require("../../config/settings");
const DocBase = require("./doc.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class APIBase {
    constructor() {
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.logCtl = system.getObject("service.common.oplogSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
        this.exTime = 6 * 3600;//缓存过期时间，6小时
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    /**
     * 验证签名
     * @param {*} params 要验证的参数 
     * @param {*} app_key 应用的校验key
     */
    async verifySign(params, app_key) {
        if (!params) {
            return system.getResult(null, "请求参数为空");
        }
        if (!params.sign) {
            return system.getResult(null, "请求参数sign为空");
        }
        if (!params.timestamp) {
            return system.getResult(null, "请求参数timestamp为空");
        }
        var signArr = [];
        var keys = Object.keys(params).sort();
        if (keys.length == 0) {
            return system.getResult(null, "请求参数信息为空");
        }
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "sign" && params[tKey]) {
                signArr.push(tKey + "=" + params[tKey]);
            }
        }
        if (signArr.length == 0) {
            return system.getResult(null, "请求参数组装签名参数信息为空");
        }
        var resultSignStr = signArr.join("&") + "&key=" + app_key;
        var resultTmpSign = md5(resultSignStr).toUpperCase();
        if (params.sign != resultTmpSign) {
            return system.getResult(null, "签名验证失败");
        }
        return system.getResultSuccess();
    }
    /**
 * 白名单验证
 * @param {*} gname 组名
 * @param {*} methodname 方法名
 */
    async isCheckWhiteList(gname, methodname) {
        var fullname = gname + "." + methodname;
        var lst = [
            "test.test",
            "action.info",
            "action.error",
            "auth.getToken",
            "auth.getJdSign",
            "task.zc2channel"
        ];
        var x = lst.indexOf(fullname);
        return x >= 0;
    }
    async checkAcck(gname, methodname, pobj, query, req) {
        var uAppInfo = null;
        var selfAppInfo = null;
        var ispass = await this.isCheckWhiteList(gname, methodname);
        if (ispass) {
            return system.getResultSuccess();
        }//在白名单里面
        var token = req.headers["token"];
        if (!token) {
            return system.getResult(null, "token不能为空");
        }
        uAppInfo = await this.cacheManager["ApiAccessKeyCheckCache"].cache(token, { status: true }, this.exTime);
        if (!uAppInfo || (uAppInfo.status && uAppInfo.status != 0)) {
            return uAppInfo;
        }
        var selfAppInfo = await this.cacheManager["ApiAppKeyCheckCache"].cache(uAppInfo.data.app.appkey, null, this.exTime);
        if (!selfAppInfo || (selfAppInfo.status && selfAppInfo.status != 0)) {
            return selfAppInfo;
        }
        // if (!appInfo) {
        //     return system.getResult(null, "通过token获取sign的密钥信息失败，请重新获取");
        // }
        // var signResult = await this.verifySign(pobj.action_body, appInfo.appSecret);
        // if (signResult.status != 0) {
        //     return system.getResultFail(system.signFail, signResult.msg);
        // }
        if (pobj.isUser && pobj.isUser == "yes") {
            var channelUserId = pobj.channelUserId ? pobj.channelUserId : pobj.actionBody.channelUserId || "";
            if (!channelUserId && pobj.actionBody.channelUser) {
                channelUserId = pobj.actionBody.channelUser.channelUserId;
            }
            if (!channelUserId) {
                return system.getResult(null, "base verify channelUserId is empty");
            }
            var userCacheKey = selfAppInfo.data.uappKey + "_" + channelUserId;
            var userInfo = await this.cacheManager["ApiUserCache"].cache(userCacheKey, channelUserId,
                this.exTime, pobj.actionBody, selfAppInfo, uAppInfo.data.app.id);
            if (!userInfo || (userInfo.status && userInfo.status != 0)) {
                return userInfo;
            }
            if (userInfo.data && userInfo.data.isEnabled && userInfo.data.isEnabled != 1) {
                return system.getResultFail(system.getUserInfoFail, "用户处于待审核等待启用状态");
            }
            req.user = userInfo.data;
            pobj.actionBody.channelUserId = channelUserId;
        }
        req.app = selfAppInfo.data;
        return system.getResultSuccess();
    }
    async doexec(gname, methodname, pobj, query, req) {
        var requestid = req.headers["request-id"] || this.getUUID();
        if (!req.headers["request-id"]) {
            req.headers["request-id"] = requestid;
        }
        try {
            if (pobj.actionType == "createChannelUser") {
                if (!pobj.isUser) {
                    system.getResult(null, "isUser is empty");
                }
                if (pobj.isUser != "yes") {
                    system.getResult(null, "isUser value must yes");
                }
            }
            //验证accesskey或验签
            var isPassResult = await this.checkAcck(gname, methodname, pobj, query, req);
            if (isPassResult.status != 0) {
                isPassResult.requestId = "";
                return isPassResult;
            }
            if (pobj.actionType == "createChannelUser") {
                var encryptResult = await this.toolSve.encryptStr(req.app, req.user.channelUserId);
                if (encryptResult.status != 0) {
                    system.getResult(null, "encrypt channelUserId is error");
                }
                req.user.encryptChannelUserId = encryptResult.data;
                return system.getResultSuccess(req.user);
            }//创建用户
            req.requestId = requestid;
            var rtn = await this[methodname](pobj, query, req);
            if (rtn && !rtn.requestId) {
                rtn.requestId = requestid;
            }
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: requestid,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            return rtn;
        } catch (e) {
            console.log(e.stack, "api调用出现异常，请联系管理员..........")
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: requestid,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(e.stack),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api调用出现异常，请联系管理员error，appKey:" + settings.appKey,
            });
            this.logCtl.error({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: requestid,
                op: pobj.classname + "/" + methodname,
                content: e.stack,
                clientIp: pobj.clientIp,
                agent: req.uagent,
                optitle: "api调用出现异常，请联系管理员",
            });
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + e.stack);
            rtnerror.requestId = requestid;
            return rtnerror;
        }
    }

    //-----------------------新的模式------------------开始

    async doexecMethod(gname, methodname, pobj, query, req) {
        req.requestId = this.getUUID();
        try {
            // //验证accesskey或验签
            // var isPassResult = await this.checkAcck(gname, methodname, pobj, query, req);
            // if (isPassResult.status != 0) {
            //     isPassResult.requestId = "";
            //     return isPassResult;
            // }
            var rtn = await this[methodname](pobj, query, req);
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            rtn.requestId = req.requestId;
            return rtn;
        } catch (e) {
            console.log(e.stack, "api调用出现异常，请联系管理员..........")
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(e.stack),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api调用出现异常，请联系管理员error，appKey:" + settings.appKey,
            });
            this.logCtl.error({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: pobj.classname + "/" + methodname,
                content: e.stack,
                clientIp: pobj.clientIp,
                agent: req.uagent,
                optitle: "api调用出现异常，请联系管理员",
            });
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + e.stack);
            rtnerror.requestId = req.requestId;
            return rtnerror;
        }
    }

    //-----------------------新的模式------------------结束
}
module.exports = APIBase;
