DROP TABLE  `c_ecompany`;
DROP TABLE  `c_econtract`;
DROP TABLE  `c_etemplate`;

CREATE TABLE `c_econtract` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) DEFAULT NULL,
  `edocid` VARCHAR(255) DEFAULT NULL,
  `eflowid` VARCHAR(255) DEFAULT NULL,
  `esignUrl` VARCHAR(255) DEFAULT NULL,
  `fileurl` VARCHAR(255) DEFAULT NULL,
  `eflowstatusname` VARCHAR(20) DEFAULT '签署中',
  `eflowstatus` ENUM('0','1','2','3','4','5','6','7') DEFAULT '0',
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  `deleted_at` DATETIME DEFAULT NULL,
  `completed_at` DATETIME DEFAULT NULL,
  `begin_at` DATETIME DEFAULT NULL,
  `end_at` DATETIME DEFAULT NULL,
  `version` INT(11) NOT NULL DEFAULT '0',
  `etemplate_id` INT(11) DEFAULT NULL,
  `user_id` INT(11) DEFAULT NULL,
  `ecompany_id` INT(11) DEFAULT NULL,
  `resultDescription` VARCHAR(255) DEFAULT NULL,
  `isPush` TINYINT(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `c_ecompany` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `isEnabled` TINYINT(1) NOT NULL DEFAULT '1',
  `isQuiet` TINYINT(1) NOT NULL DEFAULT '1',
  `sealurl` VARCHAR(255) DEFAULT NULL,
  `encryptkey` VARCHAR(255) DEFAULT NULL,
  `posturl` VARCHAR(255) DEFAULT NULL,
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  `deleted_at` DATETIME DEFAULT NULL,
  `version` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `c_etemplate` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `templateid` VARCHAR(255) DEFAULT '',
  `filekey` VARCHAR(255) DEFAULT NULL,
  `filepath` VARCHAR(255) DEFAULT NULL,
  `placeholderkey` VARCHAR(255) DEFAULT NULL,
  `isEnabled` TINYINT(1) NOT NULL DEFAULT '1',
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  `deleted_at` DATETIME DEFAULT NULL,
  `version` INT(11) NOT NULL DEFAULT '0',
  `ecompany_id` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4;
