DROP TABLE IF EXISTS `p_service_type`;

CREATE TABLE `p_service_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT NULL COMMENT '类别码',
  `name` varchar(255) DEFAULT NULL COMMENT '类别名称',
  `level` int(11) DEFAULT '1' COMMENT '级别1大类、2二类、3小类',
  `pid` int(11) DEFAULT '0' COMMENT '父子集关系',
  `notes` varchar(255) DEFAULT NULL COMMENT '备注',
  `isEnabled` int(11) DEFAULT '1' COMMENT '是否启用',
  `channelCode` varchar(20) DEFAULT NULL COMMENT '渠道编码',
  `channel_id` int(11) DEFAULT NULL COMMENT '渠道id',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='服务类型';

/*Table structure for table `yz_business_license` */

DROP TABLE IF EXISTS `yz_business_license`;

CREATE TABLE `yz_business_license` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '项目id',
  `serviceTypeOneId` int(11) DEFAULT NULL COMMENT '一级类型Id',
  `serviceTypeTwoId` int(11) DEFAULT NULL COMMENT '一级下的二级类型Id',
  `code` varchar(20) NOT NULL DEFAULT '0' COMMENT '执照编码',
  `name` varchar(255) NOT NULL COMMENT '执照名称',
  `guidePrice` decimal(12,2) DEFAULT '0.00' COMMENT '指导价',
  `serviceScope` varchar(500) DEFAULT NULL COMMENT '服务范围',
  `webPic` varchar(255) DEFAULT NULL COMMENT 'web端图片',
  `mobilePic` varchar(255) DEFAULT NULL COMMENT '移动端图片',
  `mobileContentImg` varchar(255) DEFAULT NULL COMMENT '移动内容图片',
  `answerConent` varchar(255) DEFAULT NULL COMMENT '问答内容',
  `intro` varchar(500) DEFAULT NULL COMMENT '介绍',
  `registerDay` datetime DEFAULT NULL COMMENT '注册日期',
  `businessEndDay` datetime DEFAULT NULL COMMENT '营业截至日期',
  `registerProvince` varchar(50) DEFAULT NULL COMMENT '注册省份',
  `registerCity` varchar(50) DEFAULT NULL COMMENT '注册城市',
  `registerArea` varchar(50) DEFAULT NULL COMMENT '注册地区',
  `registerAddr` varchar(255) DEFAULT NULL COMMENT '注册地址',
  `sort` int(11) DEFAULT '0' COMMENT '排序',
  `channel_id` int(11) DEFAULT NULL COMMENT '渠道Id',
  `channelCode` varchar(50) DEFAULT NULL COMMENT '渠道编码：p_channel表中的channelCode',
  `hotline` varchar(20) DEFAULT NULL COMMENT '咨询电话',
  `notes` varchar(255) DEFAULT NULL COMMENT '备注信息',
  `opOnlyCode` varchar(50) DEFAULT NULL COMMENT '操作人唯一编码',
  `companyPropertyName` varchar(50) DEFAULT '小规模' COMMENT '公司性质名称',
  `companyProperty` enum('1','2') DEFAULT '1' COMMENT '公司性质，1小规模、2一般',
  `isPubed` int(11) DEFAULT '0' COMMENT '是否可以交易，0不发布，1发布，默认为0',
  `isRecommend` int(11) DEFAULT '0' COMMENT '是否推荐：0: 否, 1: 是',
  `isNegotiable` int(11) DEFAULT '0' COMMENT '是否面议：0: 否, 1: 是',
  `isBankAccount` int(11) DEFAULT '0' COMMENT '银行是否开户',
  `isNormalOperation` int(11) DEFAULT '0' COMMENT '经营是否正常',
  `isLocalTax` int(11) DEFAULT '0' COMMENT '过地税报道',
  `isFiscal` int(11) DEFAULT '0' COMMENT '是否有税控',
  `isKeepAccountsTax` int(11) DEFAULT '0' COMMENT '记账报税是否正常',
  `invoiceVersionName` varchar(50) DEFAULT '十万版' COMMENT '发票版本名称',
  `invoiceVersion` enum('1','2','3') DEFAULT '1' COMMENT '发票版本，1十万版、万元版、百万版',
  `isAddrCharge` int(11) DEFAULT '0' COMMENT '地址是否收费',
  `changeServiceName` varchar(50) DEFAULT '包变更' COMMENT '变更服务名称',
  `changeService` enum('1','2') DEFAULT '1' COMMENT '变更服务，1包变更、2买家变更',
  `publishedSourcesName` varchar(50) DEFAULT '公司' COMMENT '发布来源名称',
  `publishedSources` enum('1','2') DEFAULT '1' COMMENT '发布来源，1公司、2个人',
  `onlyCode` varchar(50) DEFAULT NULL COMMENT '发布者唯一码',
  `companyOnlyCode` varchar(50) DEFAULT NULL COMMENT '公司的唯一码',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COMMENT='营业执照表';

/*Table structure for table `yz_buy_business_license` */

DROP TABLE IF EXISTS `yz_buy_business_license`;

CREATE TABLE `yz_buy_business_license` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '项目id',
  `serviceTypeOneId` int(11) DEFAULT NULL COMMENT '一级类型Id',
  `serviceTypeTwoId` int(11) DEFAULT NULL COMMENT '一级下的二级类型Id',
  `guidePrice` decimal(12,2) DEFAULT '0.00' COMMENT '指导价',
  `serviceScope` varchar(500) DEFAULT NULL COMMENT '服务范围',
  `registerDay` datetime DEFAULT NULL COMMENT '注册日期',
  `registerProvince` varchar(50) DEFAULT NULL COMMENT '注册省份',
  `registerCity` varchar(50) DEFAULT NULL COMMENT '注册城市',
  `registerArea` varchar(50) DEFAULT NULL COMMENT '注册地区',
  `registerAddr` varchar(255) DEFAULT NULL COMMENT '注册地址',
  `sort` int(11) DEFAULT '0' COMMENT '排序',
  `channel_id` int(11) DEFAULT NULL COMMENT '渠道Id',
  `channelCode` varchar(50) DEFAULT NULL COMMENT '渠道编码：p_channel表中的channelCode',
  `hotline` varchar(20) DEFAULT NULL COMMENT '咨询电话',
  `notes` varchar(200) DEFAULT NULL COMMENT '备注信息',
  `opOnlyCode` varchar(50) DEFAULT NULL COMMENT '操作人唯一编码',
  `companyPropertyName` varchar(50) DEFAULT '小规模' COMMENT '公司性质名称',
  `companyProperty` enum('1','2') DEFAULT '1' COMMENT '公司性质，1小规模、2一般',
  `isPubed` int(11) DEFAULT '0' COMMENT '是否可以交易，0不发布，1发布，默认为0',
  `isRecommend` int(11) DEFAULT '0' COMMENT '是否推荐：0: 否, 1: 是',
  `isNegotiable` int(11) DEFAULT '0' COMMENT '是否面议：0: 否, 1: 是',
  `changeServiceName` varchar(50) DEFAULT '包变更' COMMENT '变更服务名称',
  `changeService` enum('1','2') DEFAULT '1' COMMENT '变更服务，1包变更、2买家变更',
  `registeredCapitalName` varchar(50) DEFAULT '小于100万' COMMENT '注册资本名称',
  `registeredCapital` enum('1','2','4','8','16') DEFAULT '1' COMMENT '注册资本，1：小于100万、2:：100-500万、4：501-1000万、8：1001-5000万、16：大于1000万',
  `onlyCode` varchar(50) DEFAULT NULL COMMENT '发布者唯一码',
  `companyOnlyCode` varchar(50) DEFAULT NULL COMMENT '公司的唯一码',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COMMENT='购买营业执照表';

/*Table structure for table `yz_user_track` */

DROP TABLE IF EXISTS `yz_user_track`;

CREATE TABLE `yz_user_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `businesslicense_id` int(11) DEFAULT NULL COMMENT '营业执照Id',
  `buybusinesslicense_id` int(11) DEFAULT NULL COMMENT '购买营业执照Id',
  `onlyCode` varchar(50) DEFAULT NULL COMMENT '创建者的唯一码',
  `beOpOnlyCode` varchar(50) DEFAULT NULL COMMENT '被操作者的唯一码',
  `notes` varchar(200) DEFAULT NULL COMMENT '备注',
  `trackTypeName` varchar(50) DEFAULT '收藏' COMMENT '足迹类型名称',
  `trackType` enum('1','2') DEFAULT '1' COMMENT '足迹类型，1收藏、2访问',
  `companyOnlyCode` varchar(50) DEFAULT NULL COMMENT '公司的唯一码',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户足迹';
