/*20190724*/
ALTER TABLE h_trade_mark MODIFY tmSourceType ENUM('1','2','4','8','16','32') DEFAULT '1';
ALTER TABLE h_trade_mark ADD COLUMN needId VARCHAR(50) DEFAULT NULL COMMENT '需求ID'; 
ALTER TABLE h_trade_mark ADD COLUMN businessId VARCHAR(50) DEFAULT NULL COMMENT '业务ID'; 
ALTER TABLE h_trade_mark ADD COLUMN channelOrderListInfo VARCHAR(500) DEFAULT NULL COMMENT '渠道服务单号对应的订单列表信息'; 

/*b_user_customer-------------add*/
ALTER TABLE b_user_customer ADD COLUMN customerContact VARCHAR(50) DEFAULT NULL COMMENT '联系人'; 
ALTER TABLE b_user_customer ADD COLUMN customerMobile VARCHAR(20) DEFAULT NULL COMMENT '联系人电话'; 

/*删除p_customer_info表列*/
ALTER TABLE p_customer_info DROP  COLUMN customerContact;
ALTER TABLE p_customer_info DROP  COLUMN customerMobile;


/*p_customer_info新增列*/
ALTER TABLE p_customer_info ADD COLUMN notes VARCHAR(255) DEFAULT NULL COMMENT '备注'; 
ALTER TABLE p_customer_info ADD COLUMN customerNotes VARCHAR(255) DEFAULT NULL COMMENT '客户备注'; 
ALTER TABLE p_customer_info ADD COLUMN customerOnlyCode VARCHAR(255) DEFAULT NULL COMMENT '客户onlycode'; 


/*h_page_statistics统计*/
ALTER TABLE h_page_statistics ADD COLUMN isRead int default 0 COMMENT '是否阅读,0未，1是'; 

/*p_app boss小程序 2018-11-15 10:50:02*/
INSERT INTO `p_app` (`appid`,`secret`,`name`,`isEnabled`,`created_at`,`updated_at`,`deleted_at`,`version`) VALUES ('wx5ab0a6c0311e6b1e','032720f63c2b4e4b934ee5c8130e4711','boss',1,'2018-11-15 10:49:59','2018-11-15 10:50:02',NULL,0);

/*p_user表 2018-11-19 20:11:02*/
ALTER TABLE p_user ADD COLUMN customerrollpic_id int DEFAULT 0 COMMENT '关注的海报的id'; 
/*p_app表 2018-11-19 20:11:02*/
ALTER TABLE p_app MODIFY app_code bigint DEFAULT NULL COMMENT '应用code，8位数字'; 


 /*b_customer_roll_pic表 2018-11-19 20:11:02*/
 ALTER TABLE b_customer_roll_pic ADD COLUMN picType ENUM('roll','placard') DEFAULT 'roll';/*roll滚动图片、placard海报图片*/
 ALTER TABLE b_customer_roll_pic ADD COLUMN picCategory ENUM('ip','ic','pa','icbc','common') DEFAULT 'ip';/*图片分类:ip: 商标, ic: 版权, pa: 专利,common: 增值*/
 ALTER TABLE b_customer_roll_pic ADD COLUMN jumpUrl VARCHAR(255) DEFAULT NULL COMMENT '跳转链接'; 
 
/*h_page_statistics表 2018-11-19 20:11:02*/
ALTER TABLE h_page_statistics MODIFY statisticsCode ENUM('yddhzxtj','ydfxtj','ydzftj','ydtsdh','yddpfk','ywkhxx','ywfpxx','bossfpxx','bosstsfwg') DEFAULT 'yddhzxtj';

/*cms_servicesitem表 2018-11-19 20:11:02*/
ALTER TABLE cms_servicesitem MODIFY channelType ENUM('hhr','boss','gssy','jssqs') DEFAULT 'hhr';
ALTER TABLE cms_servicesitem MODIFY itemType ENUM('ip','ic','pa','icbc','common') DEFAULT 'ip';

/*h_business_chance表 2018-11-19 20:11:02*/
ALTER TABLE h_business_chance MODIFY chanceType ENUM('ip','ic','pa','icbc','common') DEFAULT 'ip';
ALTER TABLE h_business_chance ADD COLUMN app_code bigint DEFAULT NULL COMMENT '应用code，8位数字'; 
ALTER TABLE h_business_chance ADD COLUMN notes VARCHAR(255) DEFAULT NULL COMMENT '备注'; 

ALTER TABLE cms_servicesitem MODIFY channelType ENUM('hhr','boss','wssy') DEFAULT 'hhr';


DROP TABLE IF EXISTS h_icbc_info;

/*==============================================================*/
/* Table: h_icbc_info                                           */
/*==============================================================*/
CREATE TABLE h_icbc_info
(
   id                   INT NOT NULL AUTO_INCREMENT,
   orderNum             VARCHAR(50),
   app_id               INT COMMENT '平台应用id（创建者平台）',
   user_id              INT DEFAULT 0 COMMENT '用户id（创建者）',
   onlyCode             VARCHAR(50) COMMENT '合伙人唯一码（创建者）',
   userName             VARCHAR(50) COMMENT '平台用户名（创建者）',
   nickName             VARCHAR(50) COMMENT '昵称（创建者）',
   icbcTypeName         VARCHAR(50) COMMENT '工商类型名称',
   icbcType              ENUM('hongkong','gn','gnjssqs'),
   companyNameCn        VARCHAR(255) COMMENT '公司中文名称',
   companyNameEn        VARCHAR(255) COMMENT '公司英文名称',
   regCapital           DOUBLE COMMENT '注册资金',
   regCapitalUnitsName  VARCHAR(20) COMMENT '注册资金单位名称',
   regCapitalUnits       ENUM('RMB','HKD','USD','GBP','JPY'),
   companyNature        VARCHAR(50) COMMENT '公司性质',
   statusProgressName   VARCHAR(50) COMMENT '进展状态名称',
   statusProgress       ENUM('AWAITCHECK','WAITARTIFICIALEXAMINE','AUDITFAIL','TRECVED','NOTRECVED','PASSED','UPLOADAPPLYDOCUMENT','FINISH','DISCARDED'),
   notes                VARCHAR(255) COMMENT '备注',
   customerContact      VARCHAR(50) COMMENT '联系人',
   customerMobile       VARCHAR(20) COMMENT '联系人电话',
   customerEmail        VARCHAR(255) COMMENT '联系人邮箱',
   customerTel          VARCHAR(20) COMMENT '联系人座机',
   customerFax          VARCHAR(20) COMMENT '联系人传真',
   zipFileUrl           VARCHAR(255) COMMENT '压缩文件（包含股东身份证、其他资料）',
   businessLicensePic   VARCHAR(255) COMMENT '营业执照照片',
   regDocument          VARCHAR(255) COMMENT '注册文档',
   regExcel             VARCHAR(255) COMMENT '注册表格',
   opAppId              INT COMMENT '操作者平台应用id',
   opUserId             INT DEFAULT 0 COMMENT '操作用户id',
   opUserName           VARCHAR(50) COMMENT '操作平台用户名',
   opNotes              VARCHAR(255) COMMENT '操作备注',
   app_code             BIGINT COMMENT '商户平台码（用于给渠道商的码，8位数字）',
   serviceItem_code    VARCHAR(20) NOT NULL COMMENT '项目编码，如：sbzc',
   serviceItem_name     VARCHAR(255) NOT NULL COMMENT '项目名称',
   channelUserName      VARCHAR(50) COMMENT '渠道用户名',
   channelOrderNum      VARCHAR(50) COMMENT '渠道方订单号',
   totalServiceCharge   DOUBLE DEFAULT 0 COMMENT '服务费总额',
   totalPublicExpense   DOUBLE DEFAULT 1 COMMENT '官费总额',
   totalPlatformCost    DOUBLE COMMENT '平台费用总额',
   totalSum             DOUBLE COMMENT '总额（平台费用+服务费+官费+发票税费）',
   platformProfitRatio  DECIMAL COMMENT '平台与渠道的服务费分成比率（如：总额100，字段值30，则平台的利润为30=100*(30/100)，剩下的则为渠道利润）',
   channelProfit        DOUBLE COMMENT '渠道服务费利润',
   platformProfit       DOUBLE COMMENT '平台服务费利润',
   sourceTypeName       VARCHAR(50) COMMENT '来源类型名称',
   sourceType           ENUM('1','2','4') NOT NULL DEFAULT '2',
   sourceNotes          VARCHAR(255) COMMENT '来源备注',
  `created_at` DATETIME NOT NULL,
  `updated_at` DATETIME NOT NULL,
  `deleted_at` DATETIME DEFAULT NULL,
  `version` INT(11) NOT NULL DEFAULT '0',	   
   PRIMARY KEY (id)
);

ALTER TABLE h_icbc_info COMMENT '工商信息表';

ALTER TABLE cms_servicesitem ADD COLUMN isRecommend ENUM('0','1') DEFAULT '0';/*是否推荐:0否、1是*/
ALTER TABLE cms_servicesitem ADD COLUMN isRecommendName VARCHAR(50) DEFAULT '否' COMMENT '是否推荐描述'; 

/*base/db/metadata/apps/platform.js文件中类型productCata*/
ALTER TABLE cms_servicesitem MODIFY itemType ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';
ALTER TABLE h_business_chance MODIFY chanceType ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';
ALTER TABLE b_customer_roll_pic MODIFY picCategory ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';
ALTER TABLE h_order_info MODIFY itemType ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';
ALTER TABLE h_shop_service_item MODIFY itemType ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';
ALTER TABLE p_product MODIFY productCata ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';
ALTER TABLE h_filetomail MODIFY fileType ENUM('ip','ic','pa','icbc','iso','common') DEFAULT 'ip';


ALTER TABLE cms_servicesitem MODIFY itemType ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';
ALTER TABLE h_business_chance MODIFY chanceType ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';
ALTER TABLE b_customer_roll_pic MODIFY picCategory ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';
ALTER TABLE h_order_info MODIFY itemType ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';
ALTER TABLE h_shop_service_item MODIFY itemType ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';
ALTER TABLE p_product MODIFY productCata ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';
ALTER TABLE h_filetomail MODIFY fileType ENUM('ip','ic','pa','icbc','iso','common','zscq','cwfw','hyzz','gqzr','xzsp') DEFAULT 'ip';

ALTER TABLE cms_servicesitem ADD COLUMN itemTypeName VARCHAR(50) DEFAULT '商标' COMMENT '服务类型名称'; 
ALTER TABLE h_order_info ADD COLUMN customerNum bigint DEFAULT NULL COMMENT '客户号'; 

ALTER TABLE h_order_info ADD COLUMN channelType ENUM('hhr','boss','wssy') DEFAULT null;
ALTER TABLE h_trade_mark MODIFY tmSourceType ENUM('1','2','4','8','32') DEFAULT '1';
ALTER TABLE h_order_info ADD COLUMN paymentPlatformType ENUM('wx','offline') DEFAULT null;
ALTER TABLE h_order_info ADD COLUMN offlinePayDocument VARCHAR(255) DEFAULT '否' COMMENT '线下支付凭证'; 


ALTER TABLE cms_servicesitem MODIFY channelTypeName VARCHAR(50) DEFAULT '合伙人' COMMENT '渠道类型名称：p_channel表中的channelName'; 
ALTER TABLE cms_servicesitem MODIFY channelType VARCHAR(20) DEFAULT 'hhr' COMMENT '渠道类型：p_channel表中的channelCode'; 
ALTER TABLE cms_servicesitem ADD COLUMN servicesReducedRate  DECIMAL(12,2) DEFAULT NULL COMMENT '服务的折扣率';

ALTER TABLE h_order_info MODIFY channelType VARCHAR(20) DEFAULT 'hhr' COMMENT '渠道类型：p_channel表中的channelCode'; 
ALTER TABLE h_order_info ADD COLUMN isNegotiable ENUM('0','1') DEFAULT null;/*是否面议*/
ALTER TABLE h_order_info ADD COLUMN isNegotiableName VARCHAR(255) DEFAULT '否' COMMENT '是否面议名称'; 

ALTER TABLE h_channel_tm ADD COLUMN opOnlyCode VARCHAR(50) DEFAULT null COMMENT '操作用户唯一码'; 

CREATE TABLE `p_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opAppId` int(11) DEFAULT NULL,
  `opUserId` int(11) DEFAULT NULL,
  `opUserName` varchar(50) DEFAULT NULL,
  `opOnlyCode` varchar(50) DEFAULT NULL,
  `opClientIp` varchar(20) DEFAULT NULL,
  `channelName` varchar(50) DEFAULT NULL,
  `channelCode` varchar(20) DEFAULT NULL,
  `wxAppId` varchar(255) DEFAULT NULL,
  `moreShop` tinyint(1) DEFAULT '0',
  `isEnabled` tinyint(1) DEFAULT '0',
  `channelShopName` varchar(20) DEFAULT NULL,
  `servicesReducedRate` decimal(12,2) DEFAULT '0.00',
  `sort` int(11) DEFAULT '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `p_user_channel` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `channel_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `p_role_channel` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `version` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  `channel_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`role_id`,`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



ALTER TABLE h_order_info ADD COLUMN channelCode VARCHAR(20) DEFAULT 'hhr' COMMENT '渠道类型：p_channel表中的channelCode'; 
ALTER TABLE h_order_info ADD COLUMN channelName VARCHAR(50) DEFAULT '合伙人' COMMENT '渠道类型名称：p_channel表中的channelName'; 


ALTER TABLE h_shop_service_item ADD COLUMN channelCode VARCHAR(20) DEFAULT 'hhr' COMMENT '渠道类型：p_channel表中的channelCode'; 


ALTER TABLE cms_servicesitem ADD COLUMN channelCode VARCHAR(20) DEFAULT null COMMENT '渠道id：p_channel表中的id'; 

ALTER TABLE cms_servicesitem ADD COLUMN channel_id int DEFAULT null COMMENT '渠道id：p_channel表中的id'; 

/*删除列*/
ALTER TABLE cms_servicesitem DROP  COLUMN channelType;
ALTER TABLE cms_servicesitem DROP  COLUMN channelTypeName;
ALTER TABLE h_order_info DROP  COLUMN channelType;



ALTER TABLE cms_servicesitem ADD COLUMN isNegotiable ENUM('0','1') DEFAULT '0';/*是否面议:0否、1是*/
ALTER TABLE cms_servicesitem ADD COLUMN isNegotiableName VARCHAR(50) DEFAULT '否' COMMENT '是否面议描述'; 

ALTER TABLE p_channel ADD COLUMN isPubed tinyint DEFAULT 1 COMMENT '是否可以交易，0不发布，1发布，默认为1'; 
ALTER TABLE cms_servicesitem ADD COLUMN isSeckillName VARCHAR(50) DEFAULT '否' COMMENT '是否秒杀名称'; 
ALTER TABLE cms_servicesitem ADD COLUMN isSeckill ENUM('0','1') DEFAULT '0';/*是否秒杀:0否、1是*/
ALTER TABLE cms_servicesitem ADD COLUMN seckillEndTime DATETIME DEFAULT NULL COMMENT '秒杀结束时间';


/*cms_servicesitem*/
ALTER TABLE cms_servicesitem DROP  COLUMN operator_info;
ALTER TABLE cms_servicesitem ADD COLUMN opOnlyCode VARCHAR(50) DEFAULT NULL COMMENT '操作人唯一编码';

/*h_business_chance*/
ALTER TABLE h_business_chance DROP  COLUMN app_code;
ALTER TABLE h_business_chance ADD COLUMN serviceItem_code VARCHAR(50) DEFAULT NULL COMMENT '项目编码';
ALTER TABLE h_business_chance ADD COLUMN serviceItem_name VARCHAR(255) DEFAULT NULL COMMENT '项目名称';
ALTER TABLE h_business_chance ADD COLUMN channelCode VARCHAR(20) DEFAULT NULL COMMENT '渠道编码';
ALTER TABLE h_business_chance ADD COLUMN servicesReducedRate decimal(12,2) DEFAULT '0.00' COMMENT '服务项的折扣率';
ALTER TABLE h_business_chance ADD COLUMN orderNum VARCHAR(20) DEFAULT NULL COMMENT '自己订单号，目前与订单表无关';
ALTER TABLE h_business_chance ADD COLUMN channelUserName VARCHAR(50) DEFAULT NULL COMMENT '渠道用户名';
ALTER TABLE h_business_chance ADD COLUMN channelOrderNum VARCHAR(50) DEFAULT NULL COMMENT '渠道方订单号';
ALTER TABLE h_business_chance ADD COLUMN totalSum decimal(12,2) DEFAULT '0.00' COMMENT '总额';
ALTER TABLE h_business_chance ADD COLUMN platformProfitRatio decimal(12,2) DEFAULT '0.00' COMMENT '平台与渠道的服务费分成比率（如：总额100，字段值30，则平台的利润为30=100*(30/100)，剩下的则为渠道利润）';
ALTER TABLE h_business_chance ADD COLUMN channelProfit decimal(12,2) DEFAULT '0.00' COMMENT '渠道服务费利润';
ALTER TABLE h_business_chance ADD COLUMN platformProfit  decimal(12,2) DEFAULT '0.00' COMMENT '平台服务费利润';

/*h_business_chance*/
ALTER TABLE h_business_chance ADD COLUMN isAllocation ENUM('0','1') DEFAULT '0';/*是否已分配:0否、1是*/
ALTER TABLE h_business_chance ADD COLUMN isAllocationName VARCHAR(20) DEFAULT NULL COMMENT '是否分配名称';
ALTER TABLE h_business_chance ADD COLUMN allocationTime DATETIME DEFAULT NULL COMMENT '分配时间';

/*cms_servicesitem*/
ALTER TABLE cms_servicesitem ADD COLUMN nclOneCodes VARCHAR(20) DEFAULT NULL COMMENT '商标大类';
ALTER TABLE cms_servicesitem ADD COLUMN authorName VARCHAR(20) DEFAULT NULL COMMENT '商标发布者';
ALTER TABLE cms_servicesitem ADD COLUMN authorMobile VARCHAR(20) DEFAULT NULL COMMENT '商标发布者电话';
ALTER TABLE cms_servicesitem ADD COLUMN priceRange VARCHAR(50) DEFAULT NULL COMMENT '商标价格区间';
ALTER TABLE cms_servicesitem ADD COLUMN tmExpirationDate DATETIME DEFAULT NULL COMMENT '商标到期时间';
ALTER TABLE cms_servicesitem ADD COLUMN applyName VARCHAR(500) DEFAULT NULL COMMENT '商标申请人';
ALTER TABLE cms_servicesitem ADD COLUMN authorOnlyCode VARCHAR(50) DEFAULT NULL COMMENT '商标发布者唯一码';
ALTER TABLE cms_servicesitem ADD COLUMN sellStatus ENUM('forSale','soldOut') DEFAULT 'forSale';/*销售状态:forSale:待售,soldOut:已售*/
ALTER TABLE cms_servicesitem ADD COLUMN sellStatusName VARCHAR(20) DEFAULT NULL COMMENT '销售状态名称';


/*p_shop*/
ALTER TABLE p_shop ADD COLUMN presentationUrl VARCHAR(255) DEFAULT NULL COMMENT '介绍url';


ALTER TABLE cms_servicesitem DROP  COLUMN priceRange;
ALTER TABLE cms_servicesitem DROP  COLUMN sellStatus;
ALTER TABLE cms_servicesitem ADD COLUMN priceRangeMin DOUBLE DEFAULT null COMMENT '价格区间最小值';
ALTER TABLE cms_servicesitem ADD COLUMN priceRangeMax DOUBLE DEFAULT null COMMENT '价格区间最大值';
ALTER TABLE cms_servicesitem ADD COLUMN sellStatus ENUM('forSale','soldOut') DEFAULT 'forSale';/*销售状态:forSale:待售,soldOut:已售*/

ALTER TABLE cms_servicesitem MODIFY sellStatus ENUM('1','2') DEFAULT '1';


/*h_channel_tm
ALTER TABLE h_channel_tm DROP  COLUMN app_code;
ALTER TABLE h_channel_tm DROP  COLUMN param1;
ALTER TABLE h_channel_tm ADD COLUMN channelCode VARCHAR(20) DEFAULT NULL COMMENT '渠道编码';*/


ALTER TABLE h_order_info ADD COLUMN opOnlyCode VARCHAR(50) DEFAULT NULL COMMENT '操作人唯一编码';
ALTER TABLE h_order_info ADD COLUMN offlineApprovalNotes VARCHAR(50) DEFAULT NULL COMMENT '线下审核备注';

/*h_business_chance*/
ALTER TABLE h_business_chance DROP  COLUMN platformProfitRatio;

ALTER TABLE h_business_chance MODIFY channelProfitRatio  DECIMAL(12,2) DEFAULT 0 COMMENT '渠道分成比率（如：总额100，字段值30，则渠道的利润为30/100，剩下的则为平台利润）';
ALTER TABLE h_business_chance ADD COLUMN disposeNotes VARCHAR(255) DEFAULT NULL COMMENT '处理的备注';
ALTER TABLE h_business_chance ADD COLUMN profitTypeName VARCHAR(50) DEFAULT '比例分成' COMMENT '渠道利润类型名称';
ALTER TABLE h_business_chance ADD COLUMN profitType ENUM('1','2') DEFAULT '1';

/*p_channel*/
ALTER TABLE p_channel DROP  COLUMN servicesReducedRate;
ALTER TABLE p_channel DROP  COLUMN channelProfitRatio;
ALTER TABLE p_channel MODIFY channelProfitRatio  DECIMAL(12,2) DEFAULT 0 COMMENT '渠道分成比率（如：总额100，字段值30，则渠道的利润为30/100，剩下的则为平台利润）';

ALTER TABLE p_channel ADD COLUMN everySingleProfit  DECIMAL(12,2) DEFAULT 0 COMMENT '渠道每单利润';
ALTER TABLE p_channel ADD COLUMN profitTypeName VARCHAR(50) DEFAULT '比例分成' COMMENT '渠道利润类型名称';
ALTER TABLE p_channel ADD COLUMN profitType ENUM('1','2') DEFAULT '1';
ALTER TABLE p_channel ADD COLUMN totalChannelProfit  DECIMAL(12,2) DEFAULT 0 COMMENT '渠道总利润';
ALTER TABLE p_channel ADD COLUMN totalPlatformProfit  DECIMAL(12,2) DEFAULT 0 COMMENT '平台总利润';

ALTER TABLE h_business_chance DROP  COLUMN servicesReducedRate;



ALTER TABLE cms_servicesitem ADD COLUMN serviceSmallClassTypeName VARCHAR(255) DEFAULT NULL COMMENT '小类类型名称';
ALTER TABLE cms_servicesitem ADD COLUMN serviceSmallClassType ENUM('1','2') DEFAULT '1';
/*以上sql已经执行过-----**************************************************************************************************************************************************************--------*/



ALTER TABLE c_business_allot ADD COLUMN city VARCHAR(50) DEFAULT NULL COMMENT '城市';
ALTER TABLE c_business_allot ADD COLUMN province VARCHAR(50) DEFAULT NULL COMMENT '省份';

ALTER TABLE h_business_chance ADD COLUMN city VARCHAR(50) DEFAULT NULL COMMENT '城市';
ALTER TABLE h_business_chance ADD COLUMN province VARCHAR(50) DEFAULT NULL COMMENT '省份';















