{
    template:'${tmpl}',
    data(){
        return {
          account:"",
          form:{
            moneys:{
              moneyNum:""
            },
          },
          moneysRules: {
            moneyNum: [
              { required: true, message: '请输入提现金额'}
            ],
          },
        }
    },
    mounted:function(){

    },
    created:function(){
      this.$root.postReq("/web/accountCtl/findById",null).then(d=>{
        if(d.status==0){
          this.account=d.data;
        }
      });
    },
    methods:{
     moneysSubmit(){
         var that=this;
         this.$refs.moneys.validate((valid) => {
           if (valid) {
             var obj={moneys:this.form.moneys};
             var that=this;
             const loading = this.$loading({
                      lock: true,
                      text: 'Loading',
                      spinner: 'el-icon-loading',
                      background: 'rgba(0, 0, 0, 0.7)'
                    });
             that.$root.postReq("/web/tradeCtl/withdrawMoney",obj).then(function(d){
               loading.close();
               if(d.code==1){
                 that.$message({
                   showClose: true,
                   type: 'success',
                   duration:6000,
                   message: '提现申请成功，提现金额将在1个工作日内到帐'
                 });
                that.$router.push("/products/profitcenter/16");
               }else{
                 if(d.code==-100||d.code==-110){
                   that.$confirm('提现操作必须成为合伙人,是否立即成为合伙人?', '重要提示', {
                     confirmButtonText: '确定',
                     cancelButtonText: '取消',
                     type: 'warning'
                   }).then(() => {
                      that.$router.push("/products/finishpersoninfo/");
                   }).catch(() => {
                     console.log("已取消");
                   });
                 }else {
                   that.$message({
                     showClose: true,
                     type: 'warning',
                     duration:6000,
                     message: d.msg
                   });
                 }
               }
             }).catch(function(e){
               that.$message.warning(`操作失败，请刷新页面后重新操作`);
             });
           }else {
               that.$message.warning("请输入提现金额");
           }
         }
       );
     },

    },
    vname:"gsb-withdraw"
}
