{
  template: '${tmpl}',
    data: function() {
      var validateＳname = (rule, value, callback) => {
        if (value === '') {
          callback(new Error('请输入软件名称'));
        } else {
          if (value.indexOf('平台') > -1 || value.indexOf('软件') > -1 || value.indexOf('系统') > -1 || value.indexOf('APP') > -1) {
            callback();
          } else {
            callback(new Error('格式错误，必须以软件、平台、系统、APP结尾，如：XX平台'));
          }
        }
      };
      var validateＳersion = (rule, value, callback) => {
        if (value === '') {
          callback(new Error('请输入版本号'));
        } else {
          if ((value.indexOf('v') > -1 || value.indexOf('V') > -1) && value.indexOf('.') > -1) {
            callback();
          } else {
            callback(new Error('格式错误，按照VX.X格式填写'));
          }
        }
      };
      return {
        dialogTableVisible: false,
        step: "1",
        isRead: false,
        steps: [
          { title: "填写基本信息" },
          { title: "填写申请人信息" },
          { title: "确认订单信息" },
          { title: "支付订单" },
        ],
        form: {
          publishedCountryName: "中国",
          publishedCityName: "北京"
        },
        apply: {
          countryName: "中国",
          fileUrl: "",
          idNoUrl:"",
          descUrl:"",
          codeUrl:"",
          enDescUrl:""
        },
        showtypenum: false,
        order: {},
        qrcode: "",
        qrCodeJumpUrl: "",
        pay: {
          offlinePayDocument: "",
          paymentPlatformType: "wx"
        },
        payconfirm: false,
        d: {},
        cr_type: [
          {
            value: '自然人',
            label: '自然人'
          }, {
            value: '企业法人',
            label: '企业法人'
          }, {
            value: '机关法人',
            label: '机关法人'
          }, {
            value: '事业单位法人',
            label: '事业单位法人'
          }, {
            value: '社会团体法人',
            label: '社会团体法人'
          }, {
            value: '其他组织',
            label: '其他组织'
          }, {
            value: '其他',
            label: '其他'
          },
        ],
        cr_province: [
          {
            value: '北京',
            label: '北京'
          }, {
            value: '上海',
            label: '上海'
          }, {
            value: '天津',
            label: '天津'
          }, {
            value: '内蒙古',
            label: '内蒙古'
          }, {
            value: '山西',
            label: '山西'
          }, {
            value: '河北',
            label: '河北'
          }, {
            value: '辽宁',
            label: '辽宁'
          }, {
            value: '吉林',
            label: '吉林'
          }, {
            value: '黑龙江',
            label: '黑龙江'
          }, {
            value: '江苏',
            label: '江苏'
          }, {
            value: '安徽',
            label: '安徽'
          }, {
            value: '山东',
            label: '山东'
          }, {
            value: '浙江',
            label: '浙江'
          }, {
            value: '江西',
            label: '江西'
          }, {
            value: '福建',
            label: '福建'
          }, {
            value: '湖南',
            label: '湖南'
          }, {
            value: '湖北',
            label: '湖北'
          }, {
            value: '河南',
            label: '河南'
          }, {
            value: '广东',
            label: '广东'
          }, {
            value: '海南',
            label: '海南'
          }, {
            value: '广西',
            label: '广西'
          }, {
            value: '贵州',
            label: '贵州'
          }, {
            value: '四川',
            label: '四川'
          }, {
            value: '云南',
            label: '云南'
          }, {
            value: '陕西',
            label: '陕西'
          }, {
            value: '甘肃',
            label: '甘肃'
          }, {
            value: '宁夏',
            label: '宁夏'
          }, {
            value: '青海',
            label: '青海'
          }, {
            value: '新疆',
            label: '新疆'
          }, {
            value: '西藏',
            label: '西藏'
          }, {
            value: '重庆',
            label: '重庆'
          }, {
            value: '香港',
            label: '香港'
          }, {
            value: '澳门',
            label: '澳门'
          }, {
            value: '台湾',
            label: '台湾'
          }
        ],
        cr_certificateType: [
          {
            value: '居民身份证',
            label: '居民身份证'
          }, {
            value: '军官证',
            label: '军官证'
          }, {
            value: '营业执照',
            label: '营业执照'
          }, {
            value: '护照',
            label: '护照'
          }, {
            value: '企业法人营业执照',
            label: '企业法人营业执照'
          }, {
            value: '组织机构代码证书',
            label: '组织机构代码证书'
          }, {
            value: '事业单位法人证书',
            label: '事业单位法人证书'
          }, {
            value: '社团法人证书',
            label: '社团法人证书'
          }, {
            value: '其他有效证件',
            label: '其他有效证件'
          }
        ],
        cr_garden: [
          {
            value: '清华软件园',
            label: '清华软件园'
          }, {
            value: '上海浦东软件园',
            label: '上海浦东软件园'
          }, {
            value: '杭州软件园',
            label: '杭州软件园'
          }, {
            value: '江苏软件园',
            label: '江苏软件园'
          }, {
            value: '东大软件园',
            label: '东大软件园'
          }, {
            value: '齐鲁软件园',
            label: '齐鲁软件园'
          }, {
            value: '西部软件园',
            label: '西部软件园'
          }, {
            value: '长沙软件园',
            label: '长沙软件园'
          }, {
            value: '北京软件产业基地',
            label: '北京软件产业基地'
          }, {
            value: '天津华苑软件园',
            label: '天津华苑软件园'
          }, {
            value: '湖北软件产业基地',
            label: '湖北软件产业基地'
          }, {
            value: '杭州高新软件园',
            label: '杭州高新软件园'
          }, {
            value: '福州软件园',
            label: '福州软件园'
          }, {
            value: '江西金庐软件园',
            label: '江西金庐软件园'
          }, {
            value: '西安软件园',
            label: '西安软件园'
          }, {
            value: '大连软件园',
            label: '大连软件园'
          }, {
            value: '广州软件园',
            label: '广州软件园'
          }, {
            value: '上海软件园',
            label: '上海软件园'
          }, {
            value: '南京软件园',
            label: '南京软件园'
          }, {
            value: '长春软件园',
            label: '长春软件园'
          }, {
            value: '厦门软件园',
            label: '厦门软件园'
          }, {
            value: '合肥软件园',
            label: '合肥软件园'
          }, {
            value: '云南软件园',
            label: '云南软件园'
          }, {
            value: '深圳软件园',
            label: '深圳软件园'
          }, {
            value: '兰州软件园',
            label: '兰州软件园'
          }, {
            value: '青岛软件园',
            label: '青岛软件园'
          }, {
            value: '吉林软件园',
            label: '吉林软件园'
          }, {
            value: '中部软件产业园',
            label: '中部软件产业园'
          }, {
            value: '无锡软件园',
            label: '无锡软件园'
          }, {
            value: '苏州软件园',
            label: '苏州软件园'
          }, {
            value: '常州软件园',
            label: '常州软件园'
          }, {
            value: '宁波国际软件园',
            label: '宁波国际软件园'
          }, {
            value: '河北省软件产业基地（石家庄）',
            label: '河北省软件产业基地（石家庄）'
          }, {
            value: '其他园区',
            label: '其他园区'
          }
        ],
        cr_entType: [{
          value: '国有企业',
          label: '国有企业'
        }, {
          value: '集体企业',
          label: '集体企业'
        }, {
          value: '私营企业',
          label: '私营企业'
        }, {
          value: '港澳台商投资企业',
          label: '港澳台商投资企业'
        }, {
          value: '外商投资企业',
          label: '外商投资企业'
        }, {
          value: '股份有限公司',
          label: '股份有限公司'
        }
        ],
        tradeKey: "",
        interval: null,
        action: "",
        typenum1: "10000",
        typenum2: "0000",
        descTypeName: "原创",
        isPublish: "已发表",
        devWay: "1",
        getWay: "1",
        rangeType: "1",
        devDate: "",
        publishedDate: "",
        rules: {
          softwareName: [
            { required: true, message: '请输入软件名称' },
            { min:3,max: 200, message: '请规范输入', trigger: 'blur' },
            { validator: validateＳname, trigger: 'blur' }
          ],
          softwareShortName: [
            { max: 100, message: '长度超出', trigger: 'blur' }
          ],
          softwareVersion: [
            { required: true, message: '请输入版本号' },
            { max: 40, message: '长度超出', trigger: 'blur' },
            { validator: validateＳersion, trigger: 'blur' }
          ],
          devDate: [
            { required: true, message: '请选择开发日期' }
          ],
          publishedDate: [
            { required: true, message: '请选择首次发表日期' }
          ],
          publishedCountryName: [
            { required: true, message: '请选择首次发表国家' },
            { max: 40, message: '长度超出', trigger: 'blur' }
          ],
          publishedCityName: [
            { required: true, message: '请选择首次发表城市' },
            { max: 40, message: '长度超出', trigger: 'blur' }
          ],
        },
        rules2: {
          type: [
            { required: true, message: '请输入类别' }
          ],
          name: [
            { required: true, message: '请输入名称' }
          ],
          countryName: [
            { required: true, message: '请输入国籍' }
          ],
          applyProvince: [
            { required: true, message: '请输入省份' }
          ],
          applyCity: [
            { required: true, message: '请输入城市' },
            { max: 40, message: '格式错误', trigger: 'blur' }
          ],
          certificateType: [
            { required: true, message: '请输入证件类型' }
          ],
          certificateCode: [
            { required: true, message: '请输入证件号码' },
            { min: 15, max: 40, message: '格式错误', trigger: 'blur'}
          ],
          garden: [
            { required: true, message: '请输入园区' }
          ],
          entType: [
            { required: true, message: '请输入企业类别' }
          ],
          customerContact: [
            { required: true, message: '请输入联系人' },
            { max: 40, message: '长度超出', trigger: 'blur' }
          ],
          mobile: [
            { required: true, message: '请输入联系电话' },
            { max: 40, message: '长度超出', trigger: 'blur' }
          ],
          fileUrl: [
            { required: true, message: '请上传信息补充文档' }
          ],
          idNoUrl: [
            { required: true, message: '请上传证件' }
          ],
        },
        tradeKey: "",
        interval: null,
      }
    },
  mounted: function() {
    var that = this;
    this.$root.postReq("/web/uploadCtl/getOssConfig", "").then(function (d) {
      that.d["key"] = "key";
      that.d["Bucket"] = d.Bucket;
      that.d["OSSAccessKeyId"] = d.OSSAccessKeyId;
      that.d["Signature"] = d.Signature;
      that.d["policy"] = d.policy;
      that.d["success_action_status"] = d.success_action_status;
      that.action = d.url;
    });
  },
  created: function() {
  },
  methods: {
    downloadTemplate: function() {
      window.open("https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_17921552289738683201911153538683.docx");
    },
    downloadTemplate2: function() {
      window.open("https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_47821552717044445201916141724445.docx");
    },
    downloadTemplate3: function() {
      window.open("https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_49321552717195272201916141955272.docx");
    },
    downloadTemplate4: function() {
      window.open("https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_43521552717243762201916142043762.docx");
    },
    chooseTypeNum: function() {
      this.showtypenum = true;
    },
    closetn: function() {
      this.showtypenum = false;
    },
    submittn: function() {
      this.showtypenum = false;
      this.form.typeNum = this.typenum1 + "-" + this.typenum2;
    },
    tobefore(){
      this.step = Number(this.step) - 1;
      this.step = this.step.toString();
    },
    setKey(name, flag){
      console.log(name);
      console.log(flag);
      name = name.substring(name.length - 5);
      var myDate = new Date();
      var key = "zc_" + Math.round(Math.random() * 500) + myDate.getMonth() + myDate.getTime() + myDate.getFullYear() + myDate.getDate() + myDate.getHours() + myDate.getMinutes() + myDate.getSeconds() + myDate.getMilliseconds() + name.replace(" ", "");
      console.log(this.$refs[flag]);
      this.$refs[flag].d.key = key;
    },
    uploadsuccess(obj){
      console.log("this.form.fileUrl");
      console.log(obj.result);
      var typenrl=obj.flag;
      if(typenrl=='file_upload'){
        this.apply.fileUrl = obj.result;
      }
      if(typenrl=='desc_upload'){
        this.apply.descUrl = obj.result;
      }
      if(typenrl=='code_upload'){
        this.apply.codeUrl = obj.result;
      }
      if(typenrl=='endesc_upload'){
        this.apply.enDescUrl = obj.result;
      }
      if(typenrl=='idno_upload'){
        this.apply.idNoUrl = obj.result;
      }
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    uploadsuccess2(result, obj){
      console.log(result);
      console.log(12345678765432);
      console.log(obj);
      if (obj.flag == "zfpz") {
        this.pay.offlinePayDocument = result;
      }
    },
    submitForm(formName) {
      var that = this;
      if (formName == "form" || formName == "apply") {
        this.$refs[formName].validate((valid) => {
          if (valid) {
            var date1 = new Date(that.form.devDate);
            var date2 = new Date(that.form.publishedDate);
            that.devDate = date1.toLocaleString().split(" ")[0];
            that.publishedDate = date2.toLocaleString().split(" ")[0];
            that.step = Number(that.step) + 1;
          } else {
            console.log('error submit!!');
            return false;
          }
        });
      }
      if (formName == "order") {
        var channelCode = this.$store.state.channelCode;
        var itemCode = this.$store.state.itemCode;
        if (!channelCode || !itemCode) {
          return
        }
        var obj = { tm: { totalSum: "600", invoiceTaxes: "42", remark: that.form.remark, reqtype: "1" }, copyright: this.form, apply: this.apply, channelCode: channelCode, itemCode: itemCode };
        that.$root.getReq("/web/orderCtl/createOrder", obj).then(function (d) {
          if (d.code == "1") {
            that.order = d.order;
            that.qrCodeJumpUrl = window.location.href.split("#")[0] + "mobile#/?from=order&code=" + that.order.orderNum;
            that.qrcode = "http://bigdata.gongsibao.com/api/qc?detailLink=" + encodeURIComponent(that.qrCodeJumpUrl);
            that.step = Number(that.step) + 1;
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.$root.hideMask();
        });
      }
    },
    wxPay: function() {
      if (this.pay.paymentPlatformType == "offline") {
        this.payconfirm = true;
        return;
      }
      var amount = Number(this.order.totalSum);
      if (this.order.totalSum) {
        this.payconfirm = true;
        if (!this.order.orderNum) {
          return;
        }
        this.$root.postReq("/web/tradeCtl/createUnifiedOrder2", { amount: 0.01, desc: "订单支付", orderNum: this.order.orderNum }).then(d => {
          console.log("createUnifiedOrder");
          console.log(d);
          if (d.data) {
            var o = { id: this.order.id, payQr: d.data.qrurl, payQrCreateTime: new Date().getTime(), payOrderNum: d.data.tradekey };
            this.$root.getReq("/web/orderCtl/orderUpdate", o).then(dd => {
              console.log("dd");
              console.log(dd);
              if (dd.code == '1') {
                this.qrcode = d.data.qrurl;
                this.tradekey = d.data.tradekey + "_" + new Date().getTime();
                this.checkPayState();
              }
            });

          } else {
            this.$message.warning(`获取微信支付码失败`);
          }
        });
      }

    },
    closePayConfirm(){
      this.payconfirm = false;
      this.showtypenum = false;
      var self = this;
      if (this.tradekey) {
        var ts = this.tradekey.split("_");
        var tradeKey = ts[0];
        self.tradeKey = "";
        window.clearInterval(self.interval);
      }
    },
    checkPayState(){
      console.log("==================================================");
      var self = this;
      var userinfo = this.$store.state.currentUser;
      if (this.tradekey != "") {
        var ts = this.tradekey.split("_");
        var tradeKey = ts[0];
        var startTime = Number(ts[1]);
        setTimeout(function () {
          var inth = setInterval(function () {

            if (self.tradekey == "") {
              console.log("结束");
              window.clearInterval(inth);
              return;
            }
            console.log(self.order.orderNum);
            self.$root.getReq("/web/orderCtl/findOneByOrderNum", { orderNum: self.order.orderNum }).then(d => {
              console.log("findOneByOrderNum");
              console.log(d);
              if (d && d.orderStatus == "4") {
                self.order = d;
                self.payOrderNum = "";
                self.tradekey = "";
                window.clearInterval(inth);
                self.$router.push("/autosubmitorder");
                return;
              } else {
                var passTime = (new Date().getTime() - startTime) / 1000;
                var p = Math.round((passTime / 300) * 100);
                console.log("passed seconds " + passTime);
                if (passTime > 300) {
                  self.payOrderNum = "";
                  clearInterval(inth);
                  self.$root.postReq("/web/tradeCtl/closeOrder", { idkey: tradeKey }).then(d => {
                    self.wxPay();
                  });
                }
              }
            });
          }, 10000);
          self.interval = inth;
        }, 5000)
      }
    },
    orderUpdate(){
      if (!this.order.id) {
        return
      }
      var self = this;
      var obj = this.pay;
      console.log("this.order");
      console.log(this.order.id);
      obj["id"] = this.order.id;
      obj["orderStatus"] = "64";
      console.log(obj);
      this.$root.getReq("/web/orderCtl/orderUpdate", obj).then(d => {
        console.log("d");
        console.log(d);
        self.$router.push("/autosubmitorder");
      });
    }
  },
  computed: {
    headStyle: function() {
      return { "background-color": "white" };
    }
  },
  vname: "gsb-softwarecrsubmit"
}
