{
  template: '${tmpl}',
  data: function () {
    var that = this;
    var validateMethod = function (rule, value, callback) {
      if (rule.field == "personsSign") {
        if (/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value) == false) {
          return callback(new Error("请输入正确格式的身份证号"));
        } else {
          return callback();
        }
      }
      if (rule.field == "mobile") {
        if (/^1[23456789]\d{9}$/.test(value) == false) {
          return callback(new Error("请输入正确格式的手机号"));
        } else {
          return callback();
        }
      }
      if (rule.field == "vcode") {
        if (that.rcode != value) {
          return callback(new Error("输入验证码有误，请重新输入."));
        }
      }

      if (rule.field == "bankno") {
        if (!value) {
          return callback(new Error("请输入银行卡号"));
        }

        if (value.length >= 30) {
          return callback(new Error("银行卡号位数错误"));
        }

        var num = /^\d*$/;
        if (!num.exec(value)) {
          return callback(new Error("银行卡号只能填写数字"));
        }
      }
      return callback();
    };
    return {
      rcode: "",
      btnloading: false,
      userMobile: "nomobilessssss",
      personinfo: {
        ecompany_id: "",
        ecompany_name: "",
        userName: "",
        bankno: "",
        personsSign: "",
        mobile: "",
        vcode: "",
        accountid: "",
      },
      currentAccountId: "",
      accountList: [],
      rs: {
        ecompany_name: [{
          required: true,
          message: '请输入正确服务单位名称',
          trigger: 'blur'
        }],
        userName: [{
          required: true,
          message: '请输入姓名',
          trigger: 'blur'
        }],
        personsSign: [

          {
            required: true,
            message: '请输入身份证号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
        mobile: [{
            required: true,
            message: '请输入手机号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
        bankno: [{
            required: true,
            message: '请输入银行卡号',
            trigger: 'blur'
          },
          {
            validator: validateMethod,
            trigger: 'blur'
          },
        ],
      }
    };
  },
  mounted: function () {
    var self = this;
    /*检查当前用户的身份证信息是否添加，如果已经添加，那么直接跳转到待签合同页*/
    var ecompany_id = localStorage.getItem("ecompany_id");
    if (ecompany_id && ecompany_id != "null" && ecompany_id != "undefined") {
      this.personinfo.ecompany_id = ecompany_id;
      this.$root.postReq("/web/ecompanyCtl/findOne", {
        id: ecompany_id
      }).then(function (d) {
        if (d.status == 0) {
          self.personinfo.ecompany_name = d.data.name;
        }
      });
    }
  },
  created: function () {
    /* this.getAccountList();
    this.getUserInfo(); */
  },
  methods: {
    getAccountList() {
      var self = this;
      this.$root.postReq("/web/userCtl/accountList", {}).then(function (d) {
        if (d.status == 0) {
          if (d.data) {
            for (var item of d.data) {
              item.label = item.userName + "-" + item.personsSign;
            }
          }
          self.accountList = d.data;
          console.log(d.data);
        }
      });
    },
    changeAccount(value) {
      console.log(this.accountList[Number(value) - 1]);
      var account = this.accountList[Number(value) - 1];

      this.personinfo.personsSign = account.personsSign;
      this.personinfo.mobile = account.mobile;
      this.personinfo.userName = account.userName;
      this.personinfo.userMobile = account.mobile;
    },
    getUserInfo() {
      var self = this;
      this.$root.postReq("/web/userCtl/loginUser", {}).then(function (d) {
        if (d.status == 0) {
          /* self.personinfo.userName = d.data.userName;*/
          self.personinfo.personsSign = d.data.personsSign;
          self.personinfo.mobile = d.data.mobile;
          self.personinfo.userMobile = d.data.mobile || "nomobilessssss";
          console.log(d.data);
        }
      });
    },
    fetchVcode() {
      var that = this;
      if (/^1[23456789]\d{9}$/.test(this.personinfo.mobile) == false) {
        this.$alert('请输入正确格式的手机号码', '提示', {
          confirmButtonText: '确定',
          callback: action => {}
        });
        return;
      }
      this.btnloading = true;
      /*ajax 调用获取手机验证码,并存储到*/
      this.$root.postReq("/web/userCtl/fetchVcode", {
        mobile: this.personinfo.mobile
      }).then(function (d) {
        if (d.status == 0) {
          that.rcode = d.data.vcodestr;
          setTimeout(() => {
            that.btnloading = false;
          }, 3000);
        }
      });
    },
    nextgo() {
      var that = this;
      this.$root.postReq("/web/ecompanyCtl/findOne", {
        name: that.personinfo.ecompany_name
      }).then(function (d) {
        if (d.status == 0) {
          that.personinfo.ecompany_id = d.data.id;
          localStorage.setItem('ecompany_id', d.data.id);
        } else {
          that.personinfo.ecompany_name = "";
          that.personinfo.ecompany_id = "";
        }

        that.$refs.pform.validate(valid => {
          if (valid) {
            /*保存者, 调用生成账户接口,生成签名账户,存储accontid到referrerOnlyCode*/
            that.$root.postReq("/web/userCtl/updateSigner", that.personinfo).then(d => {
              if (d.status == 0) {
                localStorage.setItem('ecompany_id', that.personinfo.ecompany_id);
                localStorage.setItem('eaccount_id', d.data.id);
                that.$router.push("/ecompany/waitsign");
              } else {
                that.$alert(d.msg || '签约人信息保存失败', '提示', {
                  confirmButtonText: '确定',
                  callback: action => {}
                });
              }
            });
          }
        });
      });
    },
    findCompany() {
      var self = this;
      var ecompany_name = this.personinfo.ecompany_name || "";
      if (ecompany_name) {
        this.$root.postReq("/web/ecompanyCtl/findOne", {
          name: ecompany_name
        }).then(function (d) {
          if (d.status == 0) {
            self.personinfo.ecompany_id = d.data.id;
            localStorage.setItem('ecompany_id', d.data.id);
          } else {
            self.personinfo.ecompany_name = "";
            self.personinfo.ecompany_id = "";

            self.$refs.pform.validate(valid => {});
          }
        });
      }
    }
  },
  vname: "gsb-signinfo"
}