{
    template:'${tmpl}',
    data:function(){
        return {
          action:"",
          d:{},
          result:"",
          disabled:"true",
          dialogImageUrl: '',
          dialogVisible: false,
          base64:"",
          text:{},
          filename:"",
          picToTextUrl:"",
          picToTextKeycode:"",
          step:"1",
          convertState:false,
          steps:[
            {title:"上传身份证图片"},
            {title:"开始转换"},
            {title:"操作结束"},
          ],
       }
    },
    methods:{
      onExceed(files, fileList){
        this.$message.warning(`只能上传1个文件`);
      },
      beforeUpload(file){
        if(file.type!="image/jpeg" && file.type!="image/jpg" && file.type!="image/png"){
          this.$message.warning(`图片格式错误，请重新上传`);
          return false;
        }
        var myDate = new Date();
        var key = "zc_idcard"+myDate.getFullYear()+myDate.getMonth()+myDate.getDate()+myDate.getTime()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+".jpg";
        this.d.key=key;
        this.filename=file.name;
      },
      success(response, file, fileList){
        var xml= this.loadXML(response);
        this.result=xml.documentElement.getElementsByTagName("Location")[0].textContent;
        this.disabled=false;
        this.getBase64(file.url);
        this.step="2";
      },
      remove(file, fileList){
        this.step="1";
        this.convertState=false;
        this.disabled=true;
      },
      error(err, file, fileList){
        console.log(err);
      },
      progress(event, file, fileList){
        console.log("progress");
      },
      preview(file){

      },
      loadXML(xmlString){
        var xmlDoc=null;
        if(!window.DOMParser && window.ActiveXObject){
            var xmlDomVersions = ['MSXML.2.DOMDocument.6.0','MSXML.2.DOMDocument.3.0','Microsoft.XMLDOM'];
            for(var i=0;i<xmlDomVersions.length;i++){
                try{
                    xmlDoc = new ActiveXObject(xmlDomVersions[i]);
                    xmlDoc.async = false;
                    xmlDoc.loadXML(xmlString);
                    break;
                }catch(e){
                }
            }
        }
        else if(window.DOMParser && document.implementation && document.implementation.createDocument){
            try{
                domParser = new  DOMParser();
                xmlDoc = domParser.parseFromString(xmlString, 'text/xml');
            }catch(e){
            }
        }
        else{
            return null;
        }
        return xmlDoc;
      },
      handleRemove(file, fileList) {
          this.disabled=true;
      },
      handlePictureCardPreview(file) {
          this.dialogImageUrl = file.url;
          this.dialogVisible = true;
          this.disabled=false;
      },
      picToText(){
          this.$root.showMask();
          var that=this;
          var productId=this.$router.currentRoute.params.id;
          this.$confirm('此操作将消费宝币, 是否继续?', '提示', {
           confirmButtonText: '确定',
           cancelButtonText: '取消',
           type: 'warning'
         }).then(()=>{
           this.$root.getReq("/web/userCtl/checkAccountBalance",{"productId":productId}).then(function(d){
             if(d){
                 this.axios({
                   method:'post',
                   url:that.picToTextUrl,
                   data:{
                     "image":that.base64,
                     "configure": "{\"side\":\"face\"}"
                   },
                   headers:{
                     "Authorization":"APPCODE "+that.picToTextKeycode
                   }
                 }).then(function (d) {
                   if(d.status==200){
                     var dd=d.data;
                     that.$root.postReq("/web/attachmentCtl/create",{"productId":productId,"key":that.d.key,"originUrl":that.result,"name":that.filename}).then(function(d){
                       if(d!=null && d.id!=null && d.id!=""){
                         that.text=dd;
                         that.$root.hideMask();
                         that.step="3";
                         that.convertState=true;
                         that.$store.state.currentUser["accountBalance"]=d.accountBalance;
                         that.$message({
                              type: 'success',
                              message: '本次操作消费了'+d.price+'宝币'
                            });
                       }else{
                         that.$message.warning(`文字转换失败，请重新上传图片`);
                       }

                     });

                   }else{
                     that.$root.hideMask();
                     that.$message.warning(`文字转换失败，请重新上传图片`);
                   }
                 }).catch(function (err) {
                   console.log('请求失败',err);
                   that.$root.hideMask();
                   that.$message.warning(`文字转换失败，请重新上传图片`);
                 });
             }else{
               that.$root.hideMask();
               that.$message.warning(`宝币余额不足，请及时充值`);
               return false;
             }
           });
         });
      },
      getBase64(imgUrl){
        var that=this;
            window.URL = window.URL || window.webkitURL;
            var xhr = new XMLHttpRequest();
            xhr.open("get", imgUrl, true);
            xhr.responseType = "blob";
            xhr.onload = function () {
                if (this.status == 200) {
                    var blob = this.response;
                    var oFileReader = new FileReader();
                    oFileReader.onloadend = function (e) {
                        var base64 = e.target.result;
                        that.base64=base64.split(";base64,")[1].toString();
                    };
                    oFileReader.readAsDataURL(blob);
                }
            };
            xhr.send();
        },
    },
    mounted:function(){
        var that=this;
        this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.d["key"]="key";
            that.d["Bucket"]=d.Bucket;
            that.d["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.d["Signature"]=d.Signature;
            that.d["policy"]=d.policy;
            that.d["success_action_status"]=d.success_action_status;
            that.action=d.url;
        });
        this.$root.postReq("/web/picToTextCtl/getConfig",{"transformType":2}).then(function(d){
            that.picToTextUrl=d.url;
            that.picToTextKeycode=d.keycode;
        });
    },
    vname:"gsb-yyzz"
}
