{
    template:'${tmpl}',
    data:function(){
        return {
          action:"",
          d:{},
          pdfUrl:"",
          filename:"",
          disabled:true,
          downdisabled:true,
          accept:".pdf",
          docUrl:"",
          step:"1",
          steps:[
            {title:"上传pdf文件"},
            {title:"pdf转word"},
            {title:"文件下载"}
          ],
       }
    },
    methods:{
      onExceed(files, fileList){
        this.$message.warning(`只能上传1个文件`);
      },
      beforeUpload(file){
        if(file.type!="application/pdf"){
          this.$message.warning(`请上传pdf文件`);
          return false;
        }
        if(file.size>3145728){
          this.$message.warning(`文件不能超过3072kb`);
          return false;
        }
        var myDate = new Date();
        var key = "zc_pdf2word"+Math.round(Math.random()*500)+myDate.getMonth()+myDate.getTime()+myDate.getFullYear()+myDate.getDate()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+".pdf";
        this.d.key=key;
        this.filename=file.name;
      },
      success(response, file, fileList){
        var xml= this.loadXML(response);
        this.pdfUrl=xml.documentElement.getElementsByTagName("Location")[0].textContent;
        this.step=2;
        this.disabled=false;
        this.downdisabled=true;
      },
      remove(file, fileList){
        this.step=1;
        this.disabled=true;
        this.downdisabled=true;
      },
      error(err, file, fileList){
        console.log("error");
        console.log(err);
      },
      progress(event, file, fileList){
        console.log("progress");
      },
      preview(file){
        if(this.pdfUrl!="" && this.pdfUrl!=undefined){
          window.open(file.url,"_blank");
        }
      },
      loadXML(xmlString){
        var xmlDoc=null;
        if(!window.DOMParser && window.ActiveXObject){
            var xmlDomVersions = ['MSXML.2.DOMDocument.6.0','MSXML.2.DOMDocument.3.0','Microsoft.XMLDOM'];
            for(var i=0;i<xmlDomVersions.length;i++){
                try{
                    xmlDoc = new ActiveXObject(xmlDomVersions[i]);
                    xmlDoc.async = false;
                    xmlDoc.loadXML(xmlString);
                    break;
                }catch(e){
                }
            }
        }
        else if(window.DOMParser && document.implementation && document.implementation.createDocument){
            try{
                domParser = new  DOMParser();
                xmlDoc = domParser.parseFromString(xmlString, 'text/xml');
            }catch(e){
            }
        }
        else{
            return null;
        }
        return xmlDoc;
      },
      downfile(){
         window.open(this.docUrl,"_blank");
      },
      clearUploadedImage () {
        this.$refs.pdfupload.clearFiles();
      },
      pdf2word(){
        var len=this.$refs.pdfupload.$data.uploadFiles.length;
        if(len<1){
          this.$message.warning(`文件转换前请上传文件`);
          return false;
        }
        var that=this;
        this.$confirm('此操作将消费宝币, 是否继续?', '提示', {
         confirmButtonText: '确定',
         cancelButtonText: '取消',
         type: 'warning'
       }).then(()=>{
         that.$root.showMask();
         var productId=that.$router.currentRoute.params.id;
         this.$root.getReq("/web/userCtl/checkAccountBalance",{"productId":productId}).then(function(d){
             if(d){
               var msg={
                 cls:"pdf2wordCtl",
                 method:"pdf2word",
                 data:{"key":that.d.key}
               };
               that.socketClient.socketReplyReq(msg,d=>{
                 if(d!=null){
                   var docurl=d;
                   that.$root.postReq("/web/pdf2wordCtl/createAttachment",{"key":that.d.key,"productId":productId,"pdfUrl":that.pdfUrl,"filename":that.filename,"docUrl":docurl}).then(function(d){
                     if(d!=null && d.id!=null && d.id!=""){

                       that.$store.state.currentUser["accountBalance"]=d.accountBalance;
                       that.docUrl=docurl;
                       that.step=3;
                       that.$message({
                            type: 'success',
                            message: '操作成功，本次操作消费了'+d.price+'宝币'
                          });
                       that.clearUploadedImage();
                       that.disabled=true;
                       that.downdisabled=false;
                     }else{
                         that.$message.warning(`操作失败，请重新操作1`);
                         that.disabled=false;
                         that.downdisabled=true;
                     }

                   })

                 }else{
                   that.$message.warning(`操作失败，请重新操作2`);
                   that.disabled=false;
                   that.downdisabled=true;
                 }
                 that.$root.hideMask();
               });

             }else{
               that.$root.hideMask();
               that.$message.warning(`宝币余额不足，请及时充值`);
               that.disabled=false;
               that.downdisabled=true;
               that.$root.$refs.payselect.show();
               return false;
             }
          });


       });


      }
    },
    mounted:function(){
        var that=this;
        this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.d["key"]="key";
            that.d["Bucket"]=d.Bucket;
            that.d["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.d["Signature"]=d.Signature;
            that.d["policy"]=d.policy;
            that.d["success_action_status"]=d.success_action_status;
            that.action=d.url;
            console.log("!!!!!!!!!!!!!!!1");
            console.log(that.d);
        });
    },
    vname:"gsb-pdfonline"
}
