{
    template:'${tmpl}',
    data(){
      var creditCode =(rule, value, callback) => {
        if(this.form.applier.type=="ent"&& !this.form.applier.creditCode){
          callback(new Error('请输入信用代码'));
        }else{
          callback();
        }
      };
      var validateIdCard = (rule, value, callback) => {
            if (this.form.applier.type=="person") {
              if(value==""){
                callback(new Error('请输入身份证号码'));
              }else{
                var x= /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value);
                if(!x){
                  callback(new Error('身份证格式错误'));
                }else{
                    callback();
                }
              }
            } else {
                callback();
            }
         };
         var validateSFZ = (rule, value, callback) => {
          if (this.form.applier.type=="person" && value=="") {
            callback(new Error('身份证明不能为空'));
          } else {
            callback();
          }
        };
      var validateAddr = (rule, value, callback) => {
          var x = /(([省])|([中][国])|([中][华][人][民][共][和][国])|([北][京][市])|([上][海][市])|([天][津][市])|([重][庆][市])|([内][蒙][古])|([广][西])|([宁][夏])|([新][疆])|([西][藏])|([内][蒙][古][自][治][区])|([新][疆][维][吾][尔][自][治][区])|([广][西][壮][族][自][治][区])|([宁][夏][回][族][自][治][区])|([西][藏][自][治][区]))/g.test(value);
          if (!x) {
            callback(new Error('请检查申请人地址，必须出现省市县（区）三级！'));
    			}else {
           callback();
         }
       };
      return {
           putOrderStatusDialogFormVisible:false,
           op_approval_row_data:null,
           approval_status:false,
           approval_notes: "",
           putstatus:"",
           selectIds:[],
           approvalDialogFormVisible:false,
           calcList:[],
           dialogTableVisible: false,
           title:"订单列表",
           activeNames: [0],
           d:{},
           action:"",
           step:"1",
           bizcode:"",
           steps:[
             {title:"填写基本信息"},
             {title:"确认商标信息"},
             {title:"提交材料"}
           ],
           form:{
             applier:{
               type:"",
               applyName:"",
               creditCode:"",
               applyAddr:"",
               identityCard:"",
               businessLicensePic:"",
               identityCardPic:"",
               priority_to_prove:"",
             },
             customer:{
               customerContact:"",
               mobile:"",
               email:"",
               zipCode:"",
               fax:"",
             },
             order:{
               fromCalc:true,
               orderNum:"",
               applyName:"",
               totalSum:"",
               orderStatusName:"",
               orderStatus:"",
               itemName:"",
             },
             tminfo:[],
           },
           applierRules: {
             type: [
               {type:'string', required: true, message: '请选择申请类型', trigger: 'change' },
             ],
             applyName: [
               { required: true, message: '请输入公司/申请人名称'}
             ],
             creditCode: [
               {required: true, message: '请输入信用代码'},
               { validator: creditCode, trigger: 'blur' }
             ],
             applyAddr: [
               {required: true, message: '请输入申请地址'},
               {validator: validateAddr, trigger: 'blur' }
             ],
             identityCard:[
               {required: true, message: '请输入身份证号码'},
               { validator: validateIdCard, trigger: 'blur' }
             ],
             businessLicensePic: [
               {required: true, message: '营业执照不能为空' }
             ],
             identityCardPic: [ { validator: validateSFZ, trigger: 'blur' }],
           },
           customerRules: {
             customerContact: [
               {required: true, message: '请输入联系人名称' }
             ],
             mobile: [
               {required: true, message: '请输入联系电话'},
             ],
             zipCode:[
               {required: true, message: '请输入邮政编码'},
             ],
           },
      }
    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    created:function(){
      console.log(this.codePath);
      if(this.codePath.indexOf("allorder")>=0){
        this.bizCode="allorder";
      }else{
        this.bizCode="order";
      }
    },
    mounted:function(){
        var that=this;
        this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.d["key"]="key";
            that.d["Bucket"]=d.Bucket;
            that.d["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.d["Signature"]=d.Signature;
            that.d["policy"]=d.policy;
            that.d["success_action_status"]=d.success_action_status;
            that.action=d.url;
        })
    },
    methods:{
      changeStatus(ids,status){
        var that=this;
        if(!status){
          this.$message.warning(`请选择订单状态`);
          return;
        }
        this.$root.postReq("/web/orderCtl/changeStatus",{ids:ids,status:status}).then(function(d){
          console.log(d);
          if(d.code=="1"){
            that.$message({
              type: 'success',
              message: '修改成功!'
            });
            that.putOrderStatusDialogFormVisible = false;
            that.$refs.grid.fetchData();
          }else if(d.code==-101){
            that.$message.warning(d.mag);
          }else{
            that.$message.warning(`操作失败，请刷新页面后重新操作`);
          }
        }).catch(function(e){
          that.$message.warning(`操作失败，请刷新页面后重新操作`);
        });
      },
      approvalSubmit:function(){
        if(this.op_approval_row_data==null){
          this.$message.warning( '数据有误' );
          return false;
        }
        if(this.op_approval_row_data.orderStatus!="64"){
          this.$message.warning( '订单状态是审核中，才能进行付款审核' );
          return false;
        }
        if(this.approval_notes.trim()==""){
          this.$message.warning( '请输入审核意见!' );
          return false;
        }else{
          var that=this;
          var approvalStatus=that.approval_status==true?1:0;
          var reqData={order_num:that.op_approval_row_data.orderNum,approval_status:approvalStatus,approval_notes:that.approval_notes};
          that.approvalDialogFormVisible=false;
          that.$root.showMask();
          that.$root.postReq("/web/orderCtl/orderApproval",reqData).then(function(d){
               that.$root.hideMask();
               if(d.code == 1 )
               {
                 that.$refs.grid.fetchData();
                 that.$message.success( '线下订单付款审核操作成功' );
               }
               else {
                 that.$message.warning(d.message);
               }
             });
        }
      },
      setKey(name,flag){
        console.log(name);
        console.log(flag);
        name=name.substring(name.length-5);
        var myDate = new Date();
        var key = "zc_"+Math.round(Math.random()*500)+myDate.getMonth()+myDate.getTime()+myDate.getFullYear()+myDate.getDate()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+name.replace(" ","");
        console.log(this.$refs[flag]);
        this.$refs[flag].d.key = key;
      },
      setKey2(name,flag){
        console.log(name);
        console.log(flag);
        name=name.substring(name.length-5);
        var myDate = new Date();
        var key = "zc_"+Math.round(Math.random()*500)+myDate.getMonth()+myDate.getTime()+myDate.getFullYear()+myDate.getDate()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+name.replace(" ","");
        console.log(this.$refs[flag]);
        this.$refs[flag][0].d.key = key;
      },
      calctoolbarclick(selectedRows,key){
        if(key=="createorder"){
          var that=this;
          var calcCodes="";
          var calcCodes2=[];
          if(selectedRows==null || selectedRows.length<1){
            this.$message.warning(`请选择记录`);
            return false;
          }else{
            var applier=selectedRows[0].applyName;
            for(var i=0;i<selectedRows.length;i++){
              if(applier!=selectedRows[i].applyName){
                that.$message.warning(`生成订单失败，所选提报单商标申请人不一致`);
                return false;
              }
              calcCodes2.push(selectedRows[i].code);
              if(i==(selectedRows.length-1)){
                calcCodes=calcCodes+selectedRows[i].code;
              }else{
                calcCodes=calcCodes+selectedRows[i].code+",";
              }
            }
            this.$root.getReq("/web/calculatepriceCtl/findByCodes",{"codes":calcCodes2}).then(function(d){

              for(var i=0;i<d.data.count;i++){

                if(d.data.rows[i].status!="1"){
                  that.$message.warning(`该商标档案已生成订单，不能再次生成`);
                  return;
                }
              }
              that.dialogTableVisible=false;
              that.$router.push("/products/calculatepricedetail/"+calcCodes);
            }).catch(function(){
              that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });

            return;
          }

        }
        console.log(this.calcList);
      },
      getqr(orderNo){
          var qrCodeJumpUrl=window.location.href.split("#")[0]+"mobile#/?from=order&code="+orderNo;
          var qrcode="http://bigdata.gongsibao.com/api/qc?detailLink="+encodeURIComponent(qrCodeJumpUrl);
          return qrcode;
      },
      gotmlist:function(){
        this.$router.push("/products/trademark/13");
      },
      applierChange(){
        this.$root.getReq("/web/calculatepriceCtl/getEntregistryByCompanyName",{companyName:this.form.applier.applyName}).then(d=>{
          if(d.creditCode && d.creditCode!=""){
            this.form.applier.applyAddr=d.businessAddress;
            this.form.applier.creditCode=d.creditCode;
          }
        });
      },
      error(err){
        this.$message.warning(`上传失败，请重新上传`);
      },
      success(obj){

      },
      rowClick(row,key,t,e){
        var that=this;
        that.dialogTableVisible =false;
        that.approvalDialogFormVisible = false;
        if(key=="myinvoice"){
          if(row.orderStatusName=="付款成功" || row.orderStatusName=="已提报"){
            this.$router.push("/platform/invoicedetail/"+row.orderNum);
          }else{
            this.$message.warning(`订单未完成，不可申请`);
          }
        }
        if(key=="ordercancel"){
              if(row.orderStatus!="1"){
                this.$message.warning(`只能取消未付款订单`);
                return false;
              }else{
                this.$confirm('订单取消后将不可用, 是否继续?', '提示', {
                   confirmButtonText: '确定',
                   cancelButtonText: '取消',
                   type: 'warning'
                 }).then(()=>{
                   this.$root.getReq("/web/orderCtl/orderCancel",{orderNum:row.orderNum}).then(function(d){

                     if(d.code=="1"){
                       that.$refs.grid.$message({
                         type: 'success',
                         message: '订单已取消'
                       });
                       that.$refs.grid.fetchData();
                     }else{
                       that.$message.warning(`操作失败，请刷新页面后重新操作`);
                     }
                   });
              });
            }
        }
        if(key=="mydelete"){
          if(row.orderStatus!="2"){
            this.$message.warning(`只能删除已取消订单`);
            return false;
          }else{
            this.$refs.grid.rowClick(row,"delete",t,e);
          }
        }
        if(key=="mydetail"){

          if(row.orderStatus=="2"){
            this.$message.warning(`订单已取消`);
            return false;
          }
          this.$root.getReq("/web/calculatepriceCtl/findByOrderNum",{orderNum:row.orderNum}).then(function(d){
            var data=d.data.rows;
            var calcCodes="";
            for(var i=0;i<data.length;i++){
              if(i==(data.length-1)){
                calcCodes=calcCodes+data[i].code;
              }else{
                calcCodes=calcCodes+data[i].code+",";
              }
            }
            that.$router.push("/products/calculatepricedetail/"+calcCodes);
          }).catch(function(){
            that.$message.warning(`操作失败，请刷新页面后重新操作`);
          });
          return;
        }
        if(key=="tmsubmit"){
          this.title="订单提报";
          if(row.orderStatus!="4" && row.orderStatus!="32"){
            that.$message.warning(`操作失败，请检查订单状态`);
            return false;
          }
          this.form={
            applier:{
              type:"",
              applyName:"",
              creditCode:"",
              applyAddr:"",
              identityCard:"",
              businessLicensePic:"",
              identityCardPic:"",
              priority_to_prove:"",
            },
            customer:{
              customerContact:"",
              mobile:"",
              email:"",
              zipCode:"",
              fax:"",
            },
            order:{
              fromCalc:true,
              orderNum:"",
              totalSum:"",
              orderStatusName:"",
              applyName:"",
              orderStatus:"",
              itemName:"",
            },
            tminfo:[],
          };
          this.$root.getReq("/web/orderCtl/getSubmitOrderDetail",{orderNum:row.orderNum}).then(function(d){
            that.form.customer=row.tmcustomerinfo;
            that.form.order=row;
            that.form.order.fromCalc=true;
            var calcs=d.calcs.rows;
            for(var i=0;i<calcs.length;i++){
              calcs[i].nclSmallCodes2=JSON.parse(calcs[i].nclSmallCodes);
            }
            that.form.tminfo=calcs;
            that.form.applier.applyName=calcs[0].applyName;
            that.form.applier.applyAddr=calcs[0].applyAddr;
            that.form.applier.type=calcs[0].type;
            that.form.applier.creditCode=calcs[0].creditCode;
            that.form.applier.identityCard=calcs[0].identityCard;
            var applier=d.applier;

            if(applier.count>0){
              that.form.applier=applier.rows[0];
            }

            that.step="1";
            that.$refs.card.changeButtonState();
            that.$refs.grid.showDlgForm();
          }).catch(function(e){
            that.$message.warning(`操作失败，请刷新页面后重新操作`);
          });
        }
        if(key=="myfile"){
          console.log("----------------myfile----------------------");
          var url=row.offlinePayDocument;
          if(url==null || url==""){
            this.$message.warning(`附件未上传`);
          }else {
            window.open(row.offlinePayDocument);
          }
        }
        if(key=="audit"){
          that.op_approval_row_data=row;
          that.approvalDialogFormVisible = true;
        }
      },
      toolbarclick(key,b,selectedRows){
        this.dialogTableVisible =false;
        this.approvalDialogFormVisible = false;
        this.putOrderStatusDialogFormVisible=false;
        if(key=="myTmList"){
          this.$router.push("/products/trademark/13");
        }
        if(key=="neworder"){
          this.dialogTableVisible = true;
        }
        if(key=="editStatus"){
          this.selectIds=[];
          this.putstatus="";
          if(!selectedRows || selectedRows.length<1){
            this.$message.warning(`请选择至少一行记录`);
            return false;
          }else{
            var ids = [];
            for(var i=0;i<selectedRows.length;i++){
              ids.push(selectedRows[i].id);
              console.log(selectedRows[i],"selectedRows[i]");
              if(selectedRows[i].orderStatus!="4"){
                this.$message.warning(`所选择的数据订单状态必须全部是已经付款的数据，请重新选择`);
                return false
              }
            }
            this.selectIds=ids;
            this.putOrderStatusDialogFormVisible=true;
          }
        }
      },
      onDlgFormClick(type,b){
        if(type=="mysave"){

        }
        this.title="订单列表";
      },
      onColFormater(row,column,cellvalue,index){
        if(column.property=="status"){
          if(row["status"]==1){
            return "未创建订单";
          }else{
            return "已创建订单";
          }
        }
        if(column.property=="created_at"){
            console.log("QQWERTYUYTREWQWERTYU");
            var date = new Date(row["created_at"]);
            var time= date.toLocaleString();
            return time;
        }
        return cellvalue;
       },

      tobefore(){
        this.step=Number(this.step)-1;
        this.step=this.step.toString();
      },
      tonext(){
        if(this.step=="1"){
          this.$refs.applier.validate((valid) => {
            if (valid) {
              this.$refs.customer.validate((valid) => {
                if (valid) {
                  this.step=Number(this.step)+1;
                  this.step=this.step.toString();
                }
              });
            }
          });
        }else{
          this.step=Number(this.step)+1;
          this.step=this.step.toString();
        }


      },
      uploadsuccess(obj){
        var that=this;
        if(obj.flag=="yyzz"){
          that.$root.showMask();
          this.$root.getReq("/web/orderCtl/pic2pdf",{"key":obj.key}).then(function(d){

            if(d.status==0){
              that.form.applier.businessLicensePic=d.data.url;
            }else{
              that.form.applier.businessLicensePic="";
              that.$root.hideMask();
              that.$message.warning(`上传失败请重新上传`);
              return false;
            }
            that.$root.hideMask();
          }).catch(function(e){
            that.form.applier.businessLicensePic="";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          })
        }
        if(obj.flag=="sfz"){
          that.$root.showMask();
          this.$root.getReq("/web/orderCtl/pic2pdf",{"key":obj.key}).then(function(d){

            if(d.status==0){
              that.form.applier.identityCardPic=d.data.url;
            }else{
              that.form.applier.identityCardPic="";
              that.$root.hideMask();
              that.$message.warning(`上传失败请重新上传`);
              return false;
            }
            that.$root.hideMask();
          }).catch(function(e){
            that.form.applier.identityCardPic="";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          })
        }
      },
      uploadsuccess2(result,obj){
          var that=this;
          that.$refs[obj.flag][0].result="";
          that.$root.showMask();
          this.$root.getReq("/web/orderCtl/adjustWTSSize",{"key":obj.key}).then(function(d){
            if(d.status==0){
              that.$refs[obj.flag][0].result=d.data.url;
              that.$root.hideMask();
            }else{
              that.$refs[obj.flag][0].result="";
              that.$root.hideMask();
              that.$message.warning(`上传失败请重新上传`);
              return false;
            }

          }).catch(function(){
            that.$refs[obj.flag][0].result="";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          });
      },

      orderSubmit(){
        var productId=this.$router.currentRoute.params.id;
        var params = window.location.href.split("/");
        var productCode = params[params.length-2];
        for(var i=0;i<params.length;i++){
          if(params[i]=="products"){
            productCode=params[i+1];
          }
        }
        console.log(productCode);
        var obj={order:this.form.order,tms:this.form.tminfo,applier:this.form.applier,customer:this.form.customer,productCode:productCode};
        var that=this;
        this.$refs.stuff.validate((valid) => {
          if (valid) {
            for(var i=0;i<that.form.tminfo.length;i++){
              var wts=that.form.tminfo[i].sealAuthorizeStuff;
              if(wts=="" || wts==null || wts==undefined){
                that.$message.warning(`委托书不能为空`);
                return false;
              }
            }
            that.$root.postReq("/web/orderCtl/orderSubmit",obj).then(function(d){
              if(d.code=="1"){
                that.step="1";
                that.$refs.grid.$message({
                  type: 'success',
                  message: '提报成功，请在进度列表查看商标进度!'
                });
                that.$refs.card.changeButtonState();
                that.$refs.grid.hideDlgForm();
                that.title="订单列表";
                that.$root.hideMask();
                that.$refs.grid.fetchData();
              }else{
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
              }
            }).catch(function(e){
              that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
          }
        });
      },
    },

    vname:"gsb-order"
}
