{
    template:'${tmpl}',
    data(){
        return {
          showList:true,
          chancelist:[],
          chanceInfo:{},
          status:{"1":"有效","2":"无效","3":"待审","4":"不定","5":"未知状态"},
          tm_type:{"p":"普通商标","J":"集体商标","Z":"证明商标","T":"特殊商标"},
        }
    },
    mounted:function(){
      var currentUser=this.$store.state.currentUser;
      console.log(currentUser);

      this.$root.getReq("/web/businesschanceCtl/findAllChances",{}).then(d=>{
        if(d){
          this.chancelist=d;
        }
      });
    },
    methods:{
      showDetail(chance){
        this.chanceInfo=chance;
        this.showList=false;
      },
      closeChance(){
        console.log(this.chanceInfo);
        this.$confirm('需求将变更为关闭状态并从列表中删除，是否继续?', '提示', {
         confirmButtonText: '确定',
         cancelButtonText: '取消',
         type: 'warning'
       }).then(()=>{
         this.$root.showMask();
         this.chanceInfo.chanceStatus="8";
         this.chanceInfo.deleted_at=new Date();
         this.$root.postReq("/web/businesschanceCtl/update",this.chanceInfo).then(d=>{
           if(d.status==0){
             this.$root.getReq("/web/businesschanceCtl/findAllChances",{}).then(d=>{
               if(d){
                 this.chancelist=d;
               }
               this.showList=true;
               this.$root.hideMask();
               this.$message({
                 type: 'success',
                 message: '操作成功！'
               });
             });
           }
         }).catch(e=>{
           this.$root.hideMask();
           this.$message.warning(`操作失败，请刷新页面后重新操作`);
         });
       });

     },
     chanceSubmit(){
       this.$root.showMask();
       this.chanceInfo.chanceStatus="4";
       this.$root.postReq("/web/businesschanceCtl/update",this.chanceInfo).then(d=>{
         if(d.status==0){
           this.$root.getReq("/web/businesschanceCtl/findAllChances",{}).then(d=>{
             if(d){
               this.chancelist=d;
             }
             this.showList=true;
             this.$root.hideMask();
             this.$message({
               type: 'success',
               message: '操作成功！'
             });
           });
         }
       }).catch(e=>{
         this.$root.hideMask();
         this.$message.warning(`操作失败，请刷新页面后重新操作`);
       });
     },
    },

    vname:"gsb-mobilechancelist"
}
