{
    template:'${tmpl}',
    data(){
      var validateEmail=(rule,value,callback)=>{
        if(value==""){
          callback(new Error('请输入邮箱'));
        }else{
          var x=(/^[A-Za-z\d]+([-_.][A-Za-z\d]+)*@([A-Za-z\d]+[-.])+[A-Za-z\d]{2,5}$/.test(value));
          if(!x){
            callback(new Error('邮箱格式有误，请您重新填写'));
          }else{
            callback();
          }
        }
      };
      var validateMobile = (rule, value, callback) =>{
          if(value==""){
            callback(new Error('请输入手机号码'));
          }else{
            var x=(/^1(3|4|5|7|8)\d{9}$/.test(value));
            if(!x){
              callback(new Error('手机号码格式有误，请您重新填写'));
            }else{
              callback();
            }
          }
        };
        return {
           d:{},
           action:"",
           form:{
             invoice:{
               invoiceType:"pt",
               invoiceHeadUpType:"ent",
               invoiceHeadUpType2:"ent",
               invoiceHeadUp:"",
               taxpayerID:"",
               mobile:"",
               email:"",
               statusName:"",
               electronicInvoiceUrl:"",
               address:"",
               applyAddr:"",
               applytelephone:"",
               bankAddrNum:"",
               content:"服务费"
             },
           },
           invoiceRules: {
             invoiceHeadUp:[
               { required: true, message: '请输入发票抬头'}
             ],
             taxpayerID:[
               { required: true, message: '请输入纳税人识别号'}
             ],
             applyAddr:[
               { required: true, message: '请输入公司注册地址'}
             ],
             applytelephone:[
               { required: true, message: '请输入公司注册电话'}
             ],
             bankAddrNum:[
               { required: true, message: '请输入开户行及账号'}
             ],
             content:[
               { required: true, message: '请输入发票内容'}
             ],
             mobile: [
               { required: true,validator: validateMobile, trigger: 'blur' }
             ],
             email: [
               { required: true,validator: validateEmail, trigger: 'blur' }
             ],
             address: [
               { required: true,message: '请输入收件地址'}
             ],
           },
        }
    },
    mounted:function(){
      var that=this;
      var url = location.href;
      var orderNum= url.substring(url.indexOf("=")+1,url.indexOf("&"));
      var obj={invoiceInfo:this.form.invoice,orderNum:orderNum};
      this.$root.postReq("/web/invoiceCtl/getInfoByOrderNum",obj).then(function(getData){
        console.log("---------------------------------------------zhangjiao");
        console.log(getData);
        if(getData!=null){
          if(getData.invoiceType!=null && getData.invoiceType!=""){
            that.form.invoice.invoiceType=getData.invoiceType;
            if(getData.invoiceType!="zs"){
              that.form.invoice.invoiceHeadUpType=getData.invoiceHeadUpType;
            }else{
              that.form.invoice.invoiceHeadUpType2=getData.invoiceHeadUpType;
            }
          }
          that.form.invoice.invoiceHeadUp=getData.invoiceHeadUp;
          that.form.invoice.taxpayerID=getData.taxpayerID;
          that.form.invoice.mobile=getData.mobile;
          that.form.invoice.email=getData.email;
          that.form.invoice.statusName=getData.statusName;
          that.form.invoice.electronicInvoiceUrl=getData.electronicInvoiceUrl;
          that.form.invoice.address=getData.address;
          that.form.invoice.applyAddr=getData.applyAddr;
          that.form.invoice.applytelephone=getData.applytelephone;
          that.form.invoice.bankAddrNum=getData.bankAddrNum;
          that.form.invoice.content=getData.content;
          that.form.invoice.totalSum=getData.totalSum;
        }
      }).catch(function(e){
        that.$message.warning(`操作失败，请刷新页面后重新操作!`);
      });
    },
    methods:{
      invoiceSubmit(){
        console.log("--------------------invoiceSubmit");
          this.$refs.invoice.validate((valid)=>{
          if (valid) {
            var that=this;
            var url = location.href;
            console.log(url);
            var key=url.substr(url.lastIndexOf("=")+1,url.length);
            console.log(key);
            var orderNum= url.substring(url.indexOf("=")+1,url.indexOf("&"));
            console.log(orderNum);
            var obj={invoiceInfo:this.form.invoice,orderNum:orderNum};
            this.$root.postReq("/web/invoiceCtl/addInvoiceInfo",obj).then(function(d){
              if(d.code==1){
                if(key=="myedit"){
                  window.history.go(-1);
                }else{
                  window.history.go(-2);
                }
              }else{
                that.$message.warning(d.msg);
              }
            }).catch(function(e){
              that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
          }else {
              this.$message.warning("请完善填写的数据再进行申请");
          }
        });
      },

      electronicInvoiceUrlshow(){
            window.open(this.form.invoice.electronicInvoiceUrl);
      },

      showInvoiceHeadUp(){
        var that=this;
        var url = location.href;
        var orderNum= url.substring(url.indexOf("=")+1,url.indexOf("&"));
        var obj={invoiceInfo:this.form.invoice,orderNum:orderNum};
        this.$root.postReq("/web/invoiceCtl/showInvoiceHeadUp",obj).then(function(getData){
          if(getData!=null){
            that.form.invoice.invoiceHeadUp=getData.invoiceHeadUp;
          }
        }).catch(function(e){
          that.$message.warning(`操作失败，请刷新页面后重新操作!`);
        });
      },
      skipNext(){
        this.$router.push("/workbench");
      },
    },

    vname:"gsb-invoicedetail"
}
