{
    template:'${tmpl}',
    data:function(){
      return {
        dialogFormVisible: false,
        action:"",
        imagedata:{},
        imageUrl:"",
        filename:"",
        disabled:true,
        downdisabled:true,
        accept:"image/jpeg,image/png",
        multipleSelection: [],
        tableData: [],
        logo:"",
        a:true,
        b:false,
        c:false,
        d:false,
        e:false,
        activeName: 'first',
        activeNames: ['1'],
        tmdata:{},
        imagecount:"0",
        imageupurl:"",
        tmRegistNums:[],
        queryimagedata:[],
        tmRegistNumsAll:[
        ],
        tag: { name: '', type: '' },
        sqlbdata:[
        ],
        sqlbtab:"",
        sqlbtabkey:"",
        sqlbtabkeycount:""
      };
    },

    methods:{
      onExceed(files, fileList){
        this.$message.warning(`只能选择一张图片`);
      },
      beforeUpload(file){
        if(file.type!="image/jpeg" && file.type!="image/png"){
          this.$message.warning(`请上传jpg文件`);
          return false;
        }
        if(file.size>3145728){
          this.$message.warning(`文件不能超过3072kb`);
          return false;
        }
        var myDate = new Date();
        var key = "zc_imagequery"+Math.round(Math.random()*500)+myDate.getMonth()+myDate.getTime()+myDate.getFullYear()+myDate.getDate()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+file.name;
        this.imagedata.key=key;
        this.tag.name=file.name;
      },
      success(response, file, fileList){
        var xml= this.loadXML(response);
        this.imageUrl=xml.documentElement.getElementsByTagName("Location")[0].textContent;
        this.disabled=false;
        this.downdisabled=true;
      },
      remove(file, fileList){
        this.disabled=true;
        this.downdisabled=true;
      },
      error(err, file, fileList){
        console.log("error");
        console.log(err);
      },
      progress(event, file, fileList){
        console.log("progress");
      },
      preview(file){
        if(this.imageUrl!="" && this.imageUrl!=undefined){
          window.open(file.url,"_blank");
        }
      },
      loadXML(xmlString){
        var xmlDoc=null;
        if(!window.DOMParser && window.ActiveXObject){
            var xmlDomVersions = ['MSXML.2.DOMDocument.6.0','MSXML.2.DOMDocument.3.0','Microsoft.XMLDOM'];
            for(var i=0;i<xmlDomVersions.length;i++){
                try{
                    xmlDoc = new ActiveXObject(xmlDomVersions[i]);
                    xmlDoc.async = false;
                    xmlDoc.loadXML(xmlString);
                    break;
                }catch(e){
                }
            }
        }
        else if(window.DOMParser && document.implementation && document.implementation.createDocument){
            try{
                domParser = new  DOMParser();
                xmlDoc = domParser.parseFromString(xmlString, 'text/xml');
            }catch(e){
            }
        }
        else{
            return null;
        }
        return xmlDoc;
      },
      closeTag(tag){
        this.imageUrl="";
        this.clearUploadedImage();
      },

      clearUploadedImage () {
        this.$refs.imageupload.clearFiles();
      },
      buildRegNums(ps,cp){
        var start=Number((cp-1)*ps);
        var end=Number(start+ps);
        var len=this.tmRegistNums.length;
        if(end>(len+1)){
          end=this.tmRegistNums.length+1;
        }
        var regNums=this.tmRegistNums.slice(start,end);
        return regNums;
      },
      pageChanged(ps,cp){
        if(this.sqlbtabkey==""||this.sqlbtabkey==null){
          this.$refs.flowlayout.$refs.pagerRef.pageInfo.total=this.imagecount;
        }else{
          this.$refs.flowlayout.$refs.pagerRef.pageInfo.total=this.sqlbtabkeycount;
        }

        this.$refs.flowlayout.$refs.pagerRef.pageInfo.currentPage=cp;
        this.$refs.flowlayout.$refs.pagerRef.pageInfo.pageSize=ps;
        var obj={
            tmRegistNumsAll: this.tmRegistNumsAll,
            sqlbtabkey:this.sqlbtabkey,
            pageInfo:{
              pageSize:ps,
              pageNo:cp
          }
        };
        var that=this;
        console.log(obj);
        this.$root.showMask();
        this.$root.postReq("/web/tmqueryCtl/findImageSearch",obj).then(function(d){
            that.queryimagedata=d.data.rows;
            that.logo=d.data.rows.logo;
            that.$root.hideMask();
        }).catch(function(e){
          console.log(e);
          that.$message.warning(`操作失败，请刷新页面后重新操作`);
          that.$root.hideMask();
        });

      },
      imagequery(){
        if(this.imageUrl=="" || this.imageUrl==null){
          this.$message.warning(`操作失败，请选择图片后重新操作`);
          return false;
        }
        this.imageupurl=this.imageUrl;
        var msg={
          cls:"tmqueryCtl",
          method:"imagequery",
          data:{"imageUrl":this.imageUrl}
        };
        var that=this;
        this.tmRegistNums=[];
        this.$root.showMask();
        this.sqlbtab="";
        this.sqlbtabkey="";
        this.sqlbtabkeycount="";

        this.socketClient.socketReplyReq(msg,d=>{
          console.log(d);
          if(d.status==0 && d.data.count>0){
            that.tmRegistNumsAll=d.data.rows;
            that.sqlbdata = d.data.code_counts;
            that.imagecount = d.data.count;
            that.pageChanged(18,1);
          }else{
            that.$root.hideMask();
          }
        });
        this.c=true;
        this.d=true;
        this.e=true;
        this.a=false;
        this.b=true;
      },
      getTmFlowInfo(row){
        var that=this;
        this.$root.postReq("/web/tmqueryCtl/getTmFlowByRegNum",{"regNum":row.sbzch}).then(function(d){
          if(d!=null){
            that.tmdata["lcxx"]=d;
          }
        });
      },
      onColFormater(row,column,cellvalue,index){
        if(column.property=="created_at"){
           return new Date(cellvalue).toLocaleString();
        }
        if(column.property=="sex"){
          if(cellvalue=='male'){
            return "男";
          }
           if(cellvalue=='female'){
              return "女";
          }
        }else{
            return cellvalue;
        }
      },
      detailclick:function(row,key){
        var that=this;
        var options={
          regNum:row.sbzch
        };
        console.log(options);
        var productId=this.$router.currentRoute.params.id;
        console.log(productId);
        that.$root.postReq("/web/tmqueryCtl/getTmFlowByRegNum",options).then(function(d){
            row.lcxx=d;
            that.$root.postReq("/web/tmqueryCtl/createTrade",{"productId":productId}).then(function(d){
              if(d!=null && d.id!=null && d.id!=""){
                     that.tmdata=row;
                     that.getTmFlowInfo(row);
                     that.tmdata.sblx=row.sblx;
                     that.tmdata.sbzt=row.sbzt;
                     that.dialogFormVisible=true;
               }else{
                 console.log(e);
                 that.$message.warning(`操作失败，请刷新页面后重新操作`);
               }
             }).catch(function(e){
                console.log(e);
               that.$message.warning(`操作失败，请刷新页面后重新操作`);
             });
           }).catch(function(e){
             console.log(e);
             that.$message.warning(`操作失败，请刷新页面后重新操作`);
           });
      },
      sqlbclick(val){
        this.sqlbtab=val.keyvalue;
        this.sqlbtabkey=val.key;
        this.sqlbtabkeycount=val.keycount;
        this.imagecount=val.keycount;
        this.pageChanged(18,1);

      },
      sqlbtabClose(tag) {
        this.sqlbtab="";
        this.sqlbtabkey="";
        this.sqlbtabkeycount="";
        this.imagecount= this.tmRegistNumsAll.length;
        this.pageChanged(18,1);
      },

    },
    mounted:function(){
        var that=this;
        this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.imagedata["key"]="key";
            that.imagedata["Bucket"]=d.Bucket;
            that.imagedata["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.imagedata["Signature"]=d.Signature;
            that.imagedata["policy"]=d.policy;
            that.imagedata["success_action_status"]=d.success_action_status;
            that.action=d.url;
        })
    },
    vname:"gsb-imagequeryengine"
}
