{
    template:'${tmpl}',
    data:function(){
        return {
          action:"",
          imagedata:{},
          imageUrl:"",
          filename:"",
          disabled:true,
          downdisabled:true,
          accept:"image/jpeg,image/png",
          multipleSelection: [],
          tableData: [],
          logo:"",
          tmdata:{},
          tmRegistNums:[],
          tmRegistNumsAll:[],
          tag: { name: '', type: '' },
        }
    },
    created:function(){

    },
    methods:{
      onExceed(files, fileList){
        this.$message.warning(`只能选择一张图片`);
      },
      beforeUpload(file){
        if(file.type!="image/jpeg" && file.type!="image/png"){
          this.$message.warning(`请上传jpg文件`);
          return false;
        }
        if(file.size>3145728){
          this.$message.warning(`文件不能超过3072kb`);
          return false;
        }
        var myDate = new Date();
        var key = "zc_imagequery"+Math.round(Math.random()*500)+myDate.getMonth()+myDate.getTime()+myDate.getFullYear()+myDate.getDate()+myDate.getHours()+myDate.getMinutes()+myDate.getSeconds()+myDate.getMilliseconds()+file.name;
        this.imagedata.key=key;
        this.tag.name=file.name;
      },
      success(response, file, fileList){
        var xml= this.loadXML(response);
        this.imageUrl=xml.documentElement.getElementsByTagName("Location")[0].textContent;
        this.disabled=false;
        this.downdisabled=true;
      },
      remove(file, fileList){
        this.disabled=true;
        this.downdisabled=true;
      },
      error(err, file, fileList){
        console.log("error");
        console.log(err);
      },
      progress(event, file, fileList){
        console.log("progress");
      },
      preview(file){
        if(this.imageUrl!="" && this.imageUrl!=undefined){
          window.open(file.url,"_blank");
        }
      },
      loadXML(xmlString){
        var xmlDoc=null;
        if(!window.DOMParser && window.ActiveXObject){
            var xmlDomVersions = ['MSXML.2.DOMDocument.6.0','MSXML.2.DOMDocument.3.0','Microsoft.XMLDOM'];
            for(var i=0;i<xmlDomVersions.length;i++){
                try{
                    xmlDoc = new ActiveXObject(xmlDomVersions[i]);
                    xmlDoc.async = false;
                    xmlDoc.loadXML(xmlString);
                    break;
                }catch(e){
                }
            }
        }
        else if(window.DOMParser && document.implementation && document.implementation.createDocument){
            try{
                domParser = new  DOMParser();
                xmlDoc = domParser.parseFromString(xmlString, 'text/xml');
            }catch(e){
            }
        }
        else{
            return null;
        }
        return xmlDoc;
      },
      closeTag(tag){
        this.imageUrl="";
        this.clearUploadedImage();
      },

      clearUploadedImage () {
        this.$refs.imageupload.clearFiles();
      },
      buildRegNums(ps,cp){
        var start=Number((cp-1)*ps);
        var end=Number(start+ps);
        var len=this.tmRegistNums.length;
        if(end>(len+1)){
          end=this.tmRegistNums.length+1;
        }
        var regNums=this.tmRegistNums.slice(start,end);
        return regNums;
      },
      pageChanged(ps,cp,searchObj){
        var from = Number((cp-1)*ps);
        var end=Number(from+ps);
        this.tmRegistNums=this.tmRegistNumsAll.slice(from,end);
        this.$refs.grid.$refs.pagerRef.pageInfo.total=this.tmRegistNumsAll.length;
        this.$refs.grid.$refs.pagerRef.pageInfo.currentPage=cp;
        this.$refs.grid.$refs.pagerRef.pageInfo.pageSize=ps;
        var obj={
          registNums: this.tmRegistNums,
          pageInfo:{
            pageSize:ps,
            pageNo:cp
          }
        };
        var that=this;
        this.$root.showMask();
        this.$root.postReq("/web/tmqueryCtl/findAndCountAll2",obj).then(function(d){
            that.$refs.grid.data=d.data.rows;
            that.logo=d.data.rows.logo;
            that.$root.hideMask();
        }).catch(function(e){
          console.log(e);
          that.$message.warning(`操作失败，请刷新页面后重新操作`);
          that.$root.hideMask();
        });

      },
      imagequery(){
        if(this.imageUrl=="" || this.imageUrl==null){
          this.$message.warning(`操作失败，请选择图片后重新操作`);
          return false;
        }
        var msg={
          cls:"tmqueryCtl",
          method:"imagequery",
          data:{"imageUrl":this.imageUrl}
        };
        var that=this;
        this.tmRegistNums=[];
        this.$root.showMask();
        this.socketClient.socketReplyReq(msg,d=>{
          console.log(d);
          if(d.status==0 && d.data.count>0){
            that.tmRegistNumsAll=d.data.rows;
            that.pageChanged(5,1,null);
          }else{
            that.$root.hideMask();
          }
        });
      },
      rowClick(row,key){
        var that=this;
        var options={
          regNum:row.regNum
        };
        this.$confirm('此操作将消费宝币, 是否继续?', '提示', {
         confirmButtonText: '确定',
         cancelButtonText: '取消',
         type: 'warning'
       }).then(()=>{
         var productId=this.$router.currentRoute.params.id;
         this.$root.getReq("/web/userCtl/checkAccountBalance",{"productId":productId}).then(function(d){
             if(d){
               that.$root.postReq("/web/tmqueryCtl/getTmFlowByRegNum",options).then(function(d){
                 var flows=d;
                 row.lcxx=d;
                 that.$root.postReq("/web/tmqueryCtl/createTrade",{"productId":productId}).then(function(d){
                   if(d!=null && d.id!=null && d.id!=""){
                     that.$refs.card.changeButtonState();
                     that.$store.state.currentUser["accountBalance"]=d.accountBalance;
                     that.$refs.grid.showDlgForm();
                     that.tmdata=row;
                     that.getTmFlowInfo(row);
                     that.tmdata.sblx=row.sblx;
                     that.tmdata.sbzt=row.sbzt;

                     that.$message({
                          type: 'success',
                          message: '本次查询消费了'+d.baoAmount+'宝币'
                        });
                   }else{
                     console.log(e);
                     that.$message.warning(`操作失败，请刷新页面后重新操作`);
                   }

                 }).catch(function(e){
                    console.log(e);
                   that.$message.warning(`操作失败，请刷新页面后重新操作`);
                 });

               }).catch(function(e){
                 console.log(e);
                 that.$message.warning(`操作失败，请刷新页面后重新操作`);
               });
             }else{
               that.$message.warning(`宝币余额不足，请及时充值`);
               return false;
             }
         });
       }).catch(()=>{

       });



      },
      getTmFlowInfo(row){
        var that=this;
        this.$root.postReq("/web/tmqueryCtl/getTmFlowByRegNum",{"regNum":row.sbzch}).then(function(d){
          if(d!=null){
            that.tmdata["lcxx"]=d;
          }

        });
      },
      onColFormater(row,column,cellvalue,index){
        if(column.property=="created_at"){
           return new Date(cellvalue).toLocaleString();
        }
        if(column.property=="sex"){
          if(cellvalue=='male'){
            return "男";
          }
           if(cellvalue=='female'){
              return "女";
          }
        }else{
            return cellvalue;
        }
      },
    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    mounted:function(){
        var that=this;
        this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.imagedata["key"]="key";
            that.imagedata["Bucket"]=d.Bucket;
            that.imagedata["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.imagedata["Signature"]=d.Signature;
            that.imagedata["policy"]=d.policy;
            that.imagedata["success_action_status"]=d.success_action_status;
            that.action=d.url;
        })
    },
    vname:"gsb-imagequery"
}
