{
    template:'${tmpl}',
    data(){
      var validateIdCard = (rule, value, callback) => {
          if(value==""){
            callback(new Error('请输入身份证号码'));
          }else{
            var x= /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value);
            if(!x){
              callback(new Error('身份证格式错误'));
            }else{
                callback();
            }
          }
      };
      var validateMobile = (rule, value, callback) =>{
          if(value==""){
            callback(new Error('请输入手机号码'));
          }else{
            var x=(/^1(3|4|5|7|8)\d{9}$/.test(value));
            if(!x){
              callback(new Error('手机号码格式有误，请您重新填写'));
            }else{
              callback();
            }
          }
        };
        return {
           d:{},
           action:"",
           time:"",
           disabled:true,
           prohibit:false,
           a:true,
           b:false,
           c:false,
           e:false,
           form:{
             partner:{
               apply_type:"person",
               tagInfo:['tm'],
               workPic:"",
               mobile:"",
               apply_addr:"",
               applyName:"",
               identityCardPic:"",
               identityCard:"",
               entName:"",
               businessLicensePic:"",
               businessLicenseNum:"",
               cardNo:"",
               realName:""
             },
           },
           partnerRules: {
            mobile: [
               { required: true,validator: validateMobile, trigger: 'blur' }
             ],
             applyName: [
               { required: true, message: '请输入真实姓名'}
             ],
             /*identityCardPic: [
               { required: true, message: '身份证必须上传'}
             ],
             identityCard:[
               { validator: validateIdCard, trigger: 'blur' }
             ],*/
             identityCard: [
               { required: true,validator: validateIdCard, trigger: 'blur' }
             ],
             cardNo: [
               { required: true, message: '请输入银行卡号'}
             ],
             realName: [
               { required: true, message: '请输入开户人姓名'}
             ],
             /*businessLicensePic: [
               { required: true, message: '营业执照必须上传'}
             ],*/
             businessLicenseNum: [
               { required: true, message: '请输入营业执照号'}
             ]
           },

        }
    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    mounted:function(){
        var date=new Date();
        var year= date.getFullYear();
        var month=date.getMonth()+1;
        var day=date.getDate();
        var time=year+"年"+month+"月"+day+"日";
        this.time=time;
        var that=this;

        this.$root.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.d["key"]="key";
            that.d["Bucket"]=d.Bucket;
            that.d["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.d["Signature"]=d.Signature;
            that.d["policy"]=d.policy;
            that.d["success_action_status"]=d.success_action_status;
            that.action=d.url;
        });
        this.$root.postReq("/web/partnerinfoCtl/getPartnerInfo","").then(function(getData){
          if(getData!=null){
            if(getData.identityCard!=""&&getData.cardNo!=""&&getData.realName!=""){
              that.prohibit=true;
            }else{
              that.prohibit =false;
            }
            var tmpTagInfo=getData.tagInfo==null?['ic']:getData.tagInfo.split(',');
            that.form.partner.apply_type=getData.applyType;
            that.form.partner.tagInfo=tmpTagInfo;
            that.form.partner.workPic=getData.workPic;
            that.form.partner.mobile=getData.mobile;
            that.form.partner.apply_addr=getData.applyAddr;
            that.form.partner.applyName=getData.applyName;
            that.form.partner.identityCardPic=getData.identityCardPic;
            that.form.partner.identityCard=getData.identityCard;
            that.form.partner.entName=getData.entName;
            that.form.partner.businessLicensePic=getData.businessLicensePic;
            that.form.partner.businessLicenseNum=getData.businessLicenseNum;
            that.form.partner.cardNo=getData.cardNo;
            that.form.partner.realName=getData.realName;
          }
        }).catch(function(e){
          that.$message.warning(`操作失败，请刷新页面后重新操作!`);
        });
    },
    updated:function(){
      /*$("#apply_type_op input:radio")[0].disabled=true;*/
    },
    methods:{
      homePage(){
        this.$router.push("/workbench");
      },
      toolbox(){
        this.$router.push("/toolbox");
      },
      agree(){
        var obj=document.getElementById("yes");
        if(obj.checked==true){
          this.disabled=false;
        }else{
          this.disabled=true;
        };
      },
      open1(){
        this.a=false;
        this.b=true;
        this.c=true;
        this.e=false;
      },
      open2(){
        this.a=false;
        this.b=false;
        this.c=true;
        this.e=true;
      },
      open3(){
        this.a=true;
        this.b=false;
        this.c=false;
        this.e=false;
      },
      error(err){
        this.$message.warning(`上传失败，请重新上传`);

      },
      success(obj){

      },
      partnerInfoSubmit(){
        this.$refs.partner.validate((valid) => {
          if (valid) {
            var obj={partnerInfo:this.form.partner};
            var that=this;
            const loading = this.$loading({
                     lock: true,
                     text: 'Loading',
                     spinner: 'el-icon-loading',
                     background: 'rgba(0, 0, 0, 0.7)'
                   });
            this.$root.postReq("/web/partnerinfoCtl/addPartnerInfo",obj).then(function(d){
              loading.close();
              if(d.code==1){
                that.$message({
                  showClose: true,
                  type: 'success',
                  duration:3000,
                  message: '操作成功'
                });
                that.$router.push("/workbench");
              }else{
                that.$message.warning(d.msg);
              }
            }).catch(function(e){
              that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
          }else {
              this.$message.warning("请完善填写的数据再进行申请");
          }
        }
      );
      },
      skipNext(){
        this.$router.push("/workbench");
      },
    },

    vname:"gsb-finishpersoninfo"
}
