{
    template:'${tmpl}',
    data:function(){
        return {
          title:"订单生成",
          collapseNames:[0],
          calcCodes:[],
          data:[],
          calcIds:[],
          nclTotalPublicExpense:0,
          nclServiceCharge:0,
          invoiceTaxes:0,
          totalPlatformCost:0,
          showSubmit:true,
          submitDisabled:false,
          order:{},
          applier:{},
          wts:[],
          qrcode:"",
          qrCodeJumpUrl:"",
        }
    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    created:function(){

    },
    mounted:function(){
      var that=this;
      var codes=this.$router.history.current.params.id;
      var calcCodes=codes.split(",");
      this.calcCodes=calcCodes;
      this.$root.getReq("/web/calculatepriceCtl/findByCodes",{"codes":calcCodes}).then(function(d){
        console.log("QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQq");
        console.log(d);
        var calcsIds=[];
        that.order=d.order;
        that.applier=d.applier;
        that.wts=d.wts;
        that.qrCodeJumpUrl=window.location.href.split("#")[0]+"mobile#/?from=order&code="+that.order.orderNum;
        that.qrcode="http://bigdata.gongsibao.com/api/qc?detailLink="+encodeURIComponent(that.qrCodeJumpUrl);
        for(var i=0;i<d.data.count;i++){
          calcsIds.push(d.data.rows[i].id);
          d.data.rows[i].nclSmallCodes2=JSON.parse(d.data.rows[i].nclSmallCodes);
          that.nclTotalPublicExpense=Number(that.nclTotalPublicExpense)+Number(d.data.rows[i].nclTotalPublicExpense);
          that.nclServiceCharge=Number(that.nclServiceCharge)+Number(d.data.rows[i].nclServiceCharge);
          that.invoiceTaxes=Number(that.invoiceTaxes)+Number(d.data.rows[i].invoiceTaxes);
          that.totalPlatformCost=Number(that.totalPlatformCost)+Number(d.data.rows[i].totalPlatformCost);
          if(d.data.rows[i].orderNum!="" && d.data.rows[i].orderNum!=null){
            that.submitDisabled=true;
            that.title="订单详情";
          }
        }
        that.calcIds=calcsIds;
        that.data=d.data.rows;
      });

    },
    methods:{
      cancel(){
        this.$router.go(-1);
      },
      createOrder(){
        var that=this;
        var calcIds=this.calcIds;

        if(calcIds.length<1){
          this.$message.warning(`操作失败，请刷新页面后重新操作`);
          return false;
        }
        this.$root.showMask();
        this.$root.getReq("/web/calculatepriceCtl/createOrder",{"calcIds":calcIds}).then(function(d){

          if(d.code=="1"){
            that.$message({
              type: 'success',
              message: '订单生成成功!'
            });
            that.submitDisabled=true;
            that.title="订单详情";
            that.order=d.order;
            that.qrCodeJumpUrl=window.location.href.split("#")[0]+"mobile#/?from=order&code="+that.order.orderNum;
            console.log(that.qrCodeJumpUrl);
            that.qrcode="http://bigdata.gongsibao.com/api/qc?detailLink="+encodeURIComponent(that.qrCodeJumpUrl);

          }else if (d.code=="-3"){
            that.$message.warning(`操作失败，请刷新页面后重新操作`);
          }else{
            that.$message.warning(d.msg);
          }
          that.$root.hideMask();
        }).catch(function(e){
          that.$root.hideMask();
          that.$message.warning(`操作失败，请刷新页面后重新操作`);
        });
      }

    },

    vname:"gsb-calculatepricedetail"
}
