{
    template:'${tmpl}',
    data:function(){
      var that=this;
      var validateMethod=function(rule, value, callback){
         if(rule.field=="mobile"){
           if(/^1[23456789]\d{9}$/.test(value) == false){
              return  callback(new Error("请输入正确格式的手机号"));
           }else{
              return  callback();
           }
         }
         if(rule.field=="vcode"){
           if(that.rcode!=value){
             return  callback(new Error("输入验证码有误，请重新输入."));
           }
         }
         return callback();
      };
        return {
          id : "",
          rcode:"",
          btnloading:false,
          personinfo:{
            mobile:"",
            vcode:""
          },
          rs:{
            mobile: [
                       {required: true, message: '请输入手机号', trigger: 'blur' },
                       { validator: validateMethod, trigger: 'blur' },
            ],
            vcode: [
                       {required: true, message: '请输入手机接收到的验证码', trigger: 'blur' },
                       { validator: validateMethod, trigger: 'blur' },
            ],
          }
        };
    },
    mounted:function(){
      var r = this.$root || {};
      if(r.currentUser && r.currentUser.mobile){
        this.$router.push({path:"/businesschance/waitdeal",query:{from:"mobile"}});
      }
    },
    created:function(){
      console.log("e contract info ");
    },
    methods:{
      fetchVcode(){
        var that=this;
        if(/^1[23456789]\d{9}$/.test(this.personinfo.mobile) == false){
          this.$alert('请输入正确格式的手机号码', '提示', {
             confirmButtonText: '确定',
             callback: action => {
             }
           });
           return;
        }
        this.btnloading=true;
        /*ajax 调用获取手机验证码,并存储到*/
        this.$root.postReq("/web/userCtl/fetchVcode",{mobile:this.personinfo.mobile}).then(function(d){
          if(d.status==0){
            that.rcode=d.data.vcodestr;
            setTimeout(()=>{
                that.btnloading=false;
            },3000);
          }
        });
      },
      nextgo(){
        var that=this;
        that.$refs.pform.validate(valid=>{
          if(valid){
            /*更新用户mobile，获取userid存放如接单信息表中*/
            that.$root.postReq("/web/userCtl/updateMobile", that.personinfo).then(d=>{
              if(d.status == 0) {
                  that.$router.push("/businesschance/waitdeal");
              }
            });
          }
        });
      },
  },
    vname:"gsb-bundinfo"
}
