{
  template: '${tmpl}',
    data: function() {
      var validateAddr = (rule, value, callback) => {
        var x = /(([省])|([中][国])|([中][华][人][民][共][和][国])|([北][京][市])|([上][海][市])|([天][津][市])|([重][庆][市])|([内][蒙][古])|([广][西])|([宁][夏])|([新][疆])|([西][藏])|([内][蒙][古][自][治][区])|([新][疆][维][吾][尔][自][治][区])|([广][西][壮][族][自][治][区])|([宁][夏][回][族][自][治][区])|([西][藏][自][治][区]))/g.test(value);
        if (!x) {
          callback(new Error('请检查申请人地址，必须出现省市县（区）三级！'));
        } else {
          callback();
        }
      };
      var colorizedtm = (rule, value, callback) => {
        if ((this.form.tmFormType == "7" || this.form.tmFormType == "6") && value == "") {
          callback(new Error('请上传彩色商标图样'));
        } else {
          callback();
        }
      };
      var validateIdCard = (rule, value, callback) => {
        if (this.form.type == "person") {
          if (value == "") {
            callback(new Error('请输入身份证号码'));
          } else {
            var x = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value);
            if (!x) {
              callback(new Error('身份证格式错误'));
            } else {
              callback();
            }
          }
        } else {
          callback();
        }
      };
      var validateSFZ = (rule, value, callback) => {
        if (this.apply.type == "person" && value == "") {
          callback(new Error('身份证明不能为空'));
        } else {
          callback();
        }
      };
      var creditCode = (rule, value, callback) => {
        if (this.apply.type == "ent" && !this.apply.creditCode) {
          callback(new Error('请输入信用代码'));
        } else {
          callback();
        }
      };
      return {
        refbizcode: '',
        bizCode: '',
        filterText: '',
        status: "",
        data2: [{
          id: 1,
          label: '一级 1',
          children: []
        }],
        ncldata: [
          { code: "01", name: "化学原料" }, { code: "02", name: "颜料油漆" }, { code: "03", name: "日化用品" }, { code: "04", name: "燃料油脂" }, { code: "05", name: "医药" },
          { code: "06", name: "金属材料" }, { code: "07", name: "机械设备" }, { code: "08", name: "手工器械" }, { code: "09", name: "科学仪器" }, { code: "10", name: "医疗器械" },
          { code: "11", name: "灯具空调" }, { code: "12", name: "运输工具" }, { code: "13", name: "军火烟火" }, { code: "14", name: "珠宝钟表" }, { code: "15", name: "乐器" },
          { code: "16", name: "办公用品" }, { code: "17", name: "橡胶制品" }, { code: "18", name: "皮革皮具" }, { code: "19", name: "建筑材料" }, { code: "20", name: "家具" },
          { code: "21", name: "厨房洁具" }, { code: "22", name: "绳网袋篷" }, { code: "23", name: "纱线丝" }, { code: "24", name: "布料床单" }, { code: "25", name: "服装鞋帽" },
          { code: "26", name: "纽扣拉链" }, { code: "27", name: "地毯席垫" }, { code: "28", name: "健身器材" }, { code: "29", name: "食品" }, { code: "30", name: "方便食品" },
          { code: "31", name: "饲料种籽" }, { code: "32", name: "啤酒饮料" }, { code: "33", name: "酒" }, { code: "34", name: "烟草烟具" }, { code: "35", name: "广告销售" },
          { code: "36", name: "金融物管" }, { code: "37", name: "建筑修理" }, { code: "38", name: "通讯服务" }, { code: "39", name: "运输贮藏" }, { code: "40", name: "材料加工" },
          { code: "41", name: "教育娱乐" }, { code: "42", name: "网站服务" }, { code: "43", name: "餐饮住宿" }, { code: "44", name: "医疗园艺" }, { code: "45", name: "社会服务" }

        ],
        bigtype: [{
          value: '人工智能', label: '人工智能',
          children: [{ value: '技术研究', label: '技术研究', }, { value: '智能办公', label: '智能办公', }, { value: '智能驾驶', label: '智能驾驶', }, { value: '智能教育', label: '智能教育', }, { value: '智能穿戴', label: '智能穿戴', }]
        },
        {
          value: '文教娱|传媒、教育、文化、娱乐', label: '文教娱|传媒、教育、文化、娱乐',
          children: [{ value: '影视', label: '影视', }, { value: '教育培训', label: '教育培训', }, { value: '文化娱乐', label: '文化娱乐', }, { value: '旅游服务', label: '旅游服务', }]
        },
        {
          value: '服务业|餐饮、修理安装', label: '服务业|餐饮、修理安装',
          children: [{ value: '餐饮', label: '餐饮', }, { value: '修理安装', label: '修理安装', }]
        },
        {
          value: '商业服务|广告、金融、法律财务人力服务', label: '商业服务|广告、金融、法律财务人力服务',
          children: [{ value: '广告、会展', label: '广告、会展', }, { value: '人力资源', label: '人力资源', }, { value: '创业孵化器', label: '创业孵化器', }, { value: '金融财务', label: '金融财务', }, { value: '商业咨询', label: '商业咨询', }, { value: '法律服务', label: '法律服务', }]
        },
        {
          value: '房产建材|建筑工程监理物管', label: '房产建材|建筑工程监理物管',
          children: [{ value: '装饰装潢', label: '装饰装潢', }, { value: '家具家居', label: '家具家居', }, { value: '建材', label: '建材', }, { value: '建筑、监理', label: '建筑、监理', }]
        },
        {
          value: '交通物流|运输、仓储、物流、快递、车辆养护', label: '交通物流|运输、仓储、物流、快递、车辆养护',
          children: [{ value: '物流运输、快递', label: '物流运输、快递', }, { value: '车辆养护、维修', label: '车辆养护、维修', }, { value: '物流仓储', label: '物流仓储', }]
        },
        {
          value: '医药保健化工能源', label: '医药保健化工能源',
          children: [{ value: '化工能源', label: '化工能源', }, { value: '眼镜面罩', label: '眼镜面罩', }, { value: '医疗保健', label: '医疗保健', }, { value: '医疗器械', label: '医疗器械', }, { value: '药品', label: '药品', }, { value: '医疗服务', label: '医疗服务', }]
        },
        {
          value: '食品饮料|生鲜、保健产品、烟酒糖茶', label: '食品饮料|生鲜、保健产品、烟酒糖茶',
          children: [{ value: '烟酒糖茶、饮料', label: '烟酒糖茶、饮料', }, { value: '营养产品', label: '营养产品', }, { value: '生鲜食品、糕点', label: '生鲜食品、糕点', }, { value: '珠宝钟表', label: '珠宝钟表', }, { value: '美容、化妆品', label: '美容、化妆品', }, { value: '服装、配饰', label: '服装、配饰', }]
        },
        {
          value: 'IT、互联网||通信、电子、互联网', label: 'IT、互联网||通信、电子、互联网',
          children: [{ value: '在线服务', label: '在线服务', }, { value: '游戏', label: '游戏', }, { value: '社交、论坛', label: '社交、论坛', }, { value: '电商平台', label: '电商平台', }, { value: '软件开发运营', label: '软件开发运营', }, { value: '家电产品', label: '家电产品', }, { value: '计算机及周边', label: '计算机及周边', }, { value: '通信', label: '通信', }]
        },
        {
          value: '农业|农、林、牧、渔等', label: '农业|农、林、牧、渔等',
          children: [{ value: '化肥、饲料', label: '化肥、饲料', }, { value: '农产品加工', label: '农产品加工', }]
        },
        {
          value: '机械制造|机械车辆五金工具', label: '机械制造|机械车辆五金工具',
          children: [{ value: '五金器械', label: '五金器械', }, { value: '车船航空器制造', label: '车船航空器制造', }, { value: '机械、加工制造', label: '机械、加工制造', }]
        },

        ],
        selectedOptions: [],
        defaultProps: {
          children: 'children',
          label: function (data, node) {
            if (data.code == null || data.code == null) {
              return data.name;
            } else {
              return data.code + " " + data.name;
            }
          }
        },
        form: {
          tmFormType: "3",
          tmName: "",
          picUrl: "",
          colorizedPicUrl: "",
          nclTotalPublicExpense: 0,
          invoiceTaxes: 0,
          totalSum: 0,
          remark: "",
        },

        rules: {
          tmName: [
            { required: true, message: '请输入商标名称' }
          ],
          picUrl: [
            { required: true, message: '请上传商标图样' }
          ],
          colorizedPicUrl: [
            { validator: colorizedtm, trigger: 'blur' }
          ],
          tmFormType: [
            { required: true, message: '请选择商标类型' }
          ],
        },
        nclOne: [],
        d: {},
        action: "",
        invoiceTaxRate: 10,
        step: "1",
        isRead: false,
        steps: [
          { title: "填写基本信息" },
          { title: "填写申请人信息" },
          { title: "确认订单信息" }
        ],
        apply: {
          type: "",
          applyName: "",
          creditCode: "",
          identityCard: "",
          applyAddr: "",
          zipCode: "",
          customerContact: "",
          mobile: "",
          email: "",
          businessLicensePic: "",
          identityCardPic: "",
          sealAuthorizeStuff: "",
          descUrl: "",
        },
        applyrules: {
          type: [
            { type: 'string', required: true, message: '请选择申请类型', trigger: 'change' }
          ],
          applyName: [
            { required: true, message: '请输入公司/申请人名称' }
          ],
          creditCode: [
            { required: true, message: '请输入信用代码' },
            { validator: creditCode, trigger: 'blur' }
          ],
          identityCard: [
            { required: true, message: '请输入身份证号码' },
            { validator: validateIdCard, trigger: 'blur' }
          ],
          zipCode: [
            { required: true, message: '请输入邮政编码' }
          ],
          applyAddr: [
            { required: true, message: '请输入执照详细地址' },
            { validator: validateAddr, trigger: 'blur' }
          ],
          customerContact: [
            { required: true, message: '请输入客户联系人' }
          ],
          mobile: [
            { required: true, message: '请输入联系电话' }
          ],
          email: [
            { required: true, message: '请输入电子邮箱' }
          ],
        },
        order: {},
        qrcode: "",
        qrCodeJumpUrl: "",
        pay: {
          offlinePayDocument: "",
          paymentPlatformType: "wx"
        },
        payconfirm: false,
        tradeKey: "",
        interval: null,
        orderNum: "",
        canedit: true,
      }
    },
  computed: Vuex.mapState({
    count: state => state.count,
    headStyle: function () {
      return { "background-color": "white" };
    }
  }),
    created: function() {

    },
  mounted: function() {
    var that = this;
    var orderNum = this.$store.state.queryParam;
    console.log("orderNumorderNumorderNumorderNum");
    console.log(orderNum);
    this.orderNum = orderNum;
    if (!orderNum) {
      this.$message.warning(`订单参数错误`);
      this.$router.push("/autosubmitorder");
      return;
    }
    var channelCode = this.$store.state.channelCode;
    var itemCode = this.$store.state.itemCode;
    if (!channelCode || !itemCode) {
      this.$message.warning(`参数错误`);
      this.$router.push("/");
      return;
    }

    this.$root.getReq("/web/pconfigCtl/getConfigValue", { configType: "invoiceTaxRate" }).then(function (d) {
      console.log(d);
      if (d != null && d.configValue != null && d.configValue != "") {
        that.invoiceTaxRate = Number(d.configValue);
      }
    });
    this.getOrderDetail();

  },
  methods: {
    createWTS: function() {
      var that = this;
      if (!this.apply.type) {
        that.$message.warning("请选择申请人类型");
        return;
      } else if (!this.apply.applyName) {
        that.$message.warning("请填写公司名称");
        return;
      } else if (this.apply.type == "person" && !this.apply.identityCard) {
        that.$message.warning("请填写身份证号码");
        return;
      } else if (!this.apply.applyAddr) {
        that.$message.warning("请填写执照详细地址");
        return;
      }
      that.$root.showMask();
      var params = this.apply.type + ";" + this.apply.applyName + ";" + this.apply.identityCard + ";" + this.form.tmFormType
        + ";" + this.form.colorizedPicUrl + ";" + this.form.picUrl + ";" + this.apply.applyAddr;
      params = encodeURIComponent(params);
      console.log(params);
      var url = window.location.href.split("/automaticsubmit?")[0] + "/mobile2?" + "params=" + params + "#/createwts2";
      console.log(url);
      this.$root.getReq("/web/calculatepriceCtl/createWTS2", { "url": url }).then(function (d) {

        if (d.data.url != "" && d.data.url != null) {
          window.open(d.data.url);
        } else {
          that.$message.warning(`操作失败`);
        }
        that.$root.hideMask();
      }).catch(function (e) {
        that.$root.hideMask();
        that.$message.warning(`操作失败`);
      });
    },
    getOrderDetail: function() {
      var orderNum = this.orderNum;
      var that = this;
      this.$root.getReq("/web/orderCtl/getOrderDetailByOrderNum", { orderNum: orderNum }).then(function (d) {
        console.log("/web/orderCtl/getOrderDetailByOrderNum");
        console.log(d);
        if (d && d.code == "1") {
          var d_tm = d.data.tms[0];
          var d_order = d.data.order;
          var d_apply = d.data.apply;
          var d_customer = d.data.customer;
          var form = {
            tmFormType: d_tm.tmFormType, tmName: d_tm.tmName, picUrl: d_tm.picUrl,
            nclTotalPublicExpense: d_order.totalPublicExpense, colorizedPicUrl: d_tm.colorizedPicUrl,
            invoiceTaxes: d_order.totalInvoiceTaxes, totalSum: d_order.totalSum, remark: d_order.remark
          };
          var apply = {
            type: d_apply ? d_apply.type : "",
            applyName: d_apply ? d_apply.applyName : "",
            creditCode: d_apply ? d_apply.creditCode : "",
            identityCard: d_apply ? d_apply.identityCard : "",
            applyAddr: d_apply ? d_apply.applyAddr : "",
            zipCode: d_customer ? d_customer.zipCode : "",
            customerContact: d_customer ? d_customer.customerContact : "",
            mobile: d_customer ? d_customer.mobile : "",
            email: d_customer ? d_customer.email : "",
            businessLicensePic: d_apply ? d_apply.businessLicensePic : "",
            identityCardPic: d_apply ? d_apply.identityCardPic : "",
            sealAuthorizeStuff: d_tm.sealAuthorizeStuff,
            descUrl: d_tm.descUrl
          };
          var order = d_order;
          that.form = form;
          that.apply = apply;
          that.order = order;
          var nclOne = [];
          for (var i = 0; i < d.data.tms.length; i++) {
            var t = d.data.tms[i];
            var nclThree = JSON.parse(t.nclSmallCodes);
            var name = that.ncldata[Number(t.nclOneCodes)].name;
            console.log("Number(t.nclOneCodes)");
            console.log(name);
            var o = { code: t.nclOneCodes, name: name, nclThree: nclThree };
            nclOne.push(o);
          }
          that.nclOne = nclOne;
        }
      });
    },
    gotoorder: function() {
      this.$router.push("/products/order/13");
    },
    searchInputBlur(){
      var text = this.filterText;
      if (text == "" || text == null) {
        this.initNclData();
      }
    },
    nclSearch(){
      var that = this;
      var text = this.filterText;
      if (text == "" || text == null) {
        this.initNclData();
      } else {
        this.$root.showMask();
        this.$root.getReq("/web/calculatepriceCtl/getNclByLikeName", { "name": text }).then(function (d) {
          if (d.status == 0) {
            console.log(d);
            that.ncldata = d.data;
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.$root.hideMask();
        });
      }
    },
    initNclData(){
      this.ncldata = [
        { code: "01", name: "化学原料" }, { code: "02", name: "颜料油漆" }, { code: "03", name: "日化用品" }, { code: "04", name: "燃料油脂" }, { code: "05", name: "医药" },
        { code: "06", name: "金属材料" }, { code: "07", name: "机械设备" }, { code: "08", name: "手工器械" }, { code: "09", name: "科学仪器" }, { code: "10", name: "医疗器械" },
        { code: "11", name: "灯具空调" }, { code: "12", name: "运输工具" }, { code: "13", name: "军火烟火" }, { code: "14", name: "珠宝钟表" }, { code: "15", name: "乐器" },
        { code: "16", name: "办公用品" }, { code: "17", name: "橡胶制品" }, { code: "18", name: "皮革皮具" }, { code: "19", name: "建筑材料" }, { code: "20", name: "家具" },
        { code: "21", name: "厨房洁具" }, { code: "22", name: "绳网袋篷" }, { code: "23", name: "纱线丝" }, { code: "24", name: "布料床单" }, { code: "25", name: "服装鞋帽" },
        { code: "26", name: "纽扣拉链" }, { code: "27", name: "地毯席垫" }, { code: "28", name: "健身器材" }, { code: "29", name: "食品" }, { code: "30", name: "方便食品" },
        { code: "31", name: "饲料种籽" }, { code: "32", name: "啤酒饮料" }, { code: "33", name: "酒" }, { code: "34", name: "烟草烟具" }, { code: "35", name: "广告销售" },
        { code: "36", name: "金融物管" }, { code: "37", name: "建筑修理" }, { code: "38", name: "通讯服务" }, { code: "39", name: "运输贮藏" }, { code: "40", name: "材料加工" },
        { code: "41", name: "教育娱乐" }, { code: "42", name: "网站服务" }, { code: "43", name: "餐饮住宿" }, { code: "44", name: "医疗园艺" }, { code: "45", name: "社会服务" }
      ];
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    uploadsuccess2(result, obj){
      console.log(result);
      console.log(12345678765432);
      console.log(obj);
      if (obj.flag == "zfpz") {
        this.pay.offlinePayDocument = result;
      }
    },
    uploadsuccess(obj){

      var that = this;
      if (obj.flag == "picUrl") {
        that.$root.showMask();
        this.$root.getReq("/web/calculatepriceCtl/toblack", { "key": obj.key }).then(function (d) {
          if (d.status == 0) {
            that.form.picUrl = d.data.url;
            that.$root.hideMask();
          } else {
            that.form.picUrl = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          }

        }).catch(function () {
          that.form.picUrl = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        });
      }
      if (obj.flag == "colorizedPicUrl") {
        that.$root.showMask();
        this.$root.getReq("/web/calculatepriceCtl/adjustTMSize", { "key": obj.key }).then(function (d) {

          if (d.status == 0) {
            that.form.colorizedPicUrl = d.data.url;
            that.$root.hideMask();
          } else {
            that.form.colorizedPicUrl = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          }
        }).catch(function () {
          that.form.colorizedPicUrl = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        });

      }
      if (obj.flag == "yyzz") {
        that.$root.showMask();
        this.$root.getReq("/web/orderCtl/pic2pdf", { "key": obj.key }).then(function (d) {

          if (d.status == 0) {
            that.apply.businessLicensePic = d.data.url;
          } else {
            that.apply.businessLicensePic = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.apply.businessLicensePic = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        })
      }
      if (obj.flag == "sfz") {
        that.$root.showMask();
        this.$root.getReq("/web/orderCtl/pic2pdf", { "key": obj.key }).then(function (d) {

          if (d.status == 0) {
            that.apply.identityCardPic = d.data.url;
          } else {
            that.apply.identityCardPic = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.apply.identityCardPic = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        })
      }
      if (obj.flag == "wts") {
        that.$root.showMask();
        this.$root.getReq("/web/orderCtl/adjustWTSSize", { "key": obj.key }).then(function (d) {
          if (d.status == 0) {
            that.apply.sealAuthorizeStuff = d.data.url;
            that.$root.hideMask();
          } else {
            that.$refs[obj.flag][0].result = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          }

        }).catch(function () {
          that.$refs[obj.flag][0].result = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        });
      }
      if (obj.flag == "yxq") {
        that.apply.descUrl = obj.result
      }

    },
    beforeUpload(file){
      var that = this;
      var isSize = false;
      var img = new Image();
      var _URL = window.URL || window.webkitURL;
      img.onload = function () {
        console.log("11");
        if (img.width == img.height) {
          isSize = true;
          that.$refs.ys_upload.ifupload = true;
        } else {
          isSize = false;
          that.$message.warning('上传的图片宽高必须相等');
          that.$refs.ys_upload.$refs.upload.abort(file);
        }
      };
      img.src = window.URL.createObjectURL(file);

    },
    showUrl(url){
      window.open(url);
    },
    closeTag(nclThree, index, index2){
      if (this.form.status == 2) {
        this.$message.warning("已生成订单，不可修改");
        return false;
      }
      this.nclOne[index].nclThree.splice(index2, 1);
      if (this.nclOne[index].nclThree.length > 10) {
        this.nclOne[index].price = Number(300 + (this.nclOne[index].nclThree.length - 10) * 30);
      } else if (this.nclOne[index].nclThree.length > 0 && this.nclOne[index].nclThree.length <= 10) {
        this.nclOne[index].price = 300;
      } else {
        this.nclOne[index].price = 0;
        this.removeNclOne(index);
      }
      this.updatePrice();
      var json = { json: this.nclOne };
      var jsonStr = JSON.stringify(json);
    },
    removeNclOne(index){
      if (this.form.status == 2) {
        this.$message.warning("已生成订单，不可修改");
        return false;
      }
      this.nclOne.splice(index, 1);
      this.updatePrice();
    },
    nodeClick(obj, e, a){
      var that = this;
      if (this.form.status == 2) {
        this.$message.warning("已生成订单，不可修改");
        return false;
      }
      if (e.level < 3 && e.childNodes.length == 0) {
        var o = {
          nclcode: obj.code,
        };
        this.$root.getReq("/web/ncloneCtl/getNcl", o).then(function (d) {
          var data = d.data.rows;
          for (var i = 0; i < data.length; i++) {
            that.appendNode(data[i], e);
          }
        });
      }
      if (e.level == 3) {
        var ppncl = e.parent.parent.data;
        var nclThree = [e.data];

        var result = this.nclOneIsExist(ppncl.code);
        if (result.result) {
          var nclThree = this.nclOne[result.index].nclThree;
          var hasNclThree = this.nclThreeIsExist(e.data.name, nclThree);
          if (!hasNclThree.result) {
            this.nclOne[result.index].nclThree.push(e.data);
            if (this.nclOne[result.index].nclThree.length > 10) {
              this.nclOne[result.index].price = Number(300 + (this.nclOne[result.index].nclThree.length - 10) * 30);
            }

          }
        } else {
          var data = {
            code: ppncl.code,
            name: ppncl.name,
            price: 300,
            nclThree: nclThree,
          };
          this.nclOne.push(data);
        }
        this.updatePrice();
      }
    },
    nclThreeIsExist(name, nclThree){
      if (nclThree.length < 1) {
        return { result: false, index: 0 };
      } else {
        for (var i = 0; i < nclThree.length; i++) {
          if (nclThree[i].name == name) {
            return { result: true, index: i };
          }
        }
        return { result: false, index: 0 };
      }
    },
    nclOneIsExist(nclOneCode){
      if (this.nclOne.length < 1) {
        return { result: false, index: 0 };
      } else {
        for (var i = 0; i < this.nclOne.length; i++) {
          if (this.nclOne[i].code == nclOneCode) {
            return { result: true, index: i };
          }
        }
        return { result: false, index: 0 };
      }
    },
    word2pic(){
      if (this.form.tmName == "" || this.form.tmName == null) {
        this.$root.showMask();
        this.$root.hideMask();
        return false;
      }
      var obj = { word: this.form.tmName };
      var that = this;
      this.$root.showMask();
      this.$root.getReq("/web/calculatepriceCtl/word2pic", obj).then(function (d) {

        if (d.status == 0) {
          that.form.picUrl = d.data.url;
          that.$root.hideMask();
        } else {
          that.form.picUrl = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新生成`);
          return false;
        }

      }).catch(function () {
        that.form.picUrl = "";
        that.$root.hideMask();
        that.$message.warning(`上传失败请重新生成`);
        return false;
      });

    },
    updatePrice(){
      this.form.totalSum = 0;
      this.form.invoiceTaxes = 0;
      this.form.nclTotalPublicExpense = 0;
      for (var i = 0; i < this.nclOne.length; i++) {
        this.form.nclTotalPublicExpense = this.form.nclTotalPublicExpense + this.nclOne[i].price;
      }
      this.form.invoiceTaxes = Number(this.form.nclTotalPublicExpense) * 100 * Number(this.invoiceTaxRate) / 10000;
      this.form.totalSum = Number(this.form.nclTotalPublicExpense) + Number(this.form.invoiceTaxes);
    },
    appendNode(data, pnode) {

      this.$refs.tree.append(data, pnode);
    },
    filterNode(value, data) {
      if (!value) return true;
      return data.label.indexOf(value) !== -1;
    },

    aiadive(){
      if (this.selectedOptions.length == 0) {
        this.$message.warning(`请选择行业`);
        return false;
      }
      this.$root.getReq("/web/calculatepriceCtl/aiadive", { seltype: this.selectedOptions }).then(d => {
        console.log(d.data);
        var ncl = JSON.parse(d.data);
        this.nclOne = ncl.ncl;
        this.updatePrice();
      });
    },
    selfclear(){
      this.nclOne = [];
    },
    submitForm(formName) {
      var that = this;
      if (formName == "form" || formName == "apply") {
        this.$refs[formName].validate((valid) => {
          if (valid) {
            if (formName == "form" && that.nclOne.length < 1) {
              that.$message.warning(`请选择商标分类`);
              return false;
            } else {
              that.step = Number(that.step) + 1;
            }
          } else {
            console.log('error submit!!');
            return false;
          }
        });
      }
      if (formName == "save") {
        this.$root.showMask();
        if (this.order.orderStatus == "2") {
          this.$message.warning("该订单已取消，无法修改");
          this.getOrderDetail();
          that.$root.hideMask();
          return
        }
        var channelCode = this.$store.state.channelCode;
        var itemCode = this.$store.state.itemCode;
        if (!channelCode || !itemCode) {
          that.$root.hideMask();
          return
        }
        console.log(this.form);
        var tm = {
          orderNum: this.order.orderNum, tmFormType: this.form.tmFormType, tmName: this.form.tmName,
          picUrl: this.form.picUrl, sealAuthorizeStuff: this.apply.sealAuthorizeStuff, descUrl: this.apply.descUrl
        };
        var apply = {
          orderNum: this.order.orderNum, type: this.apply.type, applyName: this.apply.applyName, creditCode: this.apply.creditCode,
          identityCard: this.apply.identityCard, applyAddr: this.apply.applyAddr, businessLicensePic: this.apply.businessLicensePic,
          identityCardPic: this.apply.identityCardPic, remark: this.form.remark
        };
        var customer = {
          orderNum: this.order.orderNum, zipCode: this.apply.zipCode, customerContact: this.apply.customerContact, mobile: this.apply.mobile,
          email: this.apply.email
        };
        var obj = { tm: tm, apply: apply, customer: customer };
        console.log(obj);
        that.$root.postReq("/web/orderCtl/updateOrderDetailByOrderNum", obj).then(function (d) {
          console.log("dddddddddddddddddddddddddd");
          console.log(d);
          if (d.code == "1") {
            that.$message.success(`修改成功`);
            that.getOrderDetail();
          } else if (d.code = "-100" && d.msg) {
            console.log(d.msg);
            that.$message.warning(d.msg);
            that.getOrderDetail();
          } else {
            that.$message.warning("操作失败");
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.$root.hideMask();
        });
      }

    },
    applierChange(){
      this.$root.getReq("/web/calculatepriceCtl/getEntregistryByCompanyName", { companyName: this.apply.applyName }).then(d => {
        if (d.creditCode && d.creditCode != "") {
          this.apply.applyAddr = d.businessAddress;
          this.apply.creditCode = d.creditCode;
        }
      });
    },
    setKey(name, flag){
      console.log(name);
      console.log(flag);
      name = name.substring(name.length - 5);
      var myDate = new Date();
      var key = "zc_" + Math.round(Math.random() * 500) + myDate.getMonth() + myDate.getTime() + myDate.getFullYear() + myDate.getDate() + myDate.getHours() + myDate.getMinutes() + myDate.getSeconds() + myDate.getMilliseconds() + name.replace(" ", "");
      console.log(this.$refs[flag]);
      this.$refs[flag].d.key = key;
    },
    tobefore(){
      this.step = Number(this.step) - 1;
      this.step = this.step.toString();
    },
    wxPay: function() {
      if (this.pay.paymentPlatformType == "offline") {
        this.payconfirm = true;
        return;
      }
      var amount = Number(this.order.totalSum);
      if (this.order.totalSum) {
        this.payconfirm = true;
        if (!this.order.orderNum) {
          return;
        }
        this.$root.postReq("/web/tradeCtl/createUnifiedOrder2", { amount: amount, desc: "订单支付", orderNum: this.order.orderNum }).then(d => {
          console.log("createUnifiedOrder");
          console.log(d);
          if (d.data) {
            var o = { id: this.order.id, payQr: d.data.qrurl, payQrCreateTime: new Date().getTime(), payOrderNum: d.data.tradekey };
            this.$root.getReq("/web/orderCtl/orderUpdate", o).then(dd => {
              console.log("dd");
              console.log(dd);
              if (dd.code == '1') {
                this.qrcode = d.data.qrurl;
                this.tradekey = d.data.tradekey + "_" + new Date().getTime();
                this.checkPayState();
              }
            });

          } else {
            this.$message.warning(`获取微信支付码失败`);
          }
        });
      }

    },
    closePayConfirm(){
      this.payconfirm = false;
      var self = this;
      if (this.tradekey) {
        var ts = this.tradekey.split("_");
        var tradeKey = ts[0];
        self.tradeKey = "";
        window.clearInterval(self.interval);
      }
    },
    checkPayState(){
      console.log("==================================================");
      var self = this;
      var userinfo = this.$store.state.currentUser;
      if (this.tradekey != "") {
        var ts = this.tradekey.split("_");
        var tradeKey = ts[0];
        var startTime = Number(ts[1]);
        setTimeout(function () {
          var inth = setInterval(function () {

            if (self.tradekey == "") {
              console.log("结束");
              window.clearInterval(inth);
              return;
            }
            console.log(self.order.orderNum);
            self.$root.getReq("/web/orderCtl/findOneByOrderNum", { orderNum: self.order.orderNum }).then(d => {
              console.log("findOneByOrderNum");
              console.log(d);
              if (d && d.orderStatus == "4") {
                self.order = d;
                self.payOrderNum = "";
                self.tradekey = "";
                window.clearInterval(inth);
                self.$router.push("/autosubmitorder");
                return;
              } else {
                var passTime = (new Date().getTime() - startTime) / 1000;
                var p = Math.round((passTime / 300) * 100);
                console.log("passed seconds " + passTime);
                if (passTime > 300) {
                  self.payOrderNum = "";
                  clearInterval(inth);
                  self.$root.postReq("/web/tradeCtl/closeOrder", { idkey: tradeKey }).then(d => {
                    self.wxPay();
                  });
                }
              }
            });
          }, 10000);
          self.interval = inth;
        }, 5000)
      }
    },
    orderUpdate(){
      if (!this.order.id) {
        return
      }
      var self = this;
      var obj = this.pay;
      console.log("this.order");
      console.log(this.order.id);
      obj["id"] = this.order.id;
      obj["orderStatus"] = "64";
      console.log(obj);
      this.$root.getReq("/web/orderCtl/orderUpdate", obj).then(d => {
        console.log("d");
        console.log(d);
        self.$router.push("/autosubmitorder");
      });
    }
  },

  vname: "gsb-automaticsubmit"
}
