{
  template: '${tmpl}',
    data: function() {
      var validateAddr = (rule, value, callback) => {
        var x = /(([省])|([中][国])|([中][华][人][民][共][和][国])|([北][京][市])|([上][海][市])|([天][津][市])|([重][庆][市])|([内][蒙][古])|([广][西])|([宁][夏])|([新][疆])|([西][藏])|([内][蒙][古][自][治][区])|([新][疆][维][吾][尔][自][治][区])|([广][西][壮][族][自][治][区])|([宁][夏][回][族][自][治][区])|([西][藏][自][治][区]))/g.test(value);
        if (!x) {
          callback(new Error('请检查申请人地址，必须出现省市县（区）三级！'));
        } else {
          callback();
        }
      };
      var colorizedtm = (rule, value, callback) => {
        if ((this.form.tmFormType == "7" || this.form.tmFormType == "6") && value == "") {
          callback(new Error('请上传彩色商标图样'));
        } else {
          callback();
        }
      };
      var validateIdCard = (rule, value, callback) => {
        if (this.form.type == "person") {
          if (value == "") {
            callback(new Error('请输入身份证号码'));
          } else {
            var x = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/.test(value);
            if (!x) {
              callback(new Error('身份证格式错误'));
            } else {
              callback();
            }
          }
        } else {
          callback();
        }
      };
      var validateSFZ = (rule, value, callback) => {
        if (this.apply.type == "person" && value == "") {
          callback(new Error('身份证明不能为空'));
        } else {
          callback();
        }
      };
      var creditCode = (rule, value, callback) => {
        if (this.apply.type == "ent" && !this.apply.creditCode) {
          callback(new Error('请输入信用代码'));
        } else {
          callback();
        }
      };
      return {
        channelCode: "",
        historyOrderNum: "",
        showSelectedNclList: false,
        fkey: 0,
        tmStatus: "",
        saveDraft: false,
        viewDrafts: false,
        inputDraftName: '',
        viewDraftData: [],
        isIndeterminate: false,
        checkAll: false,
        checkedNcl: [],
        ncl: ["01", "02", "03", "04", "05", "06", "07", "08", "09",
          "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
          "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
          "39", "40", "41", "42", "43", "44", "45"
        ],
        nclOptions: ["01", "02", "03", "04", "05", "06", "07", "08", "09",
          "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24",
          "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
          "39", "40", "41", "42", "43", "44", "45"
        ],
        isIndeterminate: false,
        refbizcode: '',
        bizCode: '',
        filterText: '',
        status: "",
        data2: [{
          id: 1,
          label: '一级 1',
          children: []
        }],
        ncldata: [
          { code: "01", name: "化学原料" }, { code: "02", name: "颜料油漆" }, { code: "03", name: "日化用品" }, { code: "04", name: "燃料油脂" }, { code: "05", name: "医药" },
          { code: "06", name: "金属材料" }, { code: "07", name: "机械设备" }, { code: "08", name: "手工器械" }, { code: "09", name: "科学仪器" }, { code: "10", name: "医疗器械" },
          { code: "11", name: "灯具空调" }, { code: "12", name: "运输工具" }, { code: "13", name: "军火烟火" }, { code: "14", name: "珠宝钟表" }, { code: "15", name: "乐器" },
          { code: "16", name: "办公用品" }, { code: "17", name: "橡胶制品" }, { code: "18", name: "皮革皮具" }, { code: "19", name: "建筑材料" }, { code: "20", name: "家具" },
          { code: "21", name: "厨房洁具" }, { code: "22", name: "绳网袋篷" }, { code: "23", name: "纱线丝" }, { code: "24", name: "布料床单" }, { code: "25", name: "服装鞋帽" },
          { code: "26", name: "纽扣拉链" }, { code: "27", name: "地毯席垫" }, { code: "28", name: "健身器材" }, { code: "29", name: "食品" }, { code: "30", name: "方便食品" },
          { code: "31", name: "饲料种籽" }, { code: "32", name: "啤酒饮料" }, { code: "33", name: "酒" }, { code: "34", name: "烟草烟具" }, { code: "35", name: "广告销售" },
          { code: "36", name: "金融物管" }, { code: "37", name: "建筑修理" }, { code: "38", name: "通讯服务" }, { code: "39", name: "运输贮藏" }, { code: "40", name: "材料加工" },
          { code: "41", name: "教育娱乐" }, { code: "42", name: "网站服务" }, { code: "43", name: "餐饮住宿" }, { code: "44", name: "医疗园艺" }, { code: "45", name: "社会服务" }

        ],
        bigtype: [{
          value: '人工智能', label: '人工智能',
          children: [{ value: '技术研究', label: '技术研究', }, { value: '智能办公', label: '智能办公', }, { value: '智能驾驶', label: '智能驾驶', }, { value: '智能教育', label: '智能教育', }, { value: '智能穿戴', label: '智能穿戴', }]
        },
        {
          value: '文教娱|传媒、教育、文化、娱乐', label: '文教娱|传媒、教育、文化、娱乐',
          children: [{ value: '影视', label: '影视', }, { value: '教育培训', label: '教育培训', }, { value: '文化娱乐', label: '文化娱乐', }, { value: '旅游服务', label: '旅游服务', }]
        },
        {
          value: '服务业|餐饮、修理安装', label: '服务业|餐饮、修理安装',
          children: [{ value: '餐饮', label: '餐饮', }, { value: '修理安装', label: '修理安装', }]
        },
        {
          value: '商业服务|广告、金融、法律财务人力服务', label: '商业服务|广告、金融、法律财务人力服务',
          children: [{ value: '广告、会展', label: '广告、会展', }, { value: '人力资源', label: '人力资源', }, { value: '创业孵化器', label: '创业孵化器', }, { value: '金融财务', label: '金融财务', }, { value: '商业咨询', label: '商业咨询', }, { value: '法律服务', label: '法律服务', }]
        },
        {
          value: '房产建材|建筑工程监理物管', label: '房产建材|建筑工程监理物管',
          children: [{ value: '装饰装潢', label: '装饰装潢', }, { value: '家具家居', label: '家具家居', }, { value: '建材', label: '建材', }, { value: '建筑、监理', label: '建筑、监理', }]
        },
        {
          value: '交通物流|运输、仓储、物流、快递、车辆养护', label: '交通物流|运输、仓储、物流、快递、车辆养护',
          children: [{ value: '物流运输、快递', label: '物流运输、快递', }, { value: '车辆养护、维修', label: '车辆养护、维修', }, { value: '物流仓储', label: '物流仓储', }]
        },
        {
          value: '医药保健化工能源', label: '医药保健化工能源',
          children: [{ value: '化工能源', label: '化工能源', }, { value: '眼镜面罩', label: '眼镜面罩', }, { value: '医疗保健', label: '医疗保健', }, { value: '医疗器械', label: '医疗器械', }, { value: '药品', label: '药品', }, { value: '医疗服务', label: '医疗服务', }]
        },
        {
          value: '食品饮料|生鲜、保健产品、烟酒糖茶', label: '食品饮料|生鲜、保健产品、烟酒糖茶',
          children: [{ value: '烟酒糖茶、饮料', label: '烟酒糖茶、饮料', }, { value: '营养产品', label: '营养产品', }, { value: '生鲜食品、糕点', label: '生鲜食品、糕点', }, { value: '珠宝钟表', label: '珠宝钟表', }, { value: '美容、化妆品', label: '美容、化妆品', }, { value: '服装、配饰', label: '服装、配饰', }]
        },
        {
          value: 'IT、互联网||通信、电子、互联网', label: 'IT、互联网||通信、电子、互联网',
          children: [{ value: '在线服务', label: '在线服务', }, { value: '游戏', label: '游戏', }, { value: '社交、论坛', label: '社交、论坛', }, { value: '电商平台', label: '电商平台', }, { value: '软件开发运营', label: '软件开发运营', }, { value: '家电产品', label: '家电产品', }, { value: '计算机及周边', label: '计算机及周边', }, { value: '通信', label: '通信', }]
        },
        {
          value: '农业|农、林、牧、渔等', label: '农业|农、林、牧、渔等',
          children: [{ value: '化肥、饲料', label: '化肥、饲料', }, { value: '农产品加工', label: '农产品加工', }]
        },
        {
          value: '机械制造|机械车辆五金工具', label: '机械制造|机械车辆五金工具',
          children: [{ value: '五金器械', label: '五金器械', }, { value: '车船航空器制造', label: '车船航空器制造', }, { value: '机械、加工制造', label: '机械、加工制造', }]
        },

        ],
        selectedOptions: [],
        defaultProps: {
          children: 'children',
          label: function (data, node) {
            if (data.code == null || data.code == null) {
              return data.name;
            } else {
              return data.code + " " + data.name;
            }
          }
        },
        form: {
          selecttype: "自主选择",
          tmFormType: "3",
          tmName: "",
          picUrl: "",
          colorizedPicUrl: "",
          nclTotalPublicExpense: 0,
          invoiceTaxes: 0,
          totalSum: 0,
          remark: "",
        },

        rules: {
          tmName: [
            { required: true, message: '请输入商标名称' }
          ],
          picUrl: [
            { required: true, message: '请上传商标图样' }
          ],
          colorizedPicUrl: [
            { validator: colorizedtm, trigger: 'blur' }
          ],
          tmFormType: [
            { required: true, message: '请选择商标类型' }
          ],
        },
        nclOne: [],
        d: {},
        action: "",
        invoiceTaxRate: 10,
        step: "1",
        isRead: false,
        steps: [
          { title: "填写商标信息" },
          { title: "填写申请人信息" },
          { title: "确认订单信息" }
        ],
        apply: {
          type: "",
          applyName: "",
          creditCode: "",
          identityCard: "",
          applyAddr: "",
          zipCode: "100000",
          customerContact: "",
          contactAddress: "",
          mobile: "",
          email: "",
          businessLicensePic: "",
          identityCardPic: "",
          sealAuthorizeStuff: "",
          descUrl: "",
          businessLicensePic2: "",
          identityCardPic2: "",
          principal: "",
        },
        applyrules: {
          type: [
            { type: 'string', required: true, message: '请选择申请类型', trigger: 'change' }
          ],
          applyName: [
            { required: true, message: '请输入公司/申请人名称' }
          ],
          creditCode: [
            { required: true, message: '请输入信用代码' },
            { validator: creditCode, trigger: 'blur' }
          ],
          identityCard: [
            { required: true, message: '请输入身份证号码' },
            { validator: validateIdCard, trigger: 'blur' }
          ],
          zipCode: [
            { required: true, message: '请输入邮政编码' }
          ],
          applyAddr: [
            { required: true, message: '请输入执照详细地址' },
            { validator: validateAddr, trigger: 'blur' }
          ],
          customerContact: [
            { required: true, message: '请输入客户联系人' }
          ],
          contactAddress: [
            { required: true, message: '请输入联系地址' }
          ],
          mobile: [
            { required: true, message: '请输入联系电话' }
          ],
          email: [
            { required: true, message: '请输入电子邮箱' }
          ],
          principal: [
            { type: 'string', required: true, message: '请选择委托主体', trigger: 'change' }
          ],
        },
        order: {},
        qrcode: "",
        qrCodeJumpUrl: "",
        pay: {
          offlinePayDocument: "",
          paymentPlatformType: "wx"
        },
        payconfirm: false,
        tradeKey: "",
        interval: null,
        orderNum: "",
        canedit: true,
        channelOrder: {},
        tm_form_type: { 1: "立体", 3: "字", 4: "图", 5: "字图", 6: "颜色", 7: "彩色" },
      }
    },
  computed: Vuex.mapState({
    count: state => state.count,
    headStyle: function () {
      return { "background-color": "white" };
    }
  }),
    created: function() {

    },
  mounted: function() {
    var that = this;
    var orderNum = this.$store.state.queryParam;
    console.log("orderNumorderNumorderNumorderNum");
    console.log(orderNum);
    this.orderNum = orderNum;
    if (!orderNum) {
      this.$message.warning(`订单参数错误`);
      this.$router.push("/autosubmittminside");
      return;
    }
    that.channelCode = this.$store.state.channelCode;
    var itemCode = this.$store.state.itemCode;
    if (!that.channelCode || !itemCode) {
      this.$message.warning(`参数错误`);
      this.$router.push("/");
      return;
    }
    this.$root.postReq("/web/uploadCtl/getOssConfig", "").then(function (d) {
      that.d["key"] = "key";
      that.d["Bucket"] = d.Bucket;
      that.d["OSSAccessKeyId"] = d.OSSAccessKeyId;
      that.d["Signature"] = d.Signature;
      that.d["policy"] = d.policy;
      that.d["success_action_status"] = d.success_action_status;
      that.action = d.url;
    });
    this.$root.getReq("/web/pconfigCtl/getConfigValue", { configType: "invoiceTaxRate" }).then(function (d) {
      console.log(d);
      if (d != null && d.configValue != null && d.configValue != "") {
        that.invoiceTaxRate = Number(d.configValue);
      }
    });
    this.getOrderDetail();
    this.getChannelOrder();
  },
  methods: {
    tomytm(){
      this.$store.state.isBackToList = true;
      this.$router.push("/autosubmittminside");
    },
    checkClick()
    {
      this.showSelectedNclList = true;
      this.fkey = 1;
    },
    checkConfirm(){
      this.showSelectedNclList = false;
      this.fkey = 0;
      console.log(this.checkedNcl);
      this.nclSearch();
    },
    handleCheckAllChange(val)
    {
      console.log(val);
      this.checkedNcl = val ? this.nclOptions : [];
      console.log(this.checkedNcl);
      this.isIndeterminate = false;
    },
    handleCheckedNclChange(value)
    {
      console.log(value);
      let checkedCount = value.length;
      this.checkAll = checkedCount === this.ncl.length;
      this.isIndeterminate = checkedCount > 0 && checkedCount < this.ncl.length;
    },
    getChannelOrder: function() {
      var that = this;
      var channelOrderNum = this.$store.state.channelOrderNum;
      var orderNum = this.$store.state.queryParam;
      var env = this.$store.state.env;
      var obj = { env: env, channelOrderNum: channelOrderNum, orderNum: orderNum, type: "2" };
      that.$root.showMask();
      this.$root.getReq("/web/orderCtl/getChannelOrderByOrderNum", obj).then(function (d) {
        console.log(d, "getChannelOrderByOrderNum..........................");
        if (d && d.code == 1) {
          var data = d.data;
          that.channelOrder = data;
        } else {
          that.$message.warning(d.msg);
        }
        that.$root.hideMask();
      }).catch(function (e) {
        console.log(e, "error................");
        that.$message.warning("获取渠道订单失败，请刷新页面后重新操作");
      })
    },
    createWTS: function() {
      var that = this;
      if (!this.apply.type) {
        that.$message.warning("请选择申请人类型");
        return;
      } else if (!this.apply.applyName) {
        that.$message.warning("请填写公司名称");
        return;
      } else if (this.apply.type == "person" && !this.apply.identityCard) {
        that.$message.warning("请填写身份证号码");
        return;
      } else if (!this.apply.applyAddr) {
        that.$message.warning("请填写执照详细地址");
        return;
      } else if (!this.apply.principal) {
        that.$message.warning("请选择提报类型");
        return;
      } else if(!this.apply.customerContact) {
        that.$message.warning("请填写客户联系人");
        return;
      }
      
      that.$root.showMask();
      var params = this.apply.type + ";" + this.apply.applyName + ";" + this.apply.identityCard + ";" + this.form.tmFormType
        + ";" + this.form.colorizedPicUrl + ";" + this.form.picUrl + ";" + this.apply.applyAddr;
      params = encodeURIComponent(params);
      console.log(params);
      var url = window.location.href.split("/autosubmitinside")[0] + "/mobile2?" + "params=" + params + "#/createwts2";
      console.log(url);
      
      let tm_name = "";
      if(this.form.tmFormType == 3 || this.form.tmFormType == 5) {
        tm_name = this.form.tmName;
      }
      if(this.form.tmFormType == 4 || this.form.tmFormType == 7) {
        tm_name = "图形";
      }
      if(this.form.tmFormType)
      this.$root.getReq("/web/calculatepriceCtl/tmtrust", {
        assignor: this.apply.applyName, 
        tm_name: tm_name,  
        address: this.apply.applyAddr,
        company: this.apply.principal,
      }).then(function (d) {

        if (d.data.tm_trust_url != "" && d.data.tm_trust_url != null) {
          window.open(d.data.tm_trust_url);
        } else {
          that.$message.warning(`操作失败`);
        }
        that.$root.hideMask();
      }).catch(function (e) {
        that.$root.hideMask();
        that.$message.warning(`操作失败`);
      });
    },
    getOrderDetail: function() {
      var orderNum = this.orderNum;
      var env = this.$store.state.env;
      var that = this;
      that.$root.showMask();
      this.$root.getReq("/web/orderCtl/getOrderDetailByOrderNum", { orderNum: orderNum, env: env }).then(function (d) {
        console.log(d, "/web/orderCtl/getOrderDetailByOrderNum...............s01.");
        if (d && d.code == "1") {
          var d_tm = d.data.tms[0];
          var d_order = d.data.order;
          var d_apply = d.data.apply;
          var d_customer = d.data.customer;
          that.channelCode = d_order.channelCode;
          var form = {
            selecttype: "自主选择",
            tmFormType: d_tm.tmFormType,
            tmName: d_tm.tmName,
            picUrl: d_tm.picUrl,
            colorizedPicUrl: d_tm.colorizedPicUrl,
            remark: d_order.remark
          };

          that.tmStatus = d_tm.tmStatus;
          console.log('商标状态： ', that.tmStatus);
          console.log('前端打印接收后端的数据： ', JSON.stringify(d_apply));

          var apply = {
            type: d_apply ? d_apply.type : "",
            applyName: d_apply ? d_apply.applyName : "",
            creditCode: d_apply ? d_apply.creditCode : "",
            identityCard: d_apply ? d_apply.identityCard : "",
            applyAddr: d_apply ? d_apply.applyAddr : "",
            zipCode: d_customer ? d_customer.zipCode : "100000",
            customerContact: d_customer ? d_customer.customerContact : "",
            contactAddress: d_customer ? d_customer.contactAddress : "",
            mobile: d_customer ? d_customer.mobile : "",
            email: d_customer ? d_customer.email : "",
            principal: d_tm.principal ? d_tm.principal : "",
            businessLicensePic: d_apply ? d_apply.businessLicensePic : "",
            identityCardPic: d_apply ? d_apply.identityCardPic : "",
            businessLicensePic2: d_apply ? d_apply.businessLicensePic2 : "",
            identityCardPic2: d_apply ? d_apply.identityCardPic2 : "",
            sealAuthorizeStuff:
              d_tm.sealAuthorizeStuff, descUrl:
              d_tm.descUrl
          };
          var order = d_order;
          that.form = form;
          that.apply = apply;
          that.order = order;
          var nclOne = [];
          for (var i = 0; i < d.data.tms.length; i++) {
            var t = d.data.tms[i];
            var nclThree = null;
            if (t.nclSmallCodes.indexOf("nclthree") < 0) {
              nclThree = JSON.parse(t.nclSmallCodes);
            } else {
              var tmpNclThree = JSON.parse(t.nclSmallCodes);
              var sources = [];
              for (var j = 0; j < tmpNclThree.nclthree.length; j++) {
                var tmpItem = tmpNclThree.nclthree[j];
                if (tmpItem) {
                  var source = {
                    "code": tmpNclThree.nclthree[j].code,
                    "name": tmpNclThree.nclthree[j].name,
                    "fullname": tmpNclThree.nclthree[j].code + " " + tmpNclThree.nclthree[j].name,
                    "pcode": tmpNclThree.nclthree[j].pcode,
                    "disabled": false
                  };
                  sources.push(source);
                }
              }
              nclThree = sources;
            }
            var name = that.ncldata[Number(t.nclOneCodes) - 1].name;
            var o = { code: t.nclOneCodes, name: name, nclThree: nclThree };
            nclOne.push(o);

          }
          that.nclOne = nclOne;
          that.$root.hideMask();
        }
        that.$root.hideMask();
      });
    },
    gotoorder: function() {
      this.$router.push("/products/order/13");
    },
    searchInputBlur(){
      var text = this.filterText;
      if (text == "" || text == null) {
        this.initNclData();
      }
    },
    nclSearch(){
      var that = this;
      var text = this.filterText;
      if (text == "" || text == null) {
        this.initNclData();
      } else {
        this.$root.showMask();
        this.$root.postReq("/web/calculatepriceCtl/getNclByLikeNameAndNcl", { "name": text, "ncls": this.checkedNcl }).then(function (d) {
          if (d.status == 0) {
            console.log(d);
            that.ncldata = d.data;
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.$root.hideMask();
        });
      }
    },
    initNclData(){
      this.ncldata = [
        { code: "01", name: "化学原料" }, { code: "02", name: "颜料油漆" }, { code: "03", name: "日化用品" }, { code: "04", name: "燃料油脂" }, { code: "05", name: "医药" },
        { code: "06", name: "金属材料" }, { code: "07", name: "机械设备" }, { code: "08", name: "手工器械" }, { code: "09", name: "科学仪器" }, { code: "10", name: "医疗器械" },
        { code: "11", name: "灯具空调" }, { code: "12", name: "运输工具" }, { code: "13", name: "军火烟火" }, { code: "14", name: "珠宝钟表" }, { code: "15", name: "乐器" },
        { code: "16", name: "办公用品" }, { code: "17", name: "橡胶制品" }, { code: "18", name: "皮革皮具" }, { code: "19", name: "建筑材料" }, { code: "20", name: "家具" },
        { code: "21", name: "厨房洁具" }, { code: "22", name: "绳网袋篷" }, { code: "23", name: "纱线丝" }, { code: "24", name: "布料床单" }, { code: "25", name: "服装鞋帽" },
        { code: "26", name: "纽扣拉链" }, { code: "27", name: "地毯席垫" }, { code: "28", name: "健身器材" }, { code: "29", name: "食品" }, { code: "30", name: "方便食品" },
        { code: "31", name: "饲料种籽" }, { code: "32", name: "啤酒饮料" }, { code: "33", name: "酒" }, { code: "34", name: "烟草烟具" }, { code: "35", name: "广告销售" },
        { code: "36", name: "金融物管" }, { code: "37", name: "建筑修理" }, { code: "38", name: "通讯服务" }, { code: "39", name: "运输贮藏" }, { code: "40", name: "材料加工" },
        { code: "41", name: "教育娱乐" }, { code: "42", name: "网站服务" }, { code: "43", name: "餐饮住宿" }, { code: "44", name: "医疗园艺" }, { code: "45", name: "社会服务" }
      ];
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    uploadsuccess2(result, obj){
      if (obj.flag == "zfpz") {
        this.pay.offlinePayDocument = result;
      }
    },
    uploadsuccess(obj){
      var that = this;
      if (obj.flag == "picUrl") {
        that.$root.showMask();
        console.log("====" + JSON.stringify(obj));

        this.$root.getReq("/web/calculatepriceCtl/tmimage", { "fileUrl": obj.result }).then(function (d) {
          that.$root.hideMask();
          console.log(JSON.stringify(d));
          if (d.status == 1) {
            that.form.picUrl = d.data.gray_url;
          } else {
            that.form.picUrl = "";
            that.$message.warning(`上传失败请重新上传`+ d.msg);
            return false;
          }
        }).catch(function () {
          that.form.picUrl = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        });
      }
      if (obj.flag == "colorizedPicUrl") {
        that.$root.showMask();
        this.$root.getReq("/web/calculatepriceCtl/tmimage", { "fileUrl": obj.result }).then(function (d) {
          that.$root.hideMask();
          if (d.status == 1) {
            that.form.colorizedPicUrl = d.data.original_url;
          } else {
            that.form.colorizedPicUrl = "";
            that.$message.warning(`上传失败请重新上传`+ d.msg);
            return false;
          }
        }).catch(function () {
          that.form.colorizedPicUrl = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        });

      }
      if (obj.flag == "yyzz") {
        if (that.channelCode == "ali_zcsubmit") {
          that.apply.businessLicensePic = obj.result;
          that.apply.businessLicensePic2 = obj.result;
        } else {
          that.$root.showMask();
          this.$root.getReq("/web/orderCtl/pic2pdf", { "key": obj.key }).then(function (d) {
            that.$root.hideMask();
            if (d.status == 0) {
              that.apply.businessLicensePic = d.data.url;
              that.apply.businessLicensePic2 = obj.result;
            } else {
              that.apply.businessLicensePic = "";
              that.apply.businessLicensePic2 = "";
              that.$message.warning(`上传失败请重新上传`);
              return false;
            }
          }).catch(function (e) {
            that.apply.businessLicensePic = "";
            that.apply.businessLicensePic2 = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          })
        }
      }
      if (obj.flag == "sfz") {
        if (that.channelCode == "ali_zcsubmit") {
          that.apply.identityCardPic = obj.result;
          that.apply.identityCardPic2 = obj.result;
        } else {
          that.$root.showMask();
          this.$root.getReq("/web/orderCtl/pic2pdf", { "key": obj.key }).then(function (d) {
            that.$root.hideMask();
            if (d.status == 0) {
              that.apply.identityCardPic = d.data.url;
              that.apply.identityCardPic2 = obj.result;
            } else {
              that.apply.identityCardPic = "";
              that.apply.identityCardPic2 = "";
              that.$message.warning(`上传失败请重新上传`);
              return false;
            }
          }).catch(function (e) {
            that.apply.identityCardPic = "";
            that.apply.identityCardPic2 = "";
            that.$root.hideMask();
            that.$message.warning(`上传失败请重新上传`);
            return false;
          })
        }
      }
      if (obj.flag == "wts") {
        that.$root.showMask();
        this.$root.getReq("/web/orderCtl/adjustWTSSize", { "key": obj.key }).then(function (d) {
          that.$root.hideMask();
          if (d.status == 0) {
            that.apply.sealAuthorizeStuff = d.data.url;
          }
          else if (d.status == -110) {
            that.apply.sealAuthorizeStuff = "";
            that.$message.warning(`上传失败，格式不是jpg，请确认上传的文件是否是：修改文件后缀成jpg 或 画图另存为jpg之后文件的格式真的变成jpg，请使用专业的工具进行文件转换成jpg格式`);
            return false;
          }
          else {
            that.apply.sealAuthorizeStuff = "";
            that.$message.warning(`上传失败请重新上传`);
            return false;
          }
        }).catch(function () {
          that.apply.sealAuthorizeStuff = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新上传`);
          return false;
        });
      }
      if (obj.flag == "yxq") {
        that.apply.descUrl = obj.result;
      }

    },
    beforeUpload(file){
      var that = this;
      var isSize = false;
      var img = new Image();
      var _URL = window.URL || window.webkitURL;
      img.onload = function () {
        if (img.width == img.height) {
          isSize = true;
          that.$refs.colorizedPicUrl.ifupload = true;
        } else {
          isSize = false;
          that.$message.warning('上传的图片宽高必须相等');
          that.$refs.colorizedPicUrl.$refs.upload.abort(file);
        }
      };
      img.src = window.URL.createObjectURL(file);

    },
    showUrl(url){
      window.open(url);
    },
    closeTag(nclThree, index, index2){
      if (this.form.status == 2) {
        this.$message.warning("已生成订单，不可修改");
        return false;
      }
      this.nclOne[index].nclThree.splice(index2, 1);
      if (this.nclOne[index].nclThree.length > 10) {
        this.nclOne[index].price = Number(300 + (this.nclOne[index].nclThree.length - 10) * 30);
      } else if (this.nclOne[index].nclThree.length > 0 && this.nclOne[index].nclThree.length <= 10) {
        this.nclOne[index].price = 300;
      } else {
        this.nclOne[index].price = 0;
        this.removeNclOne(index);
      }
      this.updatePrice();
      var json = { json: this.nclOne };
      var jsonStr = JSON.stringify(json);
    },
    removeNclOne(index){
      if (this.form.status == 2) {
        this.$message.warning("已生成订单，不可修改");
        return false;
      }
      this.nclOne.splice(index, 1);
      this.updatePrice();
    },
    nodeClick(obj, e, a){
      var that = this;
      if (this.form.status == 2) {
        this.$message.warning("已生成订单，不可修改");
        return false;
      }
      if (e.level < 3 && e.childNodes.length == 0) {
        var o = {
          nclcode: obj.code,
        };
        this.$root.getReq("/web/ncloneCtl/getNcl", o).then(function (d) {
          var data = d.data.rows;
          for (var i = 0; i < data.length; i++) {
            that.appendNode(data[i], e);
          }
        });
      }
      if (e.level == 3) {
        var ppncl = e.parent.parent.data;
        var nclThree = [e.data];

        var result = this.nclOneIsExist(ppncl.code);
        if (result.result) {
          var nclThree = this.nclOne[result.index].nclThree;
          var hasNclThree = this.nclThreeIsExist(e.data.name, nclThree);
          if (!hasNclThree.result) {
            this.nclOne[result.index].nclThree.push(e.data);
            if (this.nclOne[result.index].nclThree.length > 10) {
              this.nclOne[result.index].price = Number(300 + (this.nclOne[result.index].nclThree.length - 10) * 30);
            }

          }
        } else {
          var data = {
            code: ppncl.code,
            name: ppncl.name,
            price: 300,
            nclThree: nclThree,
          };
          this.nclOne.push(data);
        }
        this.updatePrice();
      }
    },
    nclThreeIsExist(name, nclThree){
      if (nclThree.length < 1) {
        return { result: false, index: 0 };
      } else {
        for (var i = 0; i < nclThree.length; i++) {
          if (nclThree[i].name == name) {
            return { result: true, index: i };
          }
        }
        return { result: false, index: 0 };
      }
    },
    nclOneIsExist(nclOneCode){
      if (this.nclOne.length < 1) {
        return { result: false, index: 0 };
      } else {
        for (var i = 0; i < this.nclOne.length; i++) {
          if (this.nclOne[i].code == nclOneCode) {
            return { result: true, index: i };
          }
        }
        return { result: false, index: 0 };
      }
    },
    word2pic(){
      if (this.form.tmName == "" || this.form.tmName == null) {
        this.$root.showMask();
        this.$root.hideMask();
        return false;
      }
      var obj = { word: this.form.tmName };
      var that = this;
      this.$root.showMask();
      this.$root.getReq("/web/calculatepriceCtl/word2pic", obj).then(function (d) {

        if (d.status == 0) {
          that.form.picUrl = d.data.url;
          that.$root.hideMask();
        } else {
          that.form.picUrl = "";
          that.$root.hideMask();
          that.$message.warning(`上传失败请重新生成`);
          return false;
        }

      }).catch(function () {
        that.form.picUrl = "";
        that.$root.hideMask();
        that.$message.warning(`上传失败请重新生成`);
        return false;
      });

    },
    updatePrice(){
      this.form.totalSum = 0;
      this.form.invoiceTaxes = 0;
      this.form.nclTotalPublicExpense = 0;
      for (var i = 0; i < this.nclOne.length; i++) {
        this.form.nclTotalPublicExpense = this.form.nclTotalPublicExpense + this.nclOne[i].price;
      }
      this.form.invoiceTaxes = Number(this.form.nclTotalPublicExpense) * 100 * Number(this.invoiceTaxRate) / 10000;
      this.form.totalSum = Number(this.form.nclTotalPublicExpense) + Number(this.form.invoiceTaxes);
    },
    appendNode(data, pnode) {

      this.$refs.tree.append(data, pnode);
    },
    filterNode(value, data) {
      if (!value) return true;
      return data.label.indexOf(value) !== -1;
    },

    aiadive(){
      if (this.selectedOptions.length == 0) {
        this.$message.warning(`请选择行业`);
        return false;
      }
      this.$root.getReq("/web/calculatepriceCtl/aiadive", { seltype: this.selectedOptions }).then(d => {
        console.log(d.data);
        var ncl = JSON.parse(d.data);
        this.nclOne = ncl.ncl;
        this.updatePrice();
      });
    },
    selfclear(){
      this.nclOne = [];
    },
    checkChannelUsableOrder(){
      var order = this.order;
      if (order) {
        if (!order.created_at || !order.orderSourceType || order.orderSourceType == '8') {
          return { code: 1 };
        }
        console.log(order.created_at);
        var create_date = new Date(order.created_at);
        if (create_date) {
          var time = create_date.getTime();
          console.log(time);
          if (time < 1576666800000) {/**2019-12-18 19:00:00 之前创建的订单，不做校验 */
            return { code: 1 };
          }
        }
      }
      var usable_order_no_class_count = this.channelOrder.usable_order_no_class_count;
      var usableOrderList = null;
      if (usable_order_no_class_count) {
        usableOrderList = usable_order_no_class_count.slice(0);
      }
      this.channelOrder.usable_order_no_class_count;
      var nclOnes = this.nclOne;
      if (!usableOrderList || usableOrderList.length < 1) {
        return { code: -1, msg: "有效渠道订单为空" };
      }
      if (!nclOnes || nclOnes.length < 1) {
        return { code: -2, msg: "尼斯信息不能为空" };
      }
      for (var a = 0; a < nclOnes.length; a++) {
        var nclOne = nclOnes[a];
        nclOne["channelOrderListInfo"] = null;
      }
      for (var i = 0; i < nclOnes.length; i++) {
        var nclOne = nclOnes[i];
        var nclThree = nclOne.nclThree;
        if (nclThree.length > 10) {
          for (var j = 0; j < usableOrderList.length; j++) {
            var usableOrder = usableOrderList[j];
            if (usableOrder && usableOrder.class_count && usableOrder.class_count == nclThree.length) {
              nclOne["channelOrderListInfo"] = usableOrder.order_no;
              usableOrderList[j] = null;
              break;
            }
          }
        } else {
          for (var k = 0; k < usableOrderList.length; k++) {
            var usableOrder = usableOrderList[k];
            if (usableOrder && (!usableOrder.class_count || usableOrder.class_count <= 10)) {
              nclOne["channelOrderListInfo"] = usableOrder.order_no;
              usableOrderList[k] = null;
              break;
            }
          }
        }
        if (!nclOne["channelOrderListInfo"]) {
          return { code: -3, msg: "建案内容与订单条件不匹配，请仔细核对！" };
        }
      }
      return { code: 1 };
    },
    submitForm(formName) {
      var that = this;
      if (formName == "form" || formName == "apply") {
        this.$refs[formName].validate((valid) => {
          if (valid) {
            if (!that.channelOrder) {
              that.$message.warning(`渠道订单异常`);
              return false;
            }
            if (!that.channelOrder.remainder || that.channelOrder.remainder < 0) {

              if (that.tmStatus != "12" && that.tmStatus != "13") {
                that.$message.warning(`渠道订单产品数量异常`);
                return false;
              }

            }
            if (formName == "form" && that.nclOne.length < 1) {
              that.$message.warning(`请选择商标分类`);
              return false;
            }
            if (formName == "form" && that.nclOne.length > that.channelOrder.remainder) {
              that.$message.warning(`渠道订单产品数量不足`);
              return false;
            }
            if (formName == "form") {
              var checkRes = that.checkChannelUsableOrder();
              if (checkRes.code != 1) {
                that.$message.warning(checkRes.msg);
                return false;
              }
            }
            that.step = Number(that.step) + 1;
          } else {
            console.log('error submit!!');
            return false;
          }
        });
      }
      if (formName == "save") {
        this.$root.showMask();
        if (this.order.orderStatus == "2") {
          this.$message.warning("该订单已取消，无法修改");
          this.getOrderDetail();
          that.$root.hideMask();
          return
        }
        var itemCode = this.$store.state.itemCode;
        var channelOrderNum = this.$store.state.channelOrderNum;
        var channelUserId = this.$store.state.openid;
        var env = this.$store.state.env;
        if (!that.channelCode || !itemCode) {
          that.$root.hideMask();
          return
        }
        console.log(this.form);
        var tm = {
          colorizedPicUrl: this.form.colorizedPicUrl,
          orderNum: this.order.orderNum, tmFormType: this.form.tmFormType, tmName: this.form.tmName, channelUserId: channelUserId,
          picUrl: this.form.picUrl, sealAuthorizeStuff: this.apply.sealAuthorizeStuff, descUrl: this.apply.descUrl
        };
        console.log("this.apply");
        console.log(this.apply);
        var apply = {
          orderNum: this.order.orderNum, type: this.apply.type, applyName: this.apply.applyName, creditCode: this.apply.creditCode,
          identityCard: this.apply.identityCard, applyAddr: this.apply.applyAddr, businessLicensePic: this.apply.businessLicensePic,
          identityCardPic: this.apply.identityCardPic, remark: this.form.remark, mobile: this.apply.mobile,
          businessLicensePic2: this.apply.businessLicensePic2,
          identityCardPic2: this.apply.identityCardPic2, principal: this.apply.principal
        };
        var customer = {
          orderNum: this.order.orderNum, zipCode: this.apply.zipCode || "100000", customerContact: this.apply.customerContact, contactAddress: this.apply.contactAddress, mobile: this.apply.mobile,
          email: this.apply.email
        };
        var obj = { env: env, tm: tm, apply: apply, customer: customer, nclones: this.nclOne, channelOrderNum: channelOrderNum, channelUserId: channelUserId };

        console.log(obj);
        that.$root.postReq("/web/orderCtl/updateInsideOrderDetailByOrderNum", obj).then(function (d) {
          console.log(d, "updateInsideOrderDetailByOrderNum..............");
          if (d.code == "1") {
            that.$message.success(`修改成功`);
            that.$router.push("/autosubmittminside");
          } else if (d.code = "-100" && d.msg) {
            console.log(d.msg);
            that.$message.warning(d.msg);
            that.getOrderDetail();
          } else {
            that.$message.warning("操作失败");
          }
          that.$root.hideMask();
        }).catch(function (e) {
          that.$root.hideMask();
        });
      }

    },
    applierChange(){
      this.$root.getReq("/web/calculatepriceCtl/getEntregistryByCompanyName", { companyName: this.apply.applyName }).then(d => {
        if (d.creditCode && d.creditCode != "") {
          this.apply.applyAddr = d.businessAddress;
          this.apply.creditCode = d.creditCode;
        }
      });
    },
    setKey(name, flag){
      console.log(name);
      console.log(flag);
      name = name.substring(name.length - 5);
      var myDate = new Date();
      var key = "zc_" + flag + Math.round(Math.random() * 10000) + myDate.getFullYear() + myDate.getMonth() + myDate.getDate() + myDate.getTime() + ".jpg";
      console.log(this.$refs[flag]);
      this.$refs[flag].d.key = key;
    },
    tobefore(){
      this.step = Number(this.step) - 1;
      this.step = this.step.toString();
    },
    draftNameBoxClose(){
      this.saveDraft = false;
    },
    viewDraftsBoxClose(){
      this.viewDrafts = false;
    },
    reuseDraft: function(row) {
      console.log('=========row', row.draftId, row.draftName);
      this.$root.getReq("web/drafthistoryCtl/findOneDraft", { id: row.draftId }).then(d => {
        console.log("findOneDraft return :", d);
        var data = d.data.draftData;
        if (data.checkedNcl) {
          this.checkedNcl = data.checkedNcl;
        }
        if (data.form) {
          this.form = data.form;
        }
        if (data.nclOne) {
          this.nclOne = data.nclOne;
        }
        if (data.apply) {
          this.apply = data.apply;
        }
      }).catch(e => {
        console.log('findDraft error： ', e);
      })

    },
    findDraft: function() {
      this.viewDrafts = true;
      this.$root.getReq("/web/drafthistoryCtl/findDraft", {}).then(d => {
        console.log("findDraft return :", d);
        var result = d.data;
        var draftList = [];
        result.forEach((draft, idx) => {
          var draftrow = {};
          draftrow.draftId = draft.id;
          draftrow.draftName = draft.draftName;
          draftList.push(draftrow);
        });
        this.viewDraftData = draftList;
      }).catch(e => {
        console.log('findDraft error： ', e);
      });
    },
    updateDraft: function() {
      var data = { obj: { id: '2' }, newData: { draftData: { "name": "更新测试数据" } } };
      this.$root.postReq("/web/drafthistoryCtl/updateDraft", data).then(d => {
        console.log("updateDraft return:", d);
      }).catch(e => {
        console.log("updateDraft error ", e);
      });
    },
    deleteDraft: function(row) {
      console.log('----------', row.draftId);
      var data = { id: row.draftId };
      this.$root.getReq("/web/drafthistoryCtl/deleteDraft", data).then(d => {
        console.log("deleteDraft return:", d);
        this.$message.success("删除成功");
        this.viewDraftData.forEach((rowData, idx) => {
          if (row === rowData) {
            this.viewDraftData.splice(idx, 1);
          }
        });
      }).catch(e => {
        console.log("deleteDraft error: ", e);
      });
    },
    createDraft: function() {
      if (!this.inputDraftName) {
        this.$message.warning("草稿名称不能为空");
        return;
      };
      var data = { draftName: this.inputDraftName, draftData: { checkedNcl: this.checkedNcl, form: this.form, nclOne: this.nclOne, apply: this.apply } };
      this.$root.postReq("/web/drafthistoryCtl/createDraft", data).then(d => {
        console.log("createDraft return:", d);
        this.$message.success("保存草稿成功");
        this.saveDraft = false;
      }).catch(e => {
        console.log("createDraft error: ", e);
      })
    },
    savedraft: function() {
      this.$confirm('此操作将保存数据至草稿并删除历史草稿数据, 是否继续?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        var data = { checkedNcl: this.checkedNcl, form: this.form, nclOne: this.nclOne, apply: this.apply };
        var dataString = JSON.stringify(data);
        localStorage.setItem("automatictmsubmitinside_draft", dataString);
        this.$message.success("保存草稿成功");
      }).catch(e => {
        console.log(e);
      });

    },
    usedraft: function() {
      this.$confirm('是否复用草稿数据?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        var dataString = localStorage.getItem("automatictmsubmitinside_draft");
        if (dataString) {
          var data = JSON.parse(dataString);
          if (data.checkedNcl) {
            this.checkedNcl = data.checkedNcl;
          }
          if (data.form) {
            this.form = data.form;
          }
          if (data.nclOne) {
            this.nclOne = data.nclOne;
          }
          if (data.apply) {
            this.apply = data.apply;
          }
        } else {
          this.$message.warning("草稿数据为空");
        }
      }).catch(e => {
        console.log(e);
      });
    },
    importHistoryNcl: function() {
      if (this.historyOrderNum) {
        this.$root.showMask();
        this.$root.getReq("/web/trademarkCtl/getHistoryNclByChannelOrderNum", { channelOrderNum: this.historyOrderNum }).then(d => {
          console.log("d");
          console.log(d);
          if (d && d.code == 1) {
            var tms = d.data;
            var nclOne = [];
            for (var i = 0; i < tms.length; i++) {
              var t = tms[i];
              var nclThree = null;
              if (t.nclSmallCodes.indexOf("nclthree") < 0) {
                nclThree = JSON.parse(t.nclSmallCodes);
              } else {
                var tmpNclThree = JSON.parse(t.nclSmallCodes);
                var sources = [];
                for (var j = 0; j < tmpNclThree.nclthree.length; j++) {
                  var tmpItem = tmpNclThree.nclthree[j];
                  if (tmpItem) {
                    var source = {
                      "code": tmpNclThree.nclthree[j].code,
                      "name": tmpNclThree.nclthree[j].name,
                      "fullname": tmpNclThree.nclthree[j].code + " " + tmpNclThree.nclthree[j].name,
                      "pcode": tmpNclThree.nclthree[j].pcode,
                      "disabled": false
                    };
                    sources.push(source);
                  }
                }
                nclThree = sources;
              }
              var name = this.ncldata[Number(t.nclOneCodes) - 1].name;
              var o = { code: t.nclOneCodes, name: name, nclThree: nclThree, price: (nclThree.length - 10) * 30 + 300 };
              nclOne.push(o);

            }
            this.nclOne = nclOne;
            this.$message.success("导入成功");
          } else {
            this.$message.warning(d.msg);
          }
          this.$root.hideMask();
        }).catch(e => {
          console.log(e);
          this.$root.hideMask();
          this.$message.warning("操作失败")
        });

      } else {
        this.$message.warning("请填写历史订单号");
      }
    }
  },

  vname: "gsb-automatictmsubmitedit"
}
