﻿var url=require("url");
var System=require("../../base/system");
var wxsvr=require("../../base/service/wxsvr");
const settings=require("../settings");
const logCtl=System.getObject("web.oplogCtl");
var apitradeSvr=System.getObject("service.apitradeSve");
module.exports = function (app) {
	app.all("/applet/*",function(req,res,next){
			return next();
	});
	app.get('/applet/:qname/:method', function(req,res){
		console.log("get");
			try {
				console.log(req.headers);
				req.codepath=req.headers["codepath"];
	  	  var classPath=req.params["qname"];
				var methodName=req.params["method"];
				var tClientIp=System.get_client_ip(req);
				var params=[];
	      params.push(req.query);
				var db=System.getObject("db.connection").getCon();
				var cacheManager=System.getObject("db.cacheManager");
				var key=req.query.key;
				if(key){
					var userInfo = cacheManager["AppletUserinfoCache"].get(key);
					if(userInfo){
						req["userinfo"]=JSON.parse(userInfo);
					}
				}
				params.push(req);
				var p=null;
				var invokeObj= System.getObject("applet."+classPath);
				if(invokeObj[methodName]){
					p=invokeObj[methodName].apply(invokeObj,params);
				}
				p.then(r=>{
					if(classPath=="wxApplet" && (methodName=="checkSignature" ||methodName=="checkWxSignature" )){
						res.end(r);
					}else{
						res.end(JSON.stringify(r));
					}

				});
			} catch (e) {
				console.log(e);
				logCtl.error({
					 optitle:"applet get接口调用异常error:",
					 op:classPath+"/"+methodName,
					 content:e.stack,
					 clientIp:tClientIp,
					 agent:req.headers["user-agent"],
				 });
			}

	});
	app.post('/applet/:qname/:method', function(req,res){
		console.log("post");
			req.codepath=req.headers["codepath"];
		  var classPath=req.params["qname"];
	    var methodName=req.params["method"];
			var params=[];
			// for(let k in req.query){
			// 	params.push(req.query[k]);
			// }
      params.push(req.query);
			params.push(req.body);
			var tClientIp=System.get_client_ip(req);
			req.body.clientIp=tClientIp;
			var db=System.getObject("db.connection").getCon();
			var cacheManager=System.getObject("db.cacheManager");
			var key=req.query.key;
			if(key){
				var userInfo = cacheManager["AppletUserinfoCache"].get(key);
				if(userInfo){
					req["userinfo"]=JSON.parse(userInfo);
				}
			}
			params.push(req);
			var p=null;
			var invokeObj= System.getObject("applet."+classPath);
			if(invokeObj[methodName]){
				p=invokeObj[methodName].apply(invokeObj,params);
			}
			p.then(r=>{
				res.end(JSON.stringify(r));
			}).then(()=>{
				params.pop();
				logCtl.info({
					 optitle:"applet post接口调用info:",
					 op:classPath+"/"+methodName,
					 content:params.length==0?"":JSON.stringify(params),
					 clientIp:tClientIp,
					 agent:req.headers["user-agent"],
				 });
			}).catch(e=>{
				console.log(e);
				logCtl.error({
					 optitle:"applet post接口调用异常error:",
					 op:classPath+"/"+methodName,
					 content:e.stack,
					 clientIp:tClientIp,
					 agent:req.headers["user-agent"],
				 });
			});
	});
};
