﻿var url = require("url");
var System = require("../../base/system");
var wxsvrFunc = require("../../base/service/wxsvr");
var apitradeSvr = System.getObject("service.apitradeSve");
var wxcz = null;
var ecwx = null;
module.exports = function (app) {
	app.get('/wx', function (req, res) {
		if (!wxcz) {
			wxcz = wxsvrFunc("wx");
		}
		// 签名成功
		if (wxcz.checkSignature(req)) {
			res.status(200).send(req.query.echostr);
		} else {
			res.status(200).send('fail');
		}
	});
	app.post('/wx', function (req, res) {
		if (!wxcz) {
			wxcz = wxsvrFunc("wx");
		}
		// loop
		wxcz.loop(req, res);
	});
	//电子合同
	app.get('/ecwx', function (req, res) {
		if (!ecwx) {
			ecwx = wxsvrFunc("ecwx");
		}
		// 签名成功
		if (ecwx.checkSignature(req)) {
			res.status(200).send(req.query.echostr);
		} else {
			res.status(200).send('fail');
		}
	});
	app.post('/ecwx', function (req, res) {
		if (!ecwx) {
			ecwx = wxsvrFunc("ecwx");
		}
		// loop
		ecwx.loop(req, res);
	});
	app.get('/api/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var params = [];
		for (let k in req.query) {
			params.push(req.query[k]);
		}
		var p = null;
		var invokeObj = System.getObject("api." + classPath);
		if (invokeObj[methodName]) {
			p = invokeObj[methodName].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		})
	});
	app.post('/api/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var params = [];
		var tClientIp = System.get_client_ip(req);
		// req.body.clientIp=tClientIp;
		for (let k in req.query) {
			params.push(req.query[k]);
		}
		params.push(req.body);
		var beforesel = null;
		if (req.body.appKey != 'undefined' && req.body.appKey != "" && req.body.appKey != null) {
			beforesel = apitradeSvr.beforesel({
				appkey: req.body.appKey,
				tradeType: "consume",
				op: classPath + "/" + methodName,
				params: JSON.stringify(req.body),
				clientIp: tClientIp,
				agent: req.headers["user-agent"],
			});
			beforesel.then(a => {
				//params.push(req.query);
				if (a.status < 0) {
					return res.end(JSON.stringify(a));
				}
				else {
					params.push(req.body);
					var p = null;
					var invokeObj = System.getObject("api." + classPath);
					if (invokeObj[methodName]) {
						p = invokeObj[methodName].apply(invokeObj, params);
					}
					p.then(r => {
						res.end(JSON.stringify(r));
					}).then(() => {
						if (req.body.appKey != 'undefined' && req.body.appKey != "" && req.body.appKey != null) {
							apitradeSvr.create({
								appkey: req.body.appKey,
								tradeType: "consume",
								op: classPath + "/" + methodName,
								params: JSON.stringify(req.body),
								clientIp: tClientIp,
								agent: req.headers["user-agent"],
							});
						}
					});
				}
			})
		}
		else {
			params.push(req.body);
			var p = null;
			var invokeObj = System.getObject("api." + classPath);
			if (invokeObj[methodName]) {
				p = invokeObj[methodName].apply(invokeObj, params);
			}
			p.then(r => {
				res.end(JSON.stringify(r));
			}).then(() => {
				if (req.body.appKey != 'undefined' && req.body.appKey != "" && req.body.appKey != null) {
					apitradeSvr.create({
						appkey: req.body.appKey,
						tradeType: "consume",
						op: classPath + "/" + methodName,
						params: JSON.stringify(req.body),
						clientIp: tClientIp,
						agent: req.headers["user-agent"],
					});
				}
			});
		}
	});
};
