var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
const logCtl=system.getObject("web.oplogCtl");
class yzcApplet extends AppletBase{
   constructor(){
     super();
     this.cacheManager=system.getObject("db.cacheManager");
     this.businesschanceSve=system.getObject("service.businesschanceSve");
     this.orderService=system.getObject("service.orderSve");
     this.userService=system.getObject("service.userSve");
     this.accountService=system.getObject("service.accountSve");
     this.orderService=system.getObject("service.orderSve");
     this.shopSve=system.getObject("service.shopSve");
     this.wxminiSve=system.getObject("service.wxminiSve");
     this.connectionbh=system.getObject("db.connection").getConhb();
     this.customerinfoSve=system.getObject("service.customerinfoSve");
     this.usercustomerSve=system.getObject("service.usercustomerSve");
     this.utilstmSve=system.getObject("service.utilstmSve");
     this.utilsicSve=system.getObject("service.utilsicSve");
     this.utilscopyrightSve=system.getObject("service.utilscopyrightSve");
     this.utilspaSve=system.getObject("service.utilspaSve");
     this.trademarkSve=system.getObject("service.trademarkSve");
     this.tmflowSve=system.getObject("service.tmflowSve");
     this.servicesitemSve=system.getObject("service.servicesitemSve");
   }

   //获取商标列表=post
   async getTmShortList(obj,req){
     var that=this;
     var tms=await this.utilstmSve.tmSearch(req,"yzcApplet");
     var nclstr='';
     var nclone='';
     var picurl='';
     var tmname='';
     var endday='';
     console.log(tms.data[0]);
     for(var i=0;i< tms.data.length;i++){
       var r={};
       picurl=tms.data[i].pic_url;
       tmname=tms.data[i].tm_name;
       endday=tms.data[i].tm_end_day;
       nclone+=tms.data[i].ncl_one_codes+' ';
       r.nclone_code=tms.data[i].ncl_one_codes;
       r.reg_num=tms.data[i].tm_regist_num;
       var ncllast=await that.utilstmSve.getTmNclSmallCodes(r,"yzcApplet");
       if(ncllast.data.length>0)
       {
         for(var j=0;j< ncllast.data.length;j++){
           nclstr += ncllast.data[j].ncl_last+' ';
         }
       }
     }
     var source={
       name:tmname,
       mobile_pic:picurl,
       ncl_one_codes:nclone,
       short_desc:nclstr,
       tm_expiration_date:endday
     };
     return {code:1,msg:'查询成功',data:source};
   }

   //获取商标列表=post
   async test(){
     var self=this;
     var tmlist=await this.servicesitemSve.dao.model.findAll();
     var req={};
     req.reg_num=tmlist[0].code;
     await this.db.transaction(async function (t){
       var req={};
       for(var k=0;k< tmlist.length;k++){
          req.reg_num=tmlist[k].code;
          var tms=await self.utilstmSve.tmSearch(req,"yzcApplet");
          var nclstr='';
          var nclone='';
          var picurl='';
          var tmname='';
          var endday='';
          if(tms.data){
            for(var i=0;i< tms.data.length;i++){
              var r={};
              picurl=tms.data[i].pic_url;
              tmname=tms.data[i].tm_name;
              endday=tms.data[i].tm_end_day;
              nclone+=tms.data[i].ncl_one_codes+' ';
              r.nclone_code=tms.data[i].ncl_one_codes;
              r.reg_num=tms.data[i].tm_regist_num;
              var ncllast=await self.utilstmSve.getTmNclSmallCodes(r,"yzcApplet");
              if(ncllast.data){
                for(var j=0;j< ncllast.data.length;j++){
                  nclstr += ncllast.data[j].ncl_last+' ';
                }
              }
            }
            tmlist[k].name=tmname;
            tmlist[k].mobilePic=picurl;
            tmlist[k].nclOneCodes=nclone;
            tmlist[k].shortDesc=nclstr;
            var date = new Date(endday * 1000);//时间戳为10位需*1000，时间戳为13位的话不需乘1000
            var Y = date.getFullYear() + '-';
            var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
            var D = date.getDate() + ' ';
            tmlist[k].tmExpirationDate=Y+M+D;
            await self.servicesitemSve.dao.update(tmlist[k].dataValues);
          }

       }

     })

   }

   //获取商标小类=post
   async getTmNclSmallCodes(obj,req){
     var openid = req.openid;
     if(openid==null||openid==""||openid=="undefined"){
         return System.getResult2(null,null,null,"openid参数有误");
     }
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     if(userInfo=="null"||userInfo==""){
         return system.getResult2(null,null,null,"用户信息有误");
     }
      return this.utilstmSve.getTmNclSmallCodes(req,"bossShopApplet");
   }
  //产品上架
  async addServicesitem(obj,req){
    try {
        var openid = req.openid;
        if(openid==null||openid==""||openid=="undefined"){
            return System.getResult2(null,null,null,"openid参数有误");
        }
        var result=await this.servicesitemSve.addServicesitem(req);
    　　return result;

    } catch (e) {
      console.log(e.stack);
      //日志记录
      logCtl.error({
         optitle:"产品上架异常,openid="+obj.openid,
         op:"wxapplet/impl/yzcApplet/addServicesitem",
         content:e.stack,
         clientIp:""
       });
      return {
           code: -200,
           message: "error",
           data: []
        };

    } finally {

    }

  }

  async edittmsell(obj,req){
    try {
      var openid = req.openid;
      if(openid==null||openid==""||openid=="undefined"){
          return {code:-200,message: "openid错误",data: null};
      }
    　var code=req.code;
     var tm=await this.servicesitemSve.findOne({code:code});
     if(tm){
       if(tm.isPubed==0){
         tm.isPubed=1;
       }else if(tm.isPubed==1){
         tm.isPubed=0;
       }
      var r=await this.servicesitemSve.dao.update(tm.dataValues);
      return {code: 1,message: "修改成功",data: null};
     }else {
       return {code: 1,message: "商标不存在",data: null};
     }

    } catch (e) {
      console.log(e.stack);
      //日志记录
      logCtl.error({
         optitle:"产品上架状态修改异常,openid="+req.openid,
         op:"wxapplet/impl/yzcApplet/addServicesitem",
         content:e.stack,
         clientIp:""
       });
      return {
           code: -200,
           message: "error",
           data: []
        };
    }
  }
//修改产品销售状态
  async edittmsellstatus(obj,req){
    try {
      var openid = req.openid;
      if(openid==null||openid==""||openid=="undefined"){
          return {code:-201,message: "openid错误",data: null};
      }
    　var code=req.code;
      if(code==null||code==""||code=="undefined"){
          return {code:-202,message: "code错误",data: null};
      }
     var tm=await this.servicesitemSve.findOne({code:code});
     if(tm){
       if(tm.sellStatus=='1'){
         tm.sellStatus='2';
         tm.isPubed=0;
       }else if(tm.sellStatus=='2'){
         tm.sellStatus='1';
       }
      var r=await this.servicesitemSve.dao.update(tm.dataValues);
      return {code: 1,message: "修改成功",data: null};
     }else {
       return {code: 1,message: "商标不存在",data: null};
     }
    } catch (e) {
      console.log(e.stack);
      //日志记录
      logCtl.error({
         optitle:"销售状态修改异常,openid="+req.openid,
         op:"wxapplet/impl/yzcApplet/edittmsellstatus",
         content:e.stack,
         clientIp:""
       });
      return {
           code: -200,
           message: "error",
           data: []
        };
    }
  }
   //获取商标交易列表=get
   async getServicesItemList(obj,req){
     try {
          return await this.servicesitemSve.getServicesItemList(obj);
     } catch (e) {
       //日志记录
       logCtl.error({
          optitle:"获取用户渠道列表异常,openid="+obj.openid,
          op:"wxapplet/impl/yzcApplet/getServicesItemList",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            message: "error",
            data: null
         };
     }
   }
   //获取商标交易详情=get
   async getServicesItemDetail(obj,req){
     try {
          return await this.servicesitemSve.getServicesItemDetail(obj);
     } catch (e) {
       //日志记录
       logCtl.error({
          optitle:"获取用户渠道列表异常,openid="+obj.openid,
          op:"wxapplet/impl/yzcApplet/getServicesItemDetail",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            message: "error",
            data: null
         };
     }
   }

   //客户搜索商标交易产品列表=post//1用户，2管理人员
   async getQueryServiceItemList(obj,req){
     try {
       req.usertype=1;
       return await this.shopSve.getServiceItemList(req);
     } catch (e) {
       //日志记录
       logCtl.error({
          optitle:"产品列表异常,openid="+obj.openid+"，onlycode="+obj.onlycode,
          op:"base/wxapplet/impl/yzcApplet/getQueryServiceItemList",
          content:e.stack,
          clientIp:""
        });

       return {
            code: -200,
            message: "error",
            data: []
         };
     }
   }

　　//根据行业查询对应大类
   async aiadive(obj,req){
     try {
       var openid = obj.openid;
       if(openid==null||openid==""||openid=="undefined"){
           return {code:-200,message: "openid错误",data: null};
       }
       var industry = obj.industry;
       var sql='select req from h_aiadive where search="'+ industry + '"';
       var tmpResult=await this.userService.dao.customQuery(sql);
       var nclinfo=[];
       tmpResult.forEach(n=>{
         n.req=n.req.replace(/'/g,"\"");
         var a=JSON.parse(n.req);
         nclinfo.push(a.code);
       })
       return {code: 1,message: "查询成功",data: nclinfo};
     } catch (e) {
       //日志记录
       logCtl.error({
          optitle:"行业查询对应大类异常,openid="+obj.openid,
          op:"base/wxapplet/impl/yzcApplet/aiadive",
          content:e.stack,
          clientIp:""
        });

       return {
            code: -200,
            message: "error",
            data: []
         };
     } finally {

     }


   }
}
module.exports=yzcApplet;
// var test = new yzcApplet();
// var obj = {
//   code:"30553566",
//   openid:"oOwzN4gU61mvc1A3b5q7Sz7OrBZU"
// }
// test.edittmsellstatus({},obj).then(res=>{
//   console.log(res);
// }).catch(e=>{
//   console.log(e);
// })
