var system=require("../../system")
const http=require("http")
var fs=require("fs");
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
const logCtl=system.getObject("web.oplogCtl");
class yjsApplet extends AppletBase{
   constructor(){
     super();
     this.channelcustomerSve=system.getObject("service.channelcustomerSve");
     this.ossClient=system.getObject("util.ossClient");
   }
  //保存客户
  async saveCustomer(gobj,pobj){
    try {
      var result=await this.channelcustomerSve.save(pobj);
    　return result;
    } catch (e) {
      console.log(e.stack);
      //日志记录
      logCtl.error({
         optitle:"保存客户异常,openid="+obj.openid,
         op:"wxapplet/impl/yjsApplet/saveCustomer",
         content:e.stack,
         clientIp:""
       });
      return {
           code: -200,
           message: "error",
           data: []
      };

    }
  }

  async getQr(obj){//yjs
    var that=this;
    var openid = obj.openid;
    var result={
       code: 1,
       message: "success",
       data: ""
    };
    if(openid==null||openid==""||openid=="undefined"){
      result.code=-101;
      result.message="openid参数有误";
      return result;
    }
    var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
    console.log(userInfo);
    if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
      result.code=-102;
      result.message="用户信息有误";
      return result;
    }
    userInfo=JSON.parse(userInfo);
    try {
      var rtn=null;
      var url = "https://m.yylending.com/#/partners/signup?userId=frkX%20jypUdhTj4N1xpxyTWi7g%2F1MRopgQtksGxZJ0Gs%3D&isOnline=true&carrier=app&channelCode=gongsibao&openid=" + openid;
      url = encodeURIComponent(url);
      url = "http://bigdata.gongsibao.com/api/qc?detailLink=" + url;
      rtn=await this.rc.execGet2({},url);
      var base64 = rtn.stdout;
      if(base64){
        var img = base64;
        var fileName = "qr_yjs_"+new Date().getTime()+openid+".png";
        var filePath = '/tmp/' + fileName;
        var dataBuffer = new Buffer(img, 'base64');
        var r = await this.writeFile(filePath, dataBuffer);
        if(r=="success"){
          console.log(fileName);
          console.log(filePath);
          var re= await that.ossClient.upfile(fileName,filePath);
          fs.unlink(filePath,e=>{
            console.log("fail");
          });
          console.log(re.url);
          result.data = re.url;
          return result;
        }else{
          result.code=-103;
          result.message="获取二维码失败";
          return result;
        }
      }
    } catch (e) {
      //日志记录
      console.log(e);
      logCtl.error({
         optitle:"getQr异常,",
         op:"wxapplet/impl/yjsApplet/getQr",
         content:e.stack,
         clientIp:""
      });
      return {
         code: -200,
         message: "error"
      };
    }
  }
  async writeFile(filePath,dataBuffer){
    var promise=new Promise(function(resv,rej){
      fs.writeFile(filePath, dataBuffer,function (err, data) {
          if (err) {
            rej(err);
              // console.log(err);
          }else{
            resv("success");
          }

      });
    });
    return promise;
  }

}
module.exports=yjsApplet;
// var test = new yjsApplet();
// var obj={openid:"testopenid"};
// test.getQr(obj).then(res=>{
//   console.log(res);
// }).catch(e=>{
//   console.log(e);
// })
