var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
const logCtl=system.getObject("web.oplogCtl");
class walletApplet extends AppletBase{
   constructor(){
     super();
     this.userService=system.getObject("service.userSve");
     this.orderService=system.getObject("service.orderSve");
     this.accountService=system.getObject("service.accountSve");
     this.tradeService=system.getObject("service.tradeSve");
     this.partnerInfoService=system.getObject("service.partnerinfoSve");
     this.profitcenterService=system.getObject("service.profitcenterSve");
   }
   async withdrawRecord(obj,req){
     console.log("---------------------withdrawRecord------------------------------");
     var openid = obj.openid;
     console.log(openid);
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     if(userInfo){
       userInfo=JSON.parse(userInfo);
       console.log(userInfo);
       var accountId=userInfo.account_id;

       var data={};
       console.log("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
       console.log(obj.searchName);
       if(obj.searchName && obj.searchName!="undefined"){
         data[this.db.Op.and]=[
              {account_id:accountId},
              {[this.db.Op.or]:[{userName:{[this.db.Op.like]:"%"+obj.searchName+"%" }}, {totalSum:{[this.db.Op.like]:"%"+obj.searchName+"%" }}]}
            ];
       }else{
         data={
           account_id:accountId
         };
       }
       console.log("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
       console.log(data);
       var withdraws = await this.profitcenterService.findAllwithdrawRecord(data);
       console.log(withdraws);
       console.log("---------------------withdrawRecord------end------------------------");
       return system.getResult2(withdraws,null);
     }else{
       return system.getResult2(null,null);
     }
   }
   async finishWithdrawInfo(obj,req){
     console.log("---------------finishWithdrawInfo------------------------")
     var openid = obj.openid;
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     userInfo=JSON.parse(userInfo);
     var result=await this.tradeService.verifyBankcard(obj.cardNo,obj.identityCard,obj.realName);
     console.log("-----------------------------result");
     console.log(result);
     if(result.code==1){
       console.log("银行卡、开户人、身份证号通过校验");
       var en=await this.partnerInfoService.createPartner(userInfo,obj)
       console.log(en);
       return {code:1,msg:"成功"}
     }else{
       console.log("信息错误，请输入正确的信息")
       return {code:0,msg:"信息错误，请输入正确的信息"}
     }
   }

   async withdrawMoney(obj,req){
     console.log("---------------------withdrawMoney------------------------------");
     console.log(obj)
     var openid = obj.openid;
     var user =await this.cacheManager["AppletUserinfoCache"].get(openid);
     user=JSON.parse(user);
     console.log(user);
     if(user=="null"){
       return {code:-90,msg:"用户信息为空"}
     }
     var partnerinfo=await this.partnerInfoService.findpartnerinfo({onlyCode:user.onlyCode});
     if(partnerinfo==null){
       return {code:-100,msg:"合伙人信息为空"}
     }
     if(partnerinfo.identityCard==null||partnerinfo.cardNo==null||partnerinfo.realName==null){
       return {code:-110,msg:"合伙人信息为空"}
     }
     if(obj.money<=0||obj.money==null){
       return {code:-130,msg:"输入的金额有误"}
     }
     try{
       //提现日期范围是否有限制
       var pconfig=await this.cacheManager["PConfigCache"].cachePConfig();
       if(pconfig!=null||pconfig!="undefined"){
         var result= pconfig.find(item => {
             return item.configType === "withdrawalData";
         });
         if(result!=null&&result.configValue!="-1"){
           var withdrawalData= result.configValue.split('-');
           if(withdrawalData.length==2){
             var myDate=new Date();
             var nowDay= myDate.getDate()
             if(nowDay>withdrawalData[1]||nowDay<withdrawalData[0]){
               return {code:-170,msg:"不在提现日期内，提现日期为每月的 "+withdrawalData[0]+"号到 "+withdrawalData[0]+"号"};
             }
           }
         }
       }//提现日期范围有限制
       var amount=obj.money;
       var trade=await this.tradeService.withdrawMoney(user,partnerinfo,amount);
       return trade;
     }catch(e){
       //日志记录
      logCtl.error({
         optitle:"提现申请异常",
         op:"wxapplet/impl/walletApplet/withdrawMoney",
         content:e.stack,
         clientIp:""
       });
       return {code:-200,msg:"提现申请失败"};
     }

   }
   async withdrawApply(obj,req){
     console.log("---------------------withdrawApply------------------------------");
     var openid = obj.openid;
     console.log(openid);
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     userInfo=JSON.parse(userInfo);
     var onlyCode={onlyCode:userInfo.onlyCode};
     var partnerinfo=await this.partnerInfoService.findpartnerinfo(onlyCode);
     console.log("--------------------------partnerinfo-----------------")
     console.log(partnerinfo);
     if(partnerinfo==null||partnerinfo==""){
       return {code:0,msg:"提现所需要的身份证号、银行卡号、开户人姓名信息不完整"}
     }else{
       return {code:1,msg:"提现信息完整"}
     }
   }
   async getMyBalance(obj,req){
     var openid = obj.openid;
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     if(userInfo){
       userInfo=JSON.parse(userInfo);
       var account = await this.accountService.findById(userInfo.account_id);
       return account;
     }else{
       return {errMsg:"err"};
     }

   }

   async getMyTrades(obj,req){
     console.log("--------------------------------------getMyTrades")
     console.log(obj);
     var openid = obj.openid;
     console.log(openid);
     var userinfo = await this.getUserInfo(openid);
     if(userinfo){
       userinfo=JSON.parse(userinfo);
       console.log(userinfo.account_id);
       if(obj.title=="all"){
         var trades = await this.tradeService.dao.model.findAll({where:{account_id:userinfo.account_id,tradeType:["fill","consume","gift","giftMoney","orderPersonFee","recommendFee","tmSubDeductCoin","cashWithdrawal"]},raw:true});
         console.log("-------------------------------------trades")
         console.log(trades);
       };
       if(obj.title=="bao"){
         var trades = await this.tradeService.dao.model.findAll({where:{account_id:userinfo.account_id,tradeType:["fill","consume","gift","tmSubDeductCoin"]},raw:true});
         console.log("-------------------------------------trades")
         console.log(trades);
       };
       if(obj.title=="ren"){
         var trades = await this.tradeService.dao.model.findAll({where:{account_id:userinfo.account_id,tradeType:["giftMoney","orderPersonFee","recommendFee","cashWithdrawal"]},raw:true});
         console.log("-------------------------------------trades")
         console.log(trades);
       };
       return trades;
     }else{
       return {msg:"fail"};
     }
   }

}
module.exports=walletApplet;
