var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
const logCtl=system.getObject("web.oplogCtl");
class tmpApplet extends AppletBase{
   constructor(){
     super();
     this.userSve=system.getObject("service.userSve");
     this.msghistorySve=system.getObject("service.msghistorySve");
     this.msgnoticeSve = system.getObject("service.msgnoticeSve");
   }

   //卖公司添加=post
   async getUser(obj,req){
     var result={
        code: 1,
        message: "success"
     };

     try {
       console.log(req.userId, "---------------------- userId --------------------------");
       result.data = await this.userSve.findById(req.userId);
       return result;
     } catch (e) {
       console.log("查用戶:error*****************************************************************************");
       console.error(e.stack);
       //日志记录
       logCtl.error({
          optitle:"查用戶, userId=" + req.userId,
          op:"wxapplet/impl/mryzApplet/getUser",
          content:e.stack,
          clientIp:req.clientIp
        });
       return {
            code: -200,
            message: "error",
            data: {}
         };
     }
   }
   // 推送执照信息
   async businessLicenseMsg(obj, req) {
     var result = {
        code: 1,
        message: "success"
     };

     try {
       console.log(req.senderId, req.targetId, req.businessLicense_id, "---------------------- businessLicenseMsg params --------------------------");
       result.data = await this.msghistorySve.pushBusinessLicenseMsg(req.senderId, req.targetId, req.businessLicense_id);
       return result;
     } catch (e) {
       console.log("推送执照信息:error*****************************************************************************");
       console.error(e.stack);
       //日志记录
       logCtl.error({
          optitle:"推送执照信息, senderId=" + req.senderId + ", targetId=" + req.targetId + ", businessLicense_id=" + req.businessLicense_id,
          op:"wxapplet/impl/mryzApplet/getChatList",
          content:e.stack,
          clientIp:req.clientIp
        });
       return {
            code: -200,
            message: "error",
            data: {}
         };
     }
   }

   // 查询聊天记录
   async getChatList(obj, req) {
     var result = {
        code: 1,
        message: "success"
     };

     try {
       console.log(req.senderId, req.targetId, req.maxId, "---------------------- getChatList params --------------------------");
       result.data = await this.msghistorySve.getChatList(Number(req.senderId), Number(req.targetId), Number(req.maxId), 10);
       await this.msghistorySve.setRead(req.targetId, req.senderId);
       return result;
     } catch (e) {
       console.log("查聊天记录:error*****************************************************************************");
       console.error(e.stack);
       //日志记录
       logCtl.error({
          optitle:"查聊天记录, senderId=" + req.senderId + ", targetId=" + req.targetId + ", maxId=" + req.maxId,
          op:"wxapplet/impl/mryzApplet/getChatList",
          content:e.stack,
          clientIp:req.clientIp
        });
       return {
            code: -200,
            message: "error",
            data: {}
         };
     }
   }

   async getFriendList(obj, req) {
     var result = {
        code: 1,
        message: "success"
     };

     try {
       console.log(req.userId, "---------------------- getFriendList params --------------------------");
       result.data = await this.msgnoticeSve.getUserList(Number(req.userId));

       return result;
     } catch (e) {
       console.log("查询好友列表:error*****************************************************************************");
       console.error(e.stack);
       //日志记录
       logCtl.error({
          optitle:"查询好友列表, senderId=" + req.userId,
          op:"wxapplet/impl/mryzApplet/getFriendList",
          content:e.stack,
          clientIp:req.clientIp
        });
       return {
            code: -200,
            message: "error",
            data: {}
         };
     }
   }

   async readMsg(obj, req) {
     var result = {
        code: 1,
        message: "success"
     };

     try {
       console.log(req.msgId, "---------------------- readMsg params --------------------------");
       result.data = await this.msghistorySve.readMsg(Number(req.userId));
       return result;
     } catch (e) {
       console.log("标记消息已读:error*****************************************************************************");
       console.error(e.stack);
       //日志记录
       logCtl.error({
          optitle:"标记消息已读, msgId=" + req.msgId,
          op:"wxapplet/impl/mryzApplet/readMsg",
          content:e.stack,
          clientIp:req.clientIp
        });
       return {
            code: -200,
            message: "error",
            data: {}
         };
     }
   }
}
module.exports=tmpApplet;
