var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const AppletBase = require("../applet.base");
const logCtl = system.getObject("web.oplogCtl");
class mryzApplet extends AppletBase {
  constructor() {
    super();
    this.channelSve = system.getObject("service.channelSve");
    this.pagestatisticsSve = system.getObject("service.pagestatisticsSve");
    this.businesslicenseSve = system.getObject("service.businesslicenseSve");
    this.buybusinesslicenseSve = system.getObject("service.buybusinesslicenseSve");
    this.servicetypeSve = system.getObject("service.servicetypeSve");

    // add by wangkun begin
    this.userSve = system.getObject("service.userSve");
    this.msghistorySve = system.getObject("service.msghistorySve");
    this.msgnoticeSve = system.getObject("service.msgnoticeSve");
    // add by wangkun end

    this.mryzprice = system.getObject("util.mryzprice");

  }
  //获取公司类型=get
  async getServiceTypeList(obj, req) {
    try {
      var tResult = await this.isChecOpenId(obj);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.servicetypeSve.getListByPid(obj);
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/getServiceTypeList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }
  //搜索公司类型=get
  async searchServiceType(obj, req) {
    try {
      var tResult = await this.isChecOpenId(obj);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.servicetypeSve.getListByName(obj);
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/searchServiceType",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //页面统计----=post
  async addPageStatistics(obj, req) {
    var openid = req.openid;
    var onlycode = req.onlycode;
    var code = req.code;
    var tjCode = req.tj_code;
    var check_exist = req.check_exist || 1;
    try {
      var result = {
        code: 1,
        message: "success",
        shopNum: "",
        data: []
      };
      if (check_exist != 1 && check_exist != 2) {
        result.code = -101;
        result.message = "check_exist参数有误";
        return result;
      }
      if (openid == null || openid == "" || openid == "undefined") {
        result.code = -102;
        result.message = "openid不能为空";
        return result;
      }
      if (onlycode == null || onlycode == "" || onlycode == "undefined") {
        onlycode = null;
      }
      if (code == null || code == "" || code == "undefined") {
        result.code = -104;
        result.message = "易照操作码code不能为空";
        return result;
      }
      if (tjCode == null || tjCode == "" || tjCode == "undefined") {
        result.code = -105;
        result.message = "tjCode不能为空";
        return result;
      }
      var userInfo = await this.cacheManager["AppletUserinfoCache"].get(openid);
      if (userInfo == "null" || userInfo == "") {
        result.code = -106;
        result.message = "用户信息有误";
        return result;
      }

      var tUserInfo = JSON.parse(userInfo);

      if (tjCode == 'mryz_sellsc' || tjCode == 'mryz_sellfw') {
        var bl = await this.businesslicenseSve.findOne({
          opCode: code
        });
        if (bl.onlyCode == tUserInfo.onlyCode) {
          result.code = -107;
          result.message = "不能统计收藏或者访问自己发布的执照";
          return result;
        }
      }
      //目标唯一码（公司的唯一码）
      tUserInfo.target_only_code = onlycode;
      //易照操作码opCode
      tUserInfo.item_code = code;
      //统计类型编码
      tUserInfo.statistics_code = tjCode;
      tUserInfo.client_ip = req.clientIp;
      return this.pagestatisticsSve.add(tUserInfo, result, check_exist);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "移动商城统计操作异常,openid=" + openid + "，code=" + code + "，onlycode=" + onlycode + "statistics_code=" + tjCode,
        op: "wxapplet/impl/mryzApplet/addPageStatistics",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: null
      };
    }
  }

  //删除某个用户统计编码对应的 itemCode=post
  async delUserStatistics(obj, req) {
    var openid = req.openid;
    var code = req.code;
    var tjCode = req.tj_code;
    try {
      var result = {
        code: 1,
        message: "success",
        shopNum: "",
        data: []
      };
      if (openid == null || openid == "" || openid == "undefined") {
        result.code = -101;
        result.message = "openid不能为空";
        return result;
      }
      if (code == null || code == "" || code == "undefined") {
        result.code = -102;
        result.message = "易照操作码code不能为空";
        return result;
      }
      if (tjCode == null || tjCode == "" || tjCode == "undefined") {
        result.code = -103;
        result.message = "tjCode不能为空";
        return result;
      }
      var userInfo = await this.cacheManager["AppletUserinfoCache"].get(openid);
      if (userInfo == "null" || userInfo == "") {
        result.code = -104;
        result.message = "用户信息有误";
        return result;
      }
      var tUserInfo = JSON.parse(userInfo);
      this.pagestatisticsSve.delUserStatistics(tUserInfo.onlyCode, code, tjCode);
      return result;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "移动商城统计操作异常,openid=" + openid + "，code=" + code + "，onlycode=" + onlycode + "statistics_code=" + tjCode,
        op: "wxapplet/impl/mryzApplet/addPageStatistics",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: null
      };
    }
  }

  //修改用户(user表)公司的唯一码
  async putCompanyOnlyCode(obj, req) {
    try {
      var result = {
        code: 1,
        message: "success",
        data: []
      };
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      var tCompanyOnlyCode = req.company_only_code || "";
      if (tCompanyOnlyCode == null || tCompanyOnlyCode == "" || tCompanyOnlyCode == "undefined") {
        result.code = -101;
        result.message = "company_only_code参数有误";
        return result;
      }
      if (tResult.user.companyOnlyCode == tCompanyOnlyCode) {
        result.code = -102;
        result.message = "公司码一样，无需修改";
        return result;
      }
      return await this.businesslicenseSve.putUserCompanyOnlyCode(req.openid, tResult.user.id, tCompanyOnlyCode, result);
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/sellCoputCompanyOnlyCodempanyAdd",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //************************************************************卖公司********************开始***************************************

  //卖公司添加=post
  async sellCompanyAdd(obj, req) {
    try {
      var tResult = await this.addIsCheckParmer(req);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.businesslicenseSve.addCompany(req, tResult.user, tResult.channel);
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/sellCompanyAdd",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }
  //获取卖公司的列表
  async getSellCompanyList(obj, req) {
    try {
      var tResult = await this.isChecOpenId(obj);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.businesslicenseSve.getList(obj, tResult.user);
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/sellCompanyAdd",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 设置/取消推荐=post
  async setRecommend(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.businesslicenseSve.setRecommend(req.opCode, req.recommend);
      return result;
    } catch (e) {
      console.log("设置/取消推荐异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "设置/取消推荐异常,openid=" + req.openid + "，channelCode=" + req.opCode + "recommend=" + req.recommend,
        op: "wxapplet/impl/mryzApplet/setRecommend",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }


  //获取卖公司的列表
  async countLicenseByCompany(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.businesslicenseSve.countLicenseByCompany(tResult.user.id);
      return result;
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid,
        op: "wxapplet/impl/mryzApplet/countLicenseByCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }


  async countAllLicense(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.businesslicenseSve.countAllLicense(tResult.user.id);
      return result;
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid,
        op: "wxapplet/impl/mryzApplet/countAllLicense",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //获取卖公司的详情
  async getSellCompanyDetail(obj, req) {
    try {
      var tResult = await this.isChecOpenId(obj);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.businesslicenseSve.getDetailByOpCode(tResult.user, obj.op_code, obj.type);
    } catch (e) {
      console.log("卖公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "卖公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/sellCompanyAdd",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //获取卖公司的详情
  async getblCompany(obj, req) {
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      return await this.businesslicenseSve.getDetailById(req.businessLicense_id);
    } catch (e) {
      console.log("获取卖公司信息:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "获取卖公司信息,openid=" + req.openid + "businessLicense_id=" + req.businessLicense_id,
        op: "wxapplet/impl/mryzApplet/getblCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //执照上架=post
  async onLineSellCompany(obj, req) {
    var result = {
      code: 1,
      message: "success",
      user: {},
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.businesslicenseSve.updateIsPubed(req.opCode, true);
      return result;
    } catch (e) {
      console.log("执照上架异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "执照上架异常, openid=" + req.openid + ", opCode=" + req.opCode,
        op: "wxapplet/impl/mryzApplet/onLineSellCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 执照下架=post
  async offLineSellCompany(obj, req) {
    var result = {
      code: 1,
      message: "success",
      user: {},
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.businesslicenseSve.updateIsPubed(req.opCode, false, req.notes);
      return result;
    } catch (e) {
      console.log("执照下架异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "执照下架异常, openid=" + req.openid + ", opCode=" + req.opCode + ", notes=" + req.notes,
        op: "wxapplet/impl/mryzApplet/offLineSellCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 删除=post
  async delSellCompany(obj, req) {
    var result = {
      code: 1,
      message: "success",
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.businesslicenseSve.delete(req.opCode);
      return result;
    } catch (e) {
      console.log("执照删除异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "执照删除异常, openid=" + req.openid + ", opCode=" + req.opCode,
        op: "wxapplet/impl/mryzApplet/delSellCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //************************************************************卖公司********************结束***************************************

  //************************************************************买公司********************开始***************************************

  //买公司添加=post
  async buyCompanyAdd(obj, req) {
    try {
      var tResult = await this.addIsCheckParmer(req);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.buybusinesslicenseSve.addCompany(req, tResult.user, tResult.channel);
    } catch (e) {
      console.log("买公司添加异常:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "买公司添加异常,openid=" + req.openid + "，channelCode=" + req.channel_code,
        op: "wxapplet/impl/mryzApplet/buyCompanyAdd",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 我的需求=post
  async myBuyCompanyList(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.buybusinesslicenseSve.listByUser(tResult.user.onlyCode, req.pageIndex || 0, req.pageSize || 10);
      return result;
    } catch (e) {
      console.log("我的需求查询异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "我的需求查询异常,openid=" + req.openid,
        op: "wxapplet/impl/mryzApplet/myBuyCompanyList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }


  //获取卖公司的详情
  async getbuyCompany(obj, req) {
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      return await this.buybusinesslicenseSve.getDetailById(req.buybusinessLicense_id);
    } catch (e) {
      console.log("获取卖公司信息:error*****************************************************************************");
      console.log(e.stack);
      //日志记录
      logCtl.error({
        optitle: "获取卖公司信息,openid=" + req.openid + "buybusinessLicense_id=" + req.buybusinessLicense_id,
        op: "wxapplet/impl/mryzApplet/getblCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 需求详情=post
  async getBuyCompanyDetail(obj, req) {
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      return await this.buybusinesslicenseSve.getDetailByOpCode(tResult.user.onlyCode, req.op_code);
    } catch (e) {
      console.log("需求详情异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "需求详情异常,openid=" + req.openid + "，channelCode=" + req.op_code,
        op: "wxapplet/impl/mryzApplet/getBuyCompanyDetail",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 删除=post
  async delBuyCompany(obj, req) {
    var result = {
      code: 1,
      message: "success",
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.buybusinesslicenseSve.delete(req.opCode);
      return result;
    } catch (e) {
      console.log("执照删除异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "执照删除异常, openid=" + req.openid + ", opCode=" + req.opCode,
        op: "wxapplet/impl/mryzApplet/delBuyCompany",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // TODO 智能推荐
  //************************************************************我的需求********************结束***************************************

  //************************************************************我的收藏********************开始***************************************
  // 我的收藏列表=post
  async myCollectList(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }
      result.data = await this.pagestatisticsSve.userCollectList(tResult.user.id, req.pageIndex || 0, req.pageSize || 10);
      return result;
    } catch (e) {
      console.log("我的收藏列表异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "我的收藏列表异常,openid=" + req.openid + ", pageIndex=" + req.pageIndex + ", pageSize=" + req.pageSize,
        op: "wxapplet/impl/mryzApplet/myCollectList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 我的收藏删除=post
  async delMyCollect(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.pagestatisticsSve.delUserCollect(tResult.user.id, req.collectid);
      return result;
    } catch (e) {
      console.log("我的收藏删除异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "我的收藏删除异常,openid=" + req.openid + ", delcollectid=" + req.collectid,
        op: "wxapplet/impl/mryzApplet/delMyCollect",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }
  //************************************************************我的收藏********************结束***************************************

  //************************************************************历史来访********************开始***************************************
  // 历史访问=post
  async historyVisits(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      var params = {
        user : tResult.user,
        userId : tResult.user.id,
        opCode : req.opCode,
        type : req.type || 0
      }

      result.data = await this.pagestatisticsSve.historyVisits(params, req.pageIndex || 0, req.pageSize || 10);
      return result;
    } catch (e) {
      console.log("历史访问异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "历史访问异常,openid=" + req.openid + ", pageIndex=" + req.pageIndex + ", pageSize=" + req.pageSize,
        op: "wxapplet/impl/mryzApplet/historyVisits",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }


  //************************************************************历史来访********************结束***************************************


  //************************************************************用户数据(超管)********************开始***************************************
  // getRoles(超管)
  async getRoles(obj, req) {
    return {
      code: 1,
      message: "success",
      data: [{
          name: "普通代理",
          code: "yz_agent"
        },
        {
          name: "代理管理员",
          code: "yz_agent_admin"
        },
        {
          name: "大照商",
          code: "yz_big_business"
        }
      ]
    };
  }
  // 用户数量(超管)
  async countUserSuper(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.countUserSuper(tResult.user.id, tResult.user.app_id);
      return result;
    } catch (e) {
      console.log("用户数量(超管)异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "用户数量(超管)异常,openid=" + req.openid,
        op: "wxapplet/impl/mryzApplet/countUserSuper",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 用户列表(超管)
  async listUserSuper(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      var param = {
        userId: tResult.user.id,
        search: req.search || "",
        code: req.code || "",
        pageIndex: req.pageIndex || 0,
        pageSize: req.pageSize || 10
      }

      result.data = await this.userSve.listUserSuper(param);
      return result;
    } catch (e) {
      console.log("用户列表(超管)异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "用户列表(超管)异常,openid=" + req.openid + ", param=" + JSON.stringify(param),
        op: "wxapplet/impl/mryzApplet/listUserSuper",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 用户增加角色(代理负责人)
  async addResponsibleRole(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.addResponsibleRole(tResult.user.id, req.userOpenId);
      return result;
    } catch (e) {
      console.log("用户增加角色(超管)异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "用户增加角色(超管)异常,openid=" + req.openid + ", userOpenId=" + req.userOpenId + ", code=" + req.code,
        op: "wxapplet/impl/mryzApplet/addUserRole",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 用户增加角色(超管)
  async addUserRole(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.superAddUserRole(tResult.user.id, req.userOpenId, req.code);
      return result;
    } catch (e) {
      console.log("用户增加角色(超管)异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "用户增加角色(超管)异常,openid=" + req.openid + ", userOpenId=" + req.userOpenId + ", code=" + req.code,
        op: "wxapplet/impl/mryzApplet/addUserRole",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  async delUserRole(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.delUserRole(tResult.user.id, req.userOpenId, req.code);
      return result;
    } catch (e) {
      console.log("用户增加角色(超管)异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "用户增加角色(超管)异常,openid=" + req.openid + ", userOpenId=" + req.userOpenId + ", code=" + req.code,
        op: "wxapplet/impl/mryzApplet/addUserRole",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //************************************************************用户数据(超管)********************结束***************************************


  //************************************************************需求列表(超管&大照商)********************结束***************************************


  // 价格筛选条件(超管, 大照商)
  async getPriceDict(obj, req) {
    return {
      code: 1,
      message: "success",
      data: await this.mryzprice.getPriceDictList()
    };
  }

  // 需求列表(超管, 大照商)
  async buyList(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      var param = {
        userId: tResult.user.id,
        pageIndex: req.pageIndex || 0,
        pageSize: req.pageSize || 10,
        serviceTypeOneId: req.serviceTypeOneId,
        serviceTypeTwoId: req.serviceTypeTwoId,
        created_at: req.publishDate
      }
      if (req.priceCode) {
        param.priceDict = await this.mryzprice.getDict(req.priceCode);
      }

      result.data = await this.buybusinesslicenseSve.buyList(param);
      return result;
    } catch (e) {
      console.log("需求列表(超管, 大照商)异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "需求列表(超管, 大照商)异常,openid=" + req.openid + ", param=" + JSON.stringify(param),
        op: "wxapplet/impl/mryzApplet/buyList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  //************************************************************需求列表(超管&大照商)********************结束***************************************




  //************************************************************买公司********************结束***************************************
  //验证公共参数信息
  async isChecOpenId(param) {
    var result = {
      code: 1,
      message: "success",
      user: {},
    };
    var openId = param.openid;
    if (openId == null || openId == "" || openId == "undefined") {
      result.code = -101;
      result.message = "openid参数有误";
      return result;
    }
    var userInfo = await this.cacheManager["AppletUserinfoCache"].get(openId);
    if (userInfo == "null" || userInfo == "") {
      result.code = -104;
      result.message = "用户信息有误";
      return result;
    }
    result.user = JSON.parse(userInfo);
    return result;
  }
  //验证公共参数信息
  async addIsCheckParmer(param) {
    var result = {
      code: 1,
      message: "success",
      user: {},
      channel: {}
    };
    var openId = param.openid;
    var channelCode = param.channel_code;
    if (openId == null || openId == "" || openId == "undefined") {
      result.code = -101;
      result.message = "openid参数有误";
      return result;
    }
    if (channelCode == null || channelCode == "" || channelCode == "undefined") {
      result.code = -102;
      result.message = "channel_code参数有误";
      return result;
    }
    var channelItem = await this.channelSve.getChannelItem(channelCode);
    if (channelItem == "" || channelItem == null) {
      result.code = -103;
      result.message = "channel_code参数传递错误";
      return result;
    }
    var userInfo = await this.cacheManager["AppletUserinfoCache"].get(openId);
    if (userInfo == "null" || userInfo == "") {
      result.code = -104;
      result.message = "用户信息有误";
      return result;
    }
    result.user = JSON.parse(userInfo);
    result.channel = channelItem;
    return result;
  }

  //************************************************************我的员工********************开始***************************************
  // 我的员工数量=post
  async myStaffCount(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.staffCount(tResult.user.id);
      return result;
    } catch (e) {
      console.log("我的员工数量查询异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "我的员工数量查询异常,openid=" + obj.openid,
        op: "wxapplet/impl/mryzApplet/myStaffCount",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 我的员工列表=post
  async myStaffList(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.staffList(tResult.user.id, req.pageIndex || 0, req.pageSize || 10, req.nickName);
      return result;
    } catch (e) {
      console.log("我的员工列表查询异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "我的员工数量列表异常,openid=" + req.openid,
        op: "wxapplet/impl/mryzApplet/myStaffList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 我的员工详情
  async getStaffDetail(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };
    try {
      result.data = await this.userSve.staffDetail(req.userOpenId);
      return result;
    } catch (e) {
      console.log("查用戶:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "查用戶, userOpenId=" + req.userOpenId,
        op: "wxapplet/impl/mryzApplet/getUser",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }
  // 删除员工=post
  async delStaff(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      var tResult = await this.isChecOpenId(req);
      if (tResult.code != 1) {
        return tResult;
      }

      result.data = await this.userSve.delStaff(tResult.user.id, req.delopenid);
      return result;
    } catch (e) {
      console.log("删除员工异常:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "删除员工异常,openid=" + req.openid + ", delopenid=" + req.delopenid,
        op: "wxapplet/impl/mryzApplet/delStaff",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }
  //************************************************************我的员工********************结束***************************************


  //************************************************************聊天部分api********************开始***************************************
  /*  add by wangkun begin */
  // 获取用户信息
  async getUser(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      console.log(req.userId, "---------------------- userId --------------------------");
      result.data = await this.userSve.findById(req.userId);
      return result;
    } catch (e) {
      console.log("查用戶:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "查用戶, userId=" + req.userId,
        op: "wxapplet/impl/mryzApplet/getUser",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 推送执照信息
  async businessLicenseMsg(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      console.log(req.senderId, req.targetId, req.businessLicense_id, "---------------------- businessLicenseMsg params --------------------------");
      result.data = await this.msghistorySve.pushBusinessLicenseMsg(req.senderId, req.targetId, req.businessLicense_id);
      return result;
    } catch (e) {
      console.log("推送执照信息:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "推送执照信息, senderId=" + req.senderId + ", targetId=" + req.targetId + ", businessLicense_id=" + req.businessLicense_id,
        op: "wxapplet/impl/mryzApplet/getChatList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 聊天记录
  async getChatList(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      console.log(req.senderId, req.targetId, req.maxId, "---------------------- getChatList params --------------------------");
      result.data = await this.msghistorySve.getChatList(Number(req.senderId), Number(req.targetId), Number(req.maxId), 10);

      return result;
    } catch (e) {
      console.log("查聊天记录:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "查聊天记录, senderId=" + req.senderId + ", targetId=" + req.targetId + ", maxId=" + req.maxId,
        op: "wxapplet/impl/mryzApplet/getChatList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }
  async countUnread(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      console.log(req.userId, "---------------------- unreadCount params --------------------------");
      result.data = await this.msgnoticeSve.countUnread(Number(req.userId));

      return result;
    } catch (e) {
      console.log("未读消息数量:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "未读消息数量, senderId=" + req.userId,
        op: "wxapplet/impl/mryzApplet/unreadCount",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 好友列表
  async getFriendList(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      console.log(req.userId, "---------------------- getFriendList params --------------------------");
      result.data = await this.msgnoticeSve.getUserList(Number(req.userId));

      return result;
    } catch (e) {
      console.log("查询好友列表:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "查询好友列表, senderId=" + req.userId,
        op: "wxapplet/impl/mryzApplet/getFriendList",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // 消息标记已读
  async readMsg(obj, req) {
    var result = {
      code: 1,
      message: "success"
    };

    try {
      console.log(req.msgId, "---------------------- readMsg params --------------------------");
      result.data = await this.msghistorySve.readMsg(Number(req.userId), Number(req.msgId));
      return result;
    } catch (e) {
      console.log("标记消息已读:error*****************************************************************************");
      console.error(e.stack);
      //日志记录
      logCtl.error({
        optitle: "标记消息已读, msgId=" + req.msgId + ", userId=" + req.userId,
        op: "wxapplet/impl/mryzApplet/readMsg",
        content: e.stack,
        clientIp: req.clientIp
      });
      return {
        code: -200,
        message: "error",
        data: {}
      };
    }
  }

  // add by wangkun end
  //************************************************************聊天部分api********************结束***************************************

}
module.exports = mryzApplet;