var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const AppletBase =require("../applet.base");
const logCtl=system.getObject("web.oplogCtl");
class jsbApplet extends AppletBase{
   constructor(){
     super();
     this.cacheManager=system.getObject("db.cacheManager");
     this.entiitinfoSve=system.getObject("service.entiitinfoSve");
     this.individualincometaxSve=system.getObject("service.individualincometaxSve");
   }
   // getOrCreateEntIitInfo 创建/获取公司计税信息
   async getOrCreateEntIitInfo(obj,obj2){
     console.log("-----------------------getOrCreateEntIitInfo---------------------------");
     console.log(obj2);
     try {
       return await this.entiitinfoSve.getOrCreateEntIitInfo(obj2);
     } catch (e) {
       //日志记录
       logCtl.error({
          optitle:"创建/获取公司计税信息异常",
          op:"wxapplet/impl/jsbApplet/getOrCreateEntIitInfo",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "创建失败"
       };
     }
     return {code:1,mag:"success"}
   }
   async getIitEntInfo(obj){
     var result= {
          code: 1,
          msg: "success",
          data:{}
     }
     try {
       result.data= await this.entiitinfoSve.dao.model.findOne({where:obj});
       return result;
     } catch (e) {
       logCtl.error({
          optitle:"创建/获取公司计税信息异常",
          op:"wxapplet/impl/jsbApplet/getOrCreateEntIitInfo",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
     }
   }
   //获取用户个税信息
   async getUserIitInfo(obj){
     console.log("-----------------------getUserIitInfo---------------------------");
     console.log(obj);
     try {
       return this.individualincometaxSve.getUserIitInfo(obj);
     } catch (e) {
       logCtl.error({
          optitle:"获取用户个税信息异常",
          op:"wxapplet/impl/jsbApplet/getUserIitInfo",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
     }
   }
   //保存/更新个税计算信息 （每月至多一条数据）
   async saveOrUpdateIIT(obj,obj2){
     console.log("-----------------------saveOrUpdateIIT---------------------------");
     console.log(obj2);
     obj2.answer = JSON.stringify(obj2.answer);
     try {
       return this.individualincometaxSve.saveOrUpdateIIT(obj2);
     } catch (e) {
       logCtl.error({
          optitle:"保存/更新个税计算信息异常",
          op:"wxapplet/impl/jsbApplet/saveOrUpdateIIT",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
     }
   }
   //获取个税统计信息列表(hr)
   async getStatisticIitList(obj){
     var openid = obj.openid;
     var result={
        code: 1,
        message: "success",
        data: {}
     };
     if(openid==null||openid==""||openid=="undefined"){
       result.code=-101;
       result.message="openid参数有误";
       return result;
     }
     console.log(openid);
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     console.log(userInfo);
     if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
       result.code=-105;
       result.message="用户信息有误";
       return result;
     }
     userInfo=JSON.parse(userInfo);
     try {
       var list = await this.entiitinfoSve.dao.model.findAll({where: {user_id: userInfo.id},order: [['statisticalYear', 'DESC'],['statisticalMonth', 'DESC']]});
        console.log(list);
      result.data = list;
      return result;
     } catch (e) {
       logCtl.error({
          optitle:"获取个税统计信息列表(hr)异常",
          op:"wxapplet/impl/jsbApplet/getStatisticIitList",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
    }
   }
   //获取企业iit 统计信息
   async getEntStatisticInfo(obj){
     try {
       return this.individualincometaxSve.getEntStatisticInfo(obj);
     } catch (e) {
       logCtl.error({
          optitle:"获取企业iit 统计信息异常",
          op:"wxapplet/impl/jsbApplet/getEntStatisticInfo",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
    }
   }
   //获取用户个税列表(员工)
   async getUserIitList(obj){
     var openid = obj.openid;
     var result={
        code: 1,
        message: "success",
        data: {}
     };
     if(openid==null||openid==""||openid=="undefined"){
       result.code=-101;
       result.message="openid参数有误";
       return result;
     }
     console.log(openid);
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     console.log(userInfo);
     if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
       result.code=-105;
       result.message="用户信息有误";
       return result;
     }
     userInfo=JSON.parse(userInfo);
     try {
       var list = await this.individualincometaxSve.dao.model.findAll({where: {user_id: userInfo.id},order: [['created_at', 'DESC']]});
        console.log(list);
      result.data = list;
      return result;
     } catch (e) {
       logCtl.error({
          optitle:"获取用户个税列表(员工)异常",
          op:"wxapplet/impl/jsbApplet/getUserIitList",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
    }
   }
   //获取详情信息
   async getIitInfoDetail(obj){

   }
   //删除用户iit记录
   async delUserIit(obj,obj2){

   }
   //下载个税统计
   async downloadData(obj){
     var openid = obj.openid;
     var result={
        code: 1,
        message: "success",
        data: {}
     };
     if(openid==null||openid==""||openid=="undefined"){
       result.code=-101;
       result.message="openid参数有误";
       return result;
     }
     console.log(openid);
     var userInfo =await this.cacheManager["AppletUserinfoCache"].get(openid);
     console.log(userInfo);
     if(userInfo=="null"||userInfo==null||userInfo=="undefined"){
       result.code=-105;
       result.message="用户信息有误";
       return result;
     }
     userInfo=JSON.parse(userInfo);
     try {
       return this.individualincometaxSve.downloadData(obj);
      return result;
     } catch (e) {
       logCtl.error({
          optitle:"下载个税统计异常",
          op:"wxapplet/impl/jsbApplet/downloadData",
          content:e.stack,
          clientIp:""
        });
       return {
            code: -200,
            msg: "操作失败"
       };
    }
   }
}
module.exports=jsbApplet;
// var test = new yzcApplet();
// var obj = {
//   code:"30553566",
//   openid:"oOwzN4gU61mvc1A3b5q7Sz7OrBZU"
// }
// test.edittmsellstatus({},obj).then(res=>{
//   console.log(res);
// }).catch(e=>{
//   console.log(e);
// })
